/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.reporting.model.io.xpp3;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.codehaus.mojo.versions.reporting.model.DependencyInfo;
import org.codehaus.mojo.versions.reporting.model.DependencyReportSummary;
import org.codehaus.mojo.versions.reporting.model.DependencyUpdatesReport;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.EntityReplacementMap;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DependencyUpdatesReportXpp3Reader {
    private boolean addDefaultEntities = true;
    public final ContentTransformer contentTransformer;

    public DependencyUpdatesReportXpp3Reader() {
        this(new ContentTransformer(){

            @Override
            public String transform(String source, String fieldName) {
                return source;
            }
        });
    }

    public DependencyUpdatesReportXpp3Reader(ContentTransformer contentTransformer) {
        this.contentTransformer = contentTransformer;
    }

    private boolean checkFieldWithDuplicate(XmlPullParser parser, String tagName, String alias, Set parsed) throws XmlPullParserException {
        if (!parser.getName().equals(tagName) && !parser.getName().equals(alias)) {
            return false;
        }
        if (!parsed.add(tagName)) {
            throw new XmlPullParserException("Duplicated tag: '" + tagName + "'", parser, null);
        }
        return true;
    }

    private void checkUnknownAttribute(XmlPullParser parser, String attribute, String tagName, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unknown attribute '" + attribute + "' for tag '" + tagName + "'", parser, null);
        }
    }

    private void checkUnknownElement(XmlPullParser parser, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        int unrecognizedTagCount = 1;
        while (unrecognizedTagCount > 0) {
            int eventType = parser.next();
            if (eventType == 2) {
                ++unrecognizedTagCount;
                continue;
            }
            if (eventType != 3) continue;
            --unrecognizedTagCount;
        }
    }

    public boolean getAddDefaultEntities() {
        return this.addDefaultEntities;
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getBooleanValue(s, attribute, parser, null);
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser, String defaultValue) throws XmlPullParserException {
        if (s != null && s.length() != 0) {
            return Boolean.valueOf(s);
        }
        if (defaultValue != null) {
            return Boolean.valueOf(defaultValue);
        }
        return false;
    }

    private byte getByteValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Byte.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a byte", parser, (Throwable)nfe);
                }
            }
        }
        return 0;
    }

    private char getCharacterValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        if (s != null) {
            return s.charAt(0);
        }
        return '\u0000';
    }

    private Date getDateValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getDateValue(s, attribute, null, parser);
    }

    private Date getDateValue(String s, String attribute, String dateFormat, XmlPullParser parser) throws XmlPullParserException {
        if (s != null) {
            String effectiveDateFormat = dateFormat;
            if (dateFormat == null) {
                effectiveDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            if ("long".equals(effectiveDateFormat)) {
                try {
                    return new Date(Long.parseLong(s));
                }
                catch (NumberFormatException e) {
                    throw new XmlPullParserException(e.getMessage(), parser, (Throwable)e);
                }
            }
            try {
                SimpleDateFormat dateParser = new SimpleDateFormat(effectiveDateFormat, Locale.US);
                return dateParser.parse(s);
            }
            catch (ParseException e) {
                throw new XmlPullParserException(e.getMessage(), parser, (Throwable)e);
            }
        }
        return null;
    }

    private double getDoubleValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Double.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, (Throwable)nfe);
                }
            }
        }
        return 0.0;
    }

    private float getFloatValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Float.valueOf(s).floatValue();
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, (Throwable)nfe);
                }
            }
        }
        return 0.0f;
    }

    private int getIntegerValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be an integer", parser, (Throwable)nfe);
                }
            }
        }
        return 0;
    }

    private long getLongValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Long.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a long integer", parser, (Throwable)nfe);
                }
            }
        }
        return 0L;
    }

    private String getRequiredAttributeValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        if (s == null && strict) {
            throw new XmlPullParserException("Missing required value for attribute '" + attribute + "'", parser, null);
        }
        return s;
    }

    private short getShortValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Short.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a short integer", parser, (Throwable)nfe);
                }
            }
        }
        return 0;
    }

    private String getTrimmedValue(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private String interpolatedTrimmed(String value, String context) {
        return this.getTrimmedValue(this.contentTransformer.transform(value, context));
    }

    private int nextTag(XmlPullParser parser) throws IOException, XmlPullParserException {
        int eventType = parser.next();
        if (eventType == 4) {
            eventType = parser.next();
        }
        if (eventType != 2 && eventType != 3) {
            throw new XmlPullParserException("expected START_TAG or END_TAG not " + XmlPullParser.TYPES[eventType], parser, null);
        }
        return eventType;
    }

    public DependencyUpdatesReport read(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        DependencyUpdatesReport dependencyUpdatesReport = null;
        int eventType = parser.getEventType();
        boolean parsed = false;
        while (eventType != 1) {
            if (eventType == 2) {
                if (strict && !"DependencyUpdatesReport".equals(parser.getName())) {
                    throw new XmlPullParserException("Expected root element 'DependencyUpdatesReport' but found '" + parser.getName() + "'", parser, null);
                }
                if (parsed) {
                    throw new XmlPullParserException("Duplicated tag: 'DependencyUpdatesReport'", parser, null);
                }
                dependencyUpdatesReport = this.parseDependencyUpdatesReport(parser, strict);
                dependencyUpdatesReport.setModelEncoding(parser.getInputEncoding());
                parsed = true;
            }
            eventType = parser.next();
        }
        if (parsed) {
            return dependencyUpdatesReport;
        }
        throw new XmlPullParserException("Expected root element 'DependencyUpdatesReport' but found no element at all: invalid XML document", parser, null);
    }

    public DependencyUpdatesReport read(Reader reader, boolean strict) throws IOException, XmlPullParserException {
        MXParser parser = this.addDefaultEntities ? new MXParser(EntityReplacementMap.defaultEntityReplacementMap) : new MXParser();
        parser.setInput(reader);
        return this.read((XmlPullParser)parser, strict);
    }

    public DependencyUpdatesReport read(Reader reader) throws IOException, XmlPullParserException {
        return this.read(reader, true);
    }

    public DependencyUpdatesReport read(InputStream in, boolean strict) throws IOException, XmlPullParserException {
        return this.read((Reader)ReaderFactory.newXmlReader((InputStream)in), strict);
    }

    public DependencyUpdatesReport read(InputStream in) throws IOException, XmlPullParserException {
        return this.read((Reader)ReaderFactory.newXmlReader((InputStream)in));
    }

    private DependencyInfo parseDependencyInfo(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        DependencyInfo dependencyInfo = new DependencyInfo();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "groupId", null, parsed)) {
                dependencyInfo.setGroupId(this.interpolatedTrimmed(parser.nextText(), "groupId"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "artifactId", null, parsed)) {
                dependencyInfo.setArtifactId(this.interpolatedTrimmed(parser.nextText(), "artifactId"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "scope", null, parsed)) {
                dependencyInfo.setScope(this.interpolatedTrimmed(parser.nextText(), "scope"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "classifier", null, parsed)) {
                dependencyInfo.setClassifier(this.interpolatedTrimmed(parser.nextText(), "classifier"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "type", null, parsed)) {
                dependencyInfo.setType(this.interpolatedTrimmed(parser.nextText(), "type"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "currentVersion", null, parsed)) {
                dependencyInfo.setCurrentVersion(this.interpolatedTrimmed(parser.nextText(), "currentVersion"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "lastVersion", null, parsed)) {
                dependencyInfo.setLastVersion(this.interpolatedTrimmed(parser.nextText(), "lastVersion"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "any", null, parsed)) {
                ArrayList<String> any = new ArrayList<String>();
                while (parser.nextTag() == 2) {
                    if ("any".equals(parser.getName())) {
                        any.add(this.interpolatedTrimmed(parser.nextText(), "any"));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                dependencyInfo.setAny(any);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "incrementals", null, parsed)) {
                ArrayList<String> incrementals = new ArrayList<String>();
                while (parser.nextTag() == 2) {
                    if ("incremental".equals(parser.getName())) {
                        incrementals.add(this.interpolatedTrimmed(parser.nextText(), "incrementals"));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                dependencyInfo.setIncrementals(incrementals);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "minors", null, parsed)) {
                ArrayList<String> minors = new ArrayList<String>();
                while (parser.nextTag() == 2) {
                    if ("minor".equals(parser.getName())) {
                        minors.add(this.interpolatedTrimmed(parser.nextText(), "minors"));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                dependencyInfo.setMinors(minors);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "majors", null, parsed)) {
                ArrayList<String> majors = new ArrayList<String>();
                while (parser.nextTag() == 2) {
                    if ("major".equals(parser.getName())) {
                        majors.add(this.interpolatedTrimmed(parser.nextText(), "majors"));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                dependencyInfo.setMajors(majors);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "status", null, parsed)) {
                dependencyInfo.setStatus(this.interpolatedTrimmed(parser.nextText(), "status"));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return dependencyInfo;
    }

    private DependencyReportSummary parseDependencyReportSummary(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        DependencyReportSummary dependencyReportSummary = new DependencyReportSummary();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "usingLastVersion", null, parsed)) {
                dependencyReportSummary.setUsingLastVersion(this.interpolatedTrimmed(parser.nextText(), "usingLastVersion"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "nextVersionAvailable", null, parsed)) {
                dependencyReportSummary.setNextVersionAvailable(this.interpolatedTrimmed(parser.nextText(), "nextVersionAvailable"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "nextIncrementalAvailable", null, parsed)) {
                dependencyReportSummary.setNextIncrementalAvailable(this.interpolatedTrimmed(parser.nextText(), "nextIncrementalAvailable"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "nextMinorAvailable", null, parsed)) {
                dependencyReportSummary.setNextMinorAvailable(this.interpolatedTrimmed(parser.nextText(), "nextMinorAvailable"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "nextMajorAvailable", null, parsed)) {
                dependencyReportSummary.setNextMajorAvailable(this.interpolatedTrimmed(parser.nextText(), "nextMajorAvailable"));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return dependencyReportSummary;
    }

    private DependencyUpdatesReport parseDependencyUpdatesReport(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        DependencyUpdatesReport dependencyUpdatesReport = new DependencyUpdatesReport();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0 || "xmlns".equals(name)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "summary", null, parsed)) {
                dependencyUpdatesReport.setSummary(this.parseDependencyReportSummary(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "dependencyManagements", null, parsed)) {
                ArrayList<DependencyInfo> dependencyManagements = new ArrayList<DependencyInfo>();
                while (parser.nextTag() == 2) {
                    if ("dependencyManagement".equals(parser.getName())) {
                        dependencyManagements.add(this.parseDependencyInfo(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                dependencyUpdatesReport.setDependencyManagements(dependencyManagements);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "dependencies", null, parsed)) {
                ArrayList<DependencyInfo> dependencies = new ArrayList<DependencyInfo>();
                while (parser.nextTag() == 2) {
                    if ("dependency".equals(parser.getName())) {
                        dependencies.add(this.parseDependencyInfo(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                dependencyUpdatesReport.setDependencies(dependencies);
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return dependencyUpdatesReport;
    }

    public void setAddDefaultEntities(boolean addDefaultEntities) {
        this.addDefaultEntities = addDefaultEntities;
    }

    public static interface ContentTransformer {
        public String transform(String var1, String var2);
    }
}

