/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.xmlbeans;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.xmlbeans.FilteredJarFile;
import org.codehaus.mojo.xmlbeans.XmlBeansException;

public class SchemaArtifact {
    private static String[] XSD_SUFFIXES = new String[]{"xsd", "XSD"};

    public static Collection getFilePaths(Artifact artifact, Log logger, File prefix) throws XmlBeansException {
        ArrayList<File> xsds = new ArrayList<File>();
        File artifactFile = artifact.getFile();
        List nextSet = null;
        if (artifactFile != null) {
            try {
                FilteredJarFile jarFile = new FilteredJarFile(artifactFile, logger);
                nextSet = jarFile.getEntryPathsAndExtract(XSD_SUFFIXES, prefix);
                Iterator i = nextSet.iterator();
                while (i.hasNext()) {
                    xsds.add(new File(prefix, (String)i.next()));
                }
            }
            catch (IOException ioe) {
                throw new XmlBeansException(XmlBeansException.XSD_ARTIFACT_JAR, ioe);
            }
        } else {
            throw new XmlBeansException(XmlBeansException.ARTIFACT_FILE_PATH, artifact.toString());
        }
        return xsds;
    }
}

