/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.zip;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ConcurrentJarCreatorExecutorServiceFactory {
    private static final AtomicInteger POOL_COUNTER = new AtomicInteger();

    static ExecutorService createExecutorService(int poolSize) {
        final ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        final int poolCount = POOL_COUNTER.incrementAndGet();
        final AtomicInteger threadCounter = new AtomicInteger();
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(threadGroup, r, "plx-arch-" + poolCount + "-" + threadCounter.incrementAndGet());
                thread.setDaemon(true);
                return thread;
            }
        };
        return new ThreadPoolExecutor(1, poolSize, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
    }
}

