/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler.util.scan.mapping;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.mapping.SingleTargetSourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;

public class SuffixMappingTest
extends TestCase {
    public void testShouldReturnSingleClassFileForSingleJavaFile() throws InclusionScanException {
        String base = "path/to/file";
        File basedir = new File(".");
        SuffixMapping mapping = new SuffixMapping(".java", ".class");
        Set results = mapping.getTargetFiles(basedir, base + ".java");
        Assert.assertEquals((String)"Returned wrong number of target files.", (int)1, (int)results.size());
        Assert.assertEquals((String)"Target file is wrong.", (Object)new File(basedir, base + ".class"), results.iterator().next());
    }

    public void testShouldNotReturnClassFileWhenSourceFileHasWrongSuffix() throws InclusionScanException {
        String base = "path/to/file";
        File basedir = new File(".");
        SuffixMapping mapping = new SuffixMapping(".java", ".class");
        Set results = mapping.getTargetFiles(basedir, base + ".xml");
        Assert.assertTrue((String)"Returned wrong number of target files.", (boolean)results.isEmpty());
    }

    public void testShouldReturnOneClassFileAndOneXmlFileForSingleJavaFile() throws InclusionScanException {
        String base = "path/to/file";
        File basedir = new File(".");
        HashSet<String> targets = new HashSet<String>();
        targets.add(".class");
        targets.add(".xml");
        SuffixMapping mapping = new SuffixMapping(".java", targets);
        Set results = mapping.getTargetFiles(basedir, base + ".java");
        Assert.assertEquals((String)"Returned wrong number of target files.", (int)2, (int)results.size());
        Assert.assertTrue((String)"Targets do not contain class target.", (boolean)results.contains(new File(basedir, base + ".class")));
        Assert.assertTrue((String)"Targets do not contain class target.", (boolean)results.contains(new File(basedir, base + ".xml")));
    }

    public void testShouldReturnNoTargetFilesWhenSourceFileHasWrongSuffix() throws InclusionScanException {
        String base = "path/to/file";
        File basedir = new File(".");
        HashSet<String> targets = new HashSet<String>();
        targets.add(".class");
        targets.add(".xml");
        SuffixMapping mapping = new SuffixMapping(".java", targets);
        Set results = mapping.getTargetFiles(basedir, base + ".apt");
        Assert.assertTrue((String)"Returned wrong number of target files.", (boolean)results.isEmpty());
    }

    public void testSingleTargetMapper() throws InclusionScanException {
        String base = "path/to/file";
        File basedir = new File("target/");
        SingleTargetSourceMapping mapping = new SingleTargetSourceMapping(".cs", "/foo");
        Set results = mapping.getTargetFiles(basedir, base + ".apt");
        Assert.assertTrue((boolean)results.isEmpty());
        results = mapping.getTargetFiles(basedir, base + ".cs");
        Assert.assertEquals((int)1, (int)results.size());
    }
}

