/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.configuration;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.codehaus.plexus.configuration.PlexusConfiguration;

public class DefaultPlexusConfiguration
implements PlexusConfiguration {
    private String name;
    private String value;
    private LinkedHashMap attributes;
    private LinkedHashMap children;

    protected DefaultPlexusConfiguration() {
        this("configuration");
    }

    protected DefaultPlexusConfiguration(String name) {
        this(name, null);
    }

    protected DefaultPlexusConfiguration(String name, String value) {
        this.name = name;
        this.value = value;
        this.attributes = new LinkedHashMap();
        this.children = new LinkedHashMap();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public String getValue(String defaultValue) {
        String value = this.getValue();
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public void setValue(String val) {
        this.value = val;
    }

    public PlexusConfiguration setValueAndGetSelf(String val) {
        this.setValue(val);
        return this;
    }

    public void setAttribute(String name, String value) {
        this.attributes.put(name, value);
    }

    public String getAttribute(String name) {
        return (String)this.attributes.get(name);
    }

    public String getAttribute(String name, String defaultValue) {
        String value = this.getAttribute(name);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public String[] getAttributeNames() {
        return this.attributes.keySet().toArray(new String[this.attributes.size()]);
    }

    public PlexusConfiguration getChild(String name) {
        return this.getChild(name, true);
    }

    public PlexusConfiguration getChild(int i) {
        return this.getChildren()[i];
    }

    public PlexusConfiguration getChild(String name, boolean createChild) {
        boolean noneFound;
        List childs = (List)this.children.get(name);
        boolean bl = noneFound = childs == null || childs.size() == 0;
        if (noneFound && createChild) {
            this.addChild(name);
            return this.getChild(name, false);
        }
        if (noneFound && !createChild) {
            return null;
        }
        return (PlexusConfiguration)childs.get(0);
    }

    public PlexusConfiguration[] getChildren() {
        ArrayList childs = new ArrayList();
        Iterator i = this.children.keySet().iterator();
        while (i.hasNext()) {
            List childList = (List)this.children.get(i.next());
            if (childList == null) continue;
            childs.addAll(childList);
        }
        return childs.toArray(new PlexusConfiguration[childs.size()]);
    }

    public PlexusConfiguration[] getChildren(String name) {
        ArrayList childs = new ArrayList();
        List childList = (List)this.children.get(name);
        if (childList != null) {
            childs.addAll(childList);
        }
        return childs.toArray(new PlexusConfiguration[childs.size()]);
    }

    public void addChild(PlexusConfiguration child) {
        if (!this.children.containsKey(child.getName())) {
            this.children.put(child.getName(), new ArrayList());
        }
        ((List)this.children.get(child.getName())).add(child);
    }

    public PlexusConfiguration addChild(String name) {
        PlexusConfiguration child = null;
        try {
            child = (PlexusConfiguration)this.getClass().newInstance();
            child.setName(name);
        }
        catch (Exception exception) {
            child = new DefaultPlexusConfiguration(name);
        }
        this.addChild(child);
        return this;
    }

    public PlexusConfiguration addChild(String name, String value) {
        DefaultPlexusConfiguration child = new DefaultPlexusConfiguration(name, value);
        this.addChild(child);
        return this;
    }

    public int getChildCount() {
        int result = 0;
        Iterator i = this.children.keySet().iterator();
        while (i.hasNext()) {
            result += ((List)this.children.get(i.next())).size();
        }
        return result;
    }
}

