/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.composition;

import java.util.List;
import org.codehaus.plexus.component.composition.CompositionException;
import org.codehaus.plexus.component.composition.CompositionResolver;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentRequirement;
import org.codehaus.plexus.component.repository.ComponentRequirementList;
import org.codehaus.plexus.util.dag.CycleDetectedException;
import org.codehaus.plexus.util.dag.DAG;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCompositionResolver
implements CompositionResolver {
    private DAG dag = new DAG();

    @Override
    public void addComponentDescriptor(ComponentDescriptor<?> componentDescriptor) throws CompositionException {
        String key = this.getDAGKey(componentDescriptor.getRole(), componentDescriptor.getRoleHint());
        List<ComponentRequirement> requirements = componentDescriptor.getRequirements();
        for (ComponentRequirement requirement : requirements) {
            try {
                if (requirement instanceof ComponentRequirementList) {
                    for (String hint : ((ComponentRequirementList)requirement).getRoleHints()) {
                        this.dag.addEdge(key, this.getDAGKey(requirement.getRole(), hint));
                    }
                    continue;
                }
                this.dag.addEdge(key, this.getDAGKey(requirement.getRole(), requirement.getRoleHint()));
            }
            catch (CycleDetectedException e) {
                throw new CompositionException("Cyclic requirement detected", e);
            }
        }
    }

    @Override
    public List getRequirements(String role, String roleHint) {
        return this.dag.getChildLabels(this.getDAGKey(role, roleHint));
    }

    @Override
    public List findRequirements(String role, String roleHint) {
        return this.dag.getParentLabels(this.getDAGKey(role, roleHint));
    }

    private String getDAGKey(String role, String roleHint) {
        return role + ':' + roleHint;
    }
}

