/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.repository;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.repository.ComponentRequirement;
import org.codehaus.plexus.component.repository.ComponentSetDescriptor;
import org.codehaus.plexus.configuration.PlexusConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentDescriptor<T> {
    private String alias = null;
    private String role = null;
    private String roleHint = "default";
    private String implementation;
    private Class<? extends T> implementationClass;
    private String version;
    private String componentType;
    private PlexusConfiguration configuration;
    private String instantiationStrategy;
    private String lifecycleHandler;
    private String componentProfile;
    private final List<ComponentRequirement> requirements = new ArrayList<ComponentRequirement>();
    private String componentFactory;
    private String componentComposer;
    private String componentConfigurator;
    private String description;
    private ClassRealm realm;
    private boolean isolatedRealm;
    private ComponentSetDescriptor componentSetDescriptor;
    private String source;

    public ComponentDescriptor() {
    }

    public ComponentDescriptor(Class<T> implementationClass) {
        this.implementationClass = implementationClass;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public String getHumanReadableKey() {
        StringBuffer key = new StringBuffer();
        key.append("role: '").append(this.role).append("'");
        key.append(", implementation: '").append(this.implementation).append("'");
        if (this.roleHint != null) {
            key.append(", role hint: '").append(this.roleHint).append("'");
        }
        if (this.alias != null) {
            key.append(", alias: '").append(this.alias).append("'");
        }
        return key.toString();
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getRoleHint() {
        return this.roleHint;
    }

    public void setRoleHint(String roleHint) {
        this.roleHint = roleHint == null || roleHint.trim().equals("") ? "default" : roleHint;
    }

    public String getImplementation() {
        return this.implementation;
    }

    public void setImplementation(String implementation) {
        this.implementation = implementation;
        this.implementationClass = null;
        this.attemptImplementationLoad();
    }

    public Class<? extends T> getImplementationClass() {
        this.attemptImplementationLoad();
        if (this.implementationClass == null) {
            return Object.class;
        }
        return this.implementationClass;
    }

    private void attemptImplementationLoad() {
        if (this.implementationClass == null && this.implementation != null && this.realm != null) {
            try {
                this.implementationClass = this.realm.loadClass(this.implementation);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void setImplementationClass(Class<? extends T> implementationClass) {
        this.implementationClass = implementationClass;
        this.implementation = implementationClass == null ? null : implementationClass.getName();
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getComponentType() {
        return this.componentType;
    }

    public void setComponentType(String componentType) {
        this.componentType = componentType;
    }

    public String getInstantiationStrategy() {
        return this.instantiationStrategy;
    }

    public PlexusConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(PlexusConfiguration configuration) {
        this.configuration = configuration;
    }

    public boolean hasConfiguration() {
        return this.configuration != null;
    }

    public String getLifecycleHandler() {
        return this.lifecycleHandler;
    }

    public void setLifecycleHandler(String lifecycleHandler) {
        this.lifecycleHandler = lifecycleHandler;
    }

    public String getComponentProfile() {
        return this.componentProfile;
    }

    public void setComponentProfile(String componentProfile) {
        this.componentProfile = componentProfile;
    }

    public void addRequirement(ComponentRequirement requirement) {
        this.requirements.add(requirement);
    }

    public void addRequirement(ComponentRequirement ... requirement) {
        this.requirements.addAll(Arrays.asList(requirement));
    }

    public void addRequirements(List<ComponentRequirement> requirements) {
        this.requirements.addAll(requirements);
    }

    public void removeRequirement(ComponentRequirement ... requirement) {
        this.requirements.removeAll(Arrays.asList(requirement));
    }

    public void removeRequirements(List<ComponentRequirement> requirements) {
        this.requirements.removeAll(requirements);
    }

    public List<ComponentRequirement> getRequirements() {
        return Collections.unmodifiableList(this.requirements);
    }

    public String getComponentFactory() {
        return this.componentFactory;
    }

    public void setComponentFactory(String componentFactory) {
        this.componentFactory = componentFactory;
    }

    public String getComponentComposer() {
        return this.componentComposer;
    }

    public void setComponentComposer(String componentComposer) {
        this.componentComposer = componentComposer;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setInstantiationStrategy(String instantiationStrategy) {
        this.instantiationStrategy = instantiationStrategy;
    }

    public boolean isIsolatedRealm() {
        return this.isolatedRealm;
    }

    public void setComponentSetDescriptor(ComponentSetDescriptor componentSetDescriptor) {
        this.componentSetDescriptor = componentSetDescriptor;
    }

    public ComponentSetDescriptor getComponentSetDescriptor() {
        return this.componentSetDescriptor;
    }

    public void setIsolatedRealm(boolean isolatedRealm) {
        this.isolatedRealm = isolatedRealm;
    }

    public String getComponentConfigurator() {
        return this.componentConfigurator;
    }

    public void setComponentConfigurator(String componentConfigurator) {
        this.componentConfigurator = componentConfigurator;
    }

    public ClassRealm getRealm() {
        return this.realm;
    }

    public void setRealm(ClassRealm realm) {
        this.realm = realm;
        this.implementationClass = null;
        this.attemptImplementationLoad();
    }

    public boolean equals(Object other) {
        if (!(other instanceof ComponentDescriptor)) {
            return false;
        }
        ComponentDescriptor otherDescriptor = (ComponentDescriptor)other;
        boolean isEqual = true;
        String role = this.getRole();
        String otherRole = otherDescriptor.getRole();
        isEqual = isEqual && (role.equals(otherRole) || role.equals(otherRole));
        String roleHint = this.getRoleHint();
        String otherRoleHint = otherDescriptor.getRoleHint();
        isEqual = isEqual && (roleHint.equals(otherRoleHint) || roleHint.equals(otherRoleHint));
        return isEqual;
    }

    public String toString() {
        return this.getClass().getName() + " [role: '" + this.getRole() + "', hint: '" + this.getRoleHint() + "', realm: " + (this.realm == null ? "NULL" : "'" + this.realm + "'") + "]";
    }

    public int hashCode() {
        int result = this.getRole().hashCode() + 1;
        String hint = this.getRoleHint();
        if (hint != null) {
            result += hint.hashCode();
        }
        return result;
    }
}

