/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.io.resources;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.DeferredFileOutputStream;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;
import org.codehaus.plexus.components.io.resources.PlexusIoResourceCollection;
import org.codehaus.plexus.components.io.resources.PlexusIoSymlink;
import org.codehaus.plexus.components.io.resources.proxy.PlexusIoProxyResource;
import org.codehaus.plexus.components.io.resources.proxy.PlexusIoProxySymlinkResource;

class Deferred {
    final DeferredFileOutputStream dfos;
    final PlexusIoResource resource;
    final PlexusIoResourceCollection owner;

    public Deferred(PlexusIoResource resource, PlexusIoResourceCollection owner, boolean hasTransformer) throws IOException {
        this.resource = resource;
        this.owner = owner;
        DeferredFileOutputStream deferredFileOutputStream = this.dfos = hasTransformer ? new DeferredFileOutputStream(5000000, "p-archiver", null, null) : null;
        if (this.dfos != null) {
            InputStream inputStream = owner.getInputStream(resource);
            IOUtils.copy((InputStream)inputStream, (OutputStream)this.dfos);
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    @Nonnull
    public InputStream getContents() throws IOException {
        if (this.dfos == null) {
            return this.resource.getContents();
        }
        if (this.dfos.isInMemory()) {
            return new ByteArrayInputStream(this.dfos.getData());
        }
        return new FileInputStream(this.dfos.getFile()){

            public void close() throws IOException {
                super.close();
                Deferred.this.dfos.getFile().delete();
            }
        };
    }

    public long getSize() {
        if (this.dfos == null) {
            return this.resource.getSize();
        }
        if (this.dfos.isInMemory()) {
            return this.dfos.getByteCount();
        }
        return this.dfos.getFile().length();
    }

    public String getName() {
        return this.owner.getName(this.resource);
    }

    private PlexusIoResource asSymlinkResource() {
        return new PlexusIoProxySymlinkResource(this.resource){

            public String getName() {
                return Deferred.this.getName();
            }

            @Nonnull
            public InputStream getContents() throws IOException {
                return Deferred.this.getContents();
            }

            public long getSize() {
                return Deferred.this.getSize();
            }
        };
    }

    public PlexusIoResource asResource() {
        if (this.resource instanceof PlexusIoSymlink) {
            return this.asSymlinkResource();
        }
        return new PlexusIoProxyResource(this.resource){

            public String getName() {
                return Deferred.this.getName();
            }

            @Nonnull
            public InputStream getContents() throws IOException {
                return Deferred.this.getContents();
            }

            public long getSize() {
                return Deferred.this.getSize();
            }
        };
    }
}

