/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.builder.runtime;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.builder.AbstractBuilder;
import org.codehaus.plexus.builder.runtime.PlexusRuntimeBuilder;
import org.codehaus.plexus.builder.runtime.PlexusRuntimeBuilderException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.velocity.VelocityComponent;

public class DefaultPlexusRuntimeBuilder
extends AbstractBuilder
implements PlexusRuntimeBuilder {
    private static String JSW = "jsw";
    private static final String CLASSWORLDS_TEMPLATE = "org/codehaus/plexus/builder/templates/classworlds.vm";
    private static final String UNIX_LAUNCHER_TEMPLATE = "org/codehaus/plexus/builder/templates/plexus.vm";
    private static final String WINDOWS_LAUNCHER_TEMPLATE = "org/codehaus/plexus/builder/templates/plexus-bat.vm";
    private static final String PROPERTY_APP_NAME = "app.name";
    private static final String PROPERTY_APP_LONG_NAME = "app.long.name";
    private static final String PROPERTY_APP_DESCRIPTION = "app.description";
    private static final String PROPERTY_CLASSWORLDS_VERSION = "classworlds.version";
    protected VelocityComponent velocity;

    public void build(File workingDirectory, List remoteRepositories, ArtifactRepository localRepository, Set projectArtifacts, File containerConfiguration, File configurationPropertiesFile) throws PlexusRuntimeBuilderException {
        try {
            Set coreArtifacts;
            Set bootArtifacts;
            if (workingDirectory == null) {
                throw new PlexusRuntimeBuilderException("The output directory must be specified.");
            }
            if (localRepository == null) {
                throw new PlexusRuntimeBuilderException("The local Maven repository must be specified.");
            }
            if (containerConfiguration == null) {
                throw new PlexusRuntimeBuilderException("The plexus configuration file must be set.");
            }
            if (!containerConfiguration.exists()) {
                throw new PlexusRuntimeBuilderException("The specified plexus configuration file '" + containerConfiguration.getAbsolutePath() + "'" + " doesn't exist.");
            }
            Properties configurationProperties = this.loadConfigurationProperties(configurationPropertiesFile);
            try {
                bootArtifacts = this.getBootArtifacts(projectArtifacts, remoteRepositories, localRepository, false);
                coreArtifacts = this.getCoreArtifacts(projectArtifacts, remoteRepositories, localRepository, false);
            }
            catch (ArtifactResolutionException e) {
                throw new PlexusRuntimeBuilderException("Could not resolve a artifact.", e);
            }
            String classworldsVersion = this.resolveVersion("classworlds", "classworlds", projectArtifacts, false, new HashSet());
            configurationProperties.setProperty(PROPERTY_CLASSWORLDS_VERSION, classworldsVersion);
            this.mkdirs(workingDirectory);
            this.getLogger().info("Building runtime in " + workingDirectory.getAbsolutePath());
            this.mkdirs(this.getAppsDirectory(workingDirectory));
            File binDir = this.mkdirs(new File(workingDirectory, "bin"));
            File confDir = this.mkdirs(new File(workingDirectory, "conf"));
            File coreDir = this.mkdirs(new File(workingDirectory, "core"));
            File bootDir = this.mkdirs(new File(workingDirectory, "core/boot"));
            this.mkdirs(new File(workingDirectory, "logs"));
            this.mkdirs(new File(workingDirectory, "services"));
            this.mkdirs(new File(workingDirectory, "temp"));
            this.copyArtifacts(workingDirectory, bootDir, bootArtifacts);
            this.copyArtifacts(workingDirectory, coreDir, coreArtifacts);
            this.processMainConfiguration(containerConfiguration, configurationProperties, confDir);
            this.createSystemScripts(binDir, confDir);
            this.javaServiceWrapper(binDir, coreDir, confDir, configurationProperties);
        }
        catch (PlexusRuntimeBuilderException ex) {
            throw ex;
        }
        catch (CommandLineException ex) {
            throw new PlexusRuntimeBuilderException("Exception while building the runtime.", ex);
        }
        catch (IOException ex) {
            throw new PlexusRuntimeBuilderException("Exception while building the runtime.", ex);
        }
    }

    public void bundle(File outputFile, File workingDirectory) throws PlexusRuntimeBuilderException {
        JarArchiver archiver = new JarArchiver();
        try {
            archiver.addDirectory(workingDirectory);
            archiver.setDestFile(outputFile);
            archiver.createArchive();
        }
        catch (Exception e) {
            throw new PlexusRuntimeBuilderException("Error while creating the archive.", e);
        }
    }

    public void addPlexusApplication(File plexusApplication, File runtimeDirectory) throws PlexusRuntimeBuilderException {
        try {
            FileUtils.copyFileToDirectory((File)plexusApplication, (File)this.getAppsDirectory(runtimeDirectory));
        }
        catch (IOException e) {
            throw new PlexusRuntimeBuilderException("Error while copying the application into the runtime.", e);
        }
    }

    public void addPlexusService(File plexusService, File runtimeDirectory) throws PlexusRuntimeBuilderException {
        try {
            File dir = this.getServicesDirectory(runtimeDirectory);
            String name = plexusService.getName();
            if (!name.endsWith(".jar")) {
                name = name.substring(0, name.lastIndexOf("."));
                name = name + ".jar";
            }
            FileUtils.copyFile((File)plexusService, (File)new File(dir, name));
        }
        catch (IOException e) {
            throw new PlexusRuntimeBuilderException("Error while copying the application into the runtime.", e);
        }
    }

    private File getAppsDirectory(File workingDirectory) {
        return new File(workingDirectory, "apps");
    }

    private File getServicesDirectory(File workingDirectory) {
        return new File(workingDirectory, "services");
    }

    private void createSystemScripts(File binDir, File confDir) throws PlexusRuntimeBuilderException, IOException, CommandLineException {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        this.createClassworldsConfiguration(confDir);
        this.createLauncherScripts(binDir);
        Thread.currentThread().setContextClassLoader(old);
    }

    private void createClassworldsConfiguration(File confDir) throws PlexusRuntimeBuilderException, IOException {
        this.mergeTemplate(CLASSWORLDS_TEMPLATE, new File(confDir, "classworlds.conf"), true);
    }

    private void createLauncherScripts(File binDir) throws PlexusRuntimeBuilderException, IOException, CommandLineException {
        this.mergeTemplate(UNIX_LAUNCHER_TEMPLATE, new File(binDir, "plexus.sh"), false);
        this.mergeTemplate(WINDOWS_LAUNCHER_TEMPLATE, new File(binDir, "plexus.bat"), true);
        this.executable(new File(binDir, "plexus.sh"));
    }

    private void processMainConfiguration(File containerConfiguration, Properties configurationProperties, File confDir) throws IOException {
        File out = new File(confDir, "plexus.xml");
        this.filterCopy(containerConfiguration, out, (Map)configurationProperties);
    }

    private void javaServiceWrapper(File binDir, File coreDir, File confDir, Properties configurationProperties) throws IOException, CommandLineException {
        File linux = new File(binDir, "linux");
        File win32 = new File(binDir, "win32");
        File macosx = new File(binDir, "macosx");
        File solaris = new File(binDir, "solaris");
        this.mkdirs(linux);
        this.mkdirs(win32);
        this.mkdirs(macosx);
        this.mkdirs(solaris);
        this.copyResourceToFile(JSW + "/wrapper.jar", new File(coreDir, "boot/wrapper.jar"));
        File runSh = new File(binDir, "linux/run.sh");
        this.filterCopy(this.getResourceAsStream(JSW + "/run.sh"), runSh, (Map)configurationProperties);
        this.executable(runSh);
        this.copyResource("linux/wrapper", "linux/wrapper", true, binDir);
        this.copyResource("linux/libwrapper.so", "linux/libwrapper.so", false, binDir);
        Properties linuxProps = new Properties();
        linuxProps.setProperty("library.path", "../../bin/linux");
        linuxProps.setProperty("extra.path", "");
        this.copyWrapperConf(linux, configurationProperties, linuxProps);
        this.copyResource("win32/wrapper.exe", "win32/wrapper.exe", true, binDir);
        this.copyResource("win32/wrapper.dll", "win32/wrapper.dll", false, binDir);
        this.copyResource("win32/run.bat", "win32/run.bat", false, binDir);
        this.copyResource("win32/InstallService.bat", "win32/InstallService.bat", false, binDir);
        this.copyResource("win32/UninstallService.bat", "win32/UninstallService.bat", false, binDir);
        Properties win32Props = new Properties();
        win32Props.setProperty("library.path", "../../bin/win32");
        win32Props.setProperty("extra.path", ";");
        this.copyWrapperConf(win32, configurationProperties, win32Props);
        runSh = new File(binDir, "macosx/run.sh");
        this.filterCopy(this.getResourceAsStream(JSW + "/run.sh"), runSh, (Map)configurationProperties);
        this.executable(runSh);
        this.copyResource("macosx/wrapper", "macosx/wrapper", true, binDir);
        this.copyResource("macosx/libwrapper.jnilib", "macosx/libwrapper.jnilib", false, binDir);
        Properties osxProps = new Properties();
        osxProps.setProperty("library.path", "../../bin/macosx");
        osxProps.setProperty("extra.path", "");
        this.copyWrapperConf(macosx, configurationProperties, osxProps);
        runSh = new File(binDir, "solaris/run.sh");
        this.filterCopy(this.getResourceAsStream(JSW + "/run.sh"), runSh, (Map)configurationProperties);
        this.executable(runSh);
        this.copyResource("solaris/wrapper", "solaris/wrapper", true, binDir);
        this.copyResource("solaris/libwrapper.so", "solaris/libwrapper.so", false, binDir);
        Properties solarisProps = new Properties();
        solarisProps.setProperty("library.path", "../../bin/solaris");
        solarisProps.setProperty("extra.path", "");
        this.copyWrapperConf(solaris, configurationProperties, solarisProps);
    }

    private void copyWrapperConf(File destDir, Properties configurationProperties, Properties additionalProperties) throws IOException {
        String key;
        Iterator i;
        Properties props = new Properties();
        if (configurationProperties != null) {
            i = ((Hashtable)configurationProperties).keySet().iterator();
            while (i.hasNext()) {
                key = (String)i.next();
                props.setProperty(key, configurationProperties.getProperty(key));
            }
        }
        if (additionalProperties != null) {
            i = ((Hashtable)additionalProperties).keySet().iterator();
            while (i.hasNext()) {
                key = (String)i.next();
                props.setProperty(key, additionalProperties.getProperty(key));
            }
        }
        this.filterCopy(this.getResourceAsStream(JSW + "/wrapper.conf"), new File(destDir, "wrapper.conf"), (Map)props);
    }

    protected void copyResource(String filename, String resource, boolean makeExecutable, File basedir) throws CommandLineException, IOException {
        File target = new File(basedir, filename);
        this.copyResourceToFile(JSW + "/" + resource, target);
        if (makeExecutable) {
            this.executable(target);
        }
    }

    private void copyResourceToFile(String resource, File target) throws IOException {
        InputStream is = this.getResourceAsStream(resource);
        this.mkdirs(target.getParentFile());
        FileOutputStream os = new FileOutputStream(target);
        IOUtil.copy((InputStream)is, (OutputStream)os);
        IOUtil.close((InputStream)is);
        IOUtil.close((OutputStream)os);
    }

    private Properties loadConfigurationProperties(File configurationPropertiesFile) throws IOException, PlexusRuntimeBuilderException {
        Properties properties = new Properties();
        if (configurationPropertiesFile == null) {
            throw new PlexusRuntimeBuilderException("The runtime builder requires a configuration properties file.");
        }
        properties.load(new FileInputStream(configurationPropertiesFile));
        this.assertHasProperty(properties, PROPERTY_APP_NAME);
        this.assertHasProperty(properties, PROPERTY_APP_LONG_NAME);
        this.assertHasProperty(properties, PROPERTY_APP_DESCRIPTION);
        return properties;
    }

    private void assertHasProperty(Properties properties, String key) throws PlexusRuntimeBuilderException {
        if (StringUtils.isEmpty((String)properties.getProperty(key))) {
            throw new PlexusRuntimeBuilderException("Missing configuration property '" + key + "'.");
        }
    }

    protected void mergeTemplate(String templateName, File outputFileName, boolean dos) throws IOException, PlexusRuntimeBuilderException {
        String line;
        StringWriter buffer = new StringWriter(102400);
        try {
            this.velocity.getEngine().mergeTemplate(templateName, (Context)new VelocityContext(), (Writer)buffer);
        }
        catch (ResourceNotFoundException ex) {
            throw new PlexusRuntimeBuilderException("Missing Velocity template: '" + templateName + "'.", ex);
        }
        catch (Exception ex) {
            throw new PlexusRuntimeBuilderException("Exception merging the velocity template.", ex);
        }
        FileOutputStream output = new FileOutputStream(outputFileName);
        BufferedReader reader = new BufferedReader(new StringReader(buffer.toString()));
        while ((line = reader.readLine()) != null) {
            output.write(line.getBytes());
            if (dos) {
                output.write(13);
            }
            output.write(10);
        }
        output.close();
    }
}

