/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core;

import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.picocontainer.PicoLifecycleException;
import org.sonar.api.platform.ComponentContainer;
import org.sonar.core.PicoUtils;

public class PicoUtilsTest {
    @Test
    public void shouldSanitizePicoLifecycleException() {
        Throwable th = PicoUtils.sanitize((Throwable)this.newPicoLifecycleException(false));
        Assert.assertThat((Object)th, (Matcher)Is.is(IllegalStateException.class));
        Assert.assertThat((Object)th.getMessage(), (Matcher)Is.is((Object)"A good reason to fail"));
    }

    @Test
    public void shouldSanitizePicoLifecycleException_no_wrapper_message() {
        Throwable th = PicoUtils.sanitize((Throwable)new PicoLifecycleException(null, null, (Throwable)new IllegalStateException("msg")));
        Assert.assertThat((Object)th, (Matcher)Is.is(IllegalStateException.class));
        Assert.assertThat((Object)th.getMessage(), (Matcher)Is.is((Object)"msg"));
    }

    @Test
    public void shouldNotSanitizeOtherExceptions() {
        Throwable th = PicoUtils.sanitize((Throwable)new IllegalArgumentException("foo"));
        Assert.assertThat((Object)th, (Matcher)Is.is(IllegalArgumentException.class));
        Assert.assertThat((Object)th.getMessage(), (Matcher)Is.is((Object)"foo"));
    }

    @Test
    public void shouldPropagateInitialUncheckedException() {
        try {
            PicoUtils.propagateStartupException((Throwable)this.newPicoLifecycleException(false));
            Assert.fail();
        }
        catch (RuntimeException e) {
            Assert.assertThat((Object)e, (Matcher)Is.is(IllegalStateException.class));
        }
    }

    @Test
    public void shouldThrowUncheckedExceptionWhenPropagatingCheckedException() {
        try {
            PicoUtils.propagateStartupException((Throwable)this.newPicoLifecycleException(true));
            Assert.fail();
        }
        catch (RuntimeException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)Is.is(IOException.class));
            Assert.assertThat((Object)e.getCause().getMessage(), (Matcher)Is.is((Object)"Checked"));
        }
    }

    private PicoLifecycleException newPicoLifecycleException(boolean initialCheckedException) {
        ComponentContainer componentContainer = new ComponentContainer();
        if (initialCheckedException) {
            componentContainer.addSingleton(CheckedFailureComponent.class);
        } else {
            componentContainer.addSingleton(UncheckedFailureComponent.class);
        }
        try {
            componentContainer.startComponents();
            return null;
        }
        catch (PicoLifecycleException e) {
            return e;
        }
    }

    public static class CheckedFailureComponent {
        public void start() throws IOException {
            throw new IOException("Checked");
        }
    }

    public static class UncheckedFailureComponent {
        public void start() {
            throw new IllegalStateException("A good reason to fail");
        }
    }
}

