/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.config;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.sonar.core.config.ConfigurationUtils;

public class ConfigurationUtilsTest {
    @Test
    public void shouldInterpolateVariables() {
        Properties input = new Properties();
        input.setProperty("hello", "world");
        input.setProperty("url", "${env:SONAR_JDBC_URL}");
        input.setProperty("do_not_change", "${SONAR_JDBC_URL}");
        HashMap variables = Maps.newHashMap();
        variables.put("SONAR_JDBC_URL", "jdbc:h2:mem");
        Properties output = ConfigurationUtils.interpolateVariables((Properties)input, (Map)variables);
        Assert.assertThat((Object)output.size(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)output.getProperty("hello"), (Matcher)CoreMatchers.is((Object)"world"));
        Assert.assertThat((Object)output.getProperty("url"), (Matcher)CoreMatchers.is((Object)"jdbc:h2:mem"));
        Assert.assertThat((Object)output.getProperty("do_not_change"), (Matcher)CoreMatchers.is((Object)"${SONAR_JDBC_URL}"));
        Assert.assertThat((Object)input.size(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)input.getProperty("hello"), (Matcher)CoreMatchers.is((Object)"world"));
        Assert.assertThat((Object)input.getProperty("url"), (Matcher)CoreMatchers.is((Object)"${env:SONAR_JDBC_URL}"));
        Assert.assertThat((Object)input.getProperty("do_not_change"), (Matcher)CoreMatchers.is((Object)"${SONAR_JDBC_URL}"));
    }

    @Test
    public void shouldCopyProperties() {
        Properties input = new Properties();
        input.setProperty("hello", "world");
        input.setProperty("foo", "bar");
        HashMap output = Maps.newHashMap();
        ConfigurationUtils.copyProperties((Properties)input, (Map)output);
        Assert.assertThat((Object)output.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat(output.get("hello"), (Matcher)CoreMatchers.is((Object)"world"));
        Assert.assertThat(output.get("foo"), (Matcher)CoreMatchers.is((Object)"bar"));
        Assert.assertThat((Object)input.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)input.getProperty("hello"), (Matcher)CoreMatchers.is((Object)"world"));
        Assert.assertThat((Object)input.getProperty("foo"), (Matcher)CoreMatchers.is((Object)"bar"));
    }
}

