/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.dashboard;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.sonar.core.dashboard.ActiveDashboardDao;
import org.sonar.core.dashboard.ActiveDashboardDto;
import org.sonar.core.persistence.AbstractDaoTestCase;

public class ActiveDashboardDaoTest
extends AbstractDaoTestCase {
    private ActiveDashboardDao dao;

    @Before
    public void createDao() throws Exception {
        this.dao = new ActiveDashboardDao(this.getMyBatis());
    }

    @Test
    public void shouldInsert() throws Exception {
        this.setupData("shouldInsert");
        ActiveDashboardDto dashboard = new ActiveDashboardDto();
        dashboard.setDashboardId(Long.valueOf(2L));
        dashboard.setUserId(Long.valueOf(3L));
        dashboard.setOrderIndex(Integer.valueOf(4));
        this.dao.insert(dashboard);
        this.checkTables("shouldInsert", "active_dashboards");
    }

    @Test
    public void shouldInsertWithNoUser() throws Exception {
        this.setupData("shouldInsert");
        ActiveDashboardDto dashboard = new ActiveDashboardDto();
        dashboard.setDashboardId(Long.valueOf(2L));
        dashboard.setOrderIndex(Integer.valueOf(4));
        this.dao.insert(dashboard);
        this.checkTables("shouldInsertWithNoUser", "active_dashboards");
    }

    @Test
    public void shouldGetMaxOrderIndexForNullUser() throws Exception {
        this.setupData("shouldGetMaxOrderIndexForNullUser");
        int index = this.dao.selectMaxOrderIndexForNullUser();
        Assert.assertThat((Object)index, (Matcher)Matchers.is((Object)15));
    }

    @Test
    public void shouldGetZeroMaxOrderIndex() throws Exception {
        this.setupData("empty");
        int index = this.dao.selectMaxOrderIndexForNullUser();
        Assert.assertThat((Object)index, (Matcher)Matchers.is((Object)0));
    }
}

