/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.dashboard;

import java.util.Date;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.sonar.core.dashboard.DashboardDao;
import org.sonar.core.dashboard.DashboardDto;
import org.sonar.core.dashboard.WidgetDto;
import org.sonar.core.dashboard.WidgetPropertyDto;
import org.sonar.core.persistence.AbstractDaoTestCase;

public class DashboardDaoTest
extends AbstractDaoTestCase {
    private DashboardDao dao;

    @Before
    public void createDao() {
        this.dao = new DashboardDao(this.getMyBatis());
    }

    @Test
    public void shouldSelectGlobalDashboard() {
        this.setupData("shouldSelectGlobalDashboard");
        DashboardDto dashboard = this.dao.selectGlobalDashboard("SQALE");
        Assert.assertThat((Object)dashboard.getId(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)dashboard.getUserId(), (Matcher)CoreMatchers.nullValue());
        Assert.assertNull((Object)this.dao.selectGlobalDashboard("unknown"));
    }

    @Test
    public void shouldInsert() {
        this.setupData("shouldInsert");
        Date aDate = new Date();
        DashboardDto dashboardDto = new DashboardDto();
        dashboardDto.setUserId(Long.valueOf(6L));
        dashboardDto.setName("My Dashboard");
        dashboardDto.setDescription("This is a dashboard");
        dashboardDto.setColumnLayout("100%");
        dashboardDto.setShared(true);
        dashboardDto.setGlobal(true);
        dashboardDto.setCreatedAt(aDate);
        dashboardDto.setUpdatedAt(aDate);
        WidgetDto widgetDto = new WidgetDto();
        widgetDto.setKey("code_coverage");
        widgetDto.setName("Code coverage");
        widgetDto.setDescription("Widget for code coverage");
        widgetDto.setColumnIndex(Integer.valueOf(13));
        widgetDto.setRowIndex(Integer.valueOf(14));
        widgetDto.setConfigured(true);
        widgetDto.setCreatedAt(aDate);
        widgetDto.setUpdatedAt(aDate);
        dashboardDto.addWidget(widgetDto);
        WidgetPropertyDto property = new WidgetPropertyDto();
        property.setKey("displayITs");
        property.setValue("true");
        widgetDto.addWidgetProperty(property);
        this.dao.insert(dashboardDto);
        this.checkTables("shouldInsert", new String[]{"created_at", "updated_at"}, new String[]{"dashboards", "widgets", "widget_properties"});
    }

    @Test
    public void shouldInsertWithNullableColumns() throws Exception {
        this.setupData("shouldInsert");
        DashboardDto dashboardDto = new DashboardDto();
        dashboardDto.setUserId(null);
        dashboardDto.setName(null);
        dashboardDto.setDescription(null);
        dashboardDto.setColumnLayout(null);
        dashboardDto.setShared(true);
        dashboardDto.setGlobal(false);
        dashboardDto.setCreatedAt(null);
        dashboardDto.setUpdatedAt(null);
        WidgetDto widgetDto = new WidgetDto();
        widgetDto.setKey("code_coverage");
        widgetDto.setName(null);
        widgetDto.setDescription(null);
        widgetDto.setColumnIndex(null);
        widgetDto.setRowIndex(null);
        widgetDto.setConfigured(true);
        widgetDto.setCreatedAt(null);
        widgetDto.setUpdatedAt(null);
        dashboardDto.addWidget(widgetDto);
        WidgetPropertyDto property = new WidgetPropertyDto();
        property.setKey(null);
        property.setValue(null);
        widgetDto.addWidgetProperty(property);
        this.dao.insert(dashboardDto);
        this.checkTables("shouldInsertWithNullableColumns", "dashboards", "widgets", "widget_properties");
    }
}

