/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.i18n;

import com.google.common.collect.Maps;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.fest.assertions.Assertions;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.sonar.core.i18n.I18nManager;

public class I18nManagerTest {
    private static Locale defaultLocale;
    private I18nManager manager;
    private ClassLoader coreClassLoader;
    private ClassLoader sqaleClassLoader;
    private ClassLoader forgeClassLoader;

    @BeforeClass
    public static void fixDefaultLocaleBug() {
        defaultLocale = Locale.getDefault();
        Locale.setDefault(Locale.ENGLISH);
    }

    @AfterClass
    public static void revertFix() {
        Locale.setDefault(defaultLocale);
    }

    @Before
    public void init() {
        HashMap bundleToClassLoaders = Maps.newHashMap();
        this.coreClassLoader = this.newCoreClassLoader();
        bundleToClassLoaders.put("org.sonar.l10n.core", this.coreClassLoader);
        bundleToClassLoaders.put("org.sonar.l10n.checkstyle", this.coreClassLoader);
        this.sqaleClassLoader = this.newSqaleClassLoader();
        bundleToClassLoaders.put("org.sonar.l10n.sqale", this.sqaleClassLoader);
        this.forgeClassLoader = this.newForgeClassLoader();
        bundleToClassLoaders.put("org.sonar.l10n.forge", this.forgeClassLoader);
        this.manager = new I18nManager((Map)bundleToClassLoaders, this.coreClassLoader);
        this.manager.start();
    }

    @Test
    public void shouldExtractPluginFromKey() {
        HashMap bundleToClassLoaders = Maps.newHashMap();
        bundleToClassLoaders.put("org.sonar.l10n.core", this.getClass().getClassLoader());
        bundleToClassLoaders.put("org.sonar.l10n.checkstyle", this.getClass().getClassLoader());
        bundleToClassLoaders.put("org.sonar.l10n.sqale", this.getClass().getClassLoader());
        I18nManager i18n = new I18nManager((Map)bundleToClassLoaders, this.coreClassLoader);
        i18n.start();
        Assert.assertThat((Object)i18n.extractBundleFromKey("by"), (Matcher)Is.is((Object)"org.sonar.l10n.core"));
        Assert.assertThat((Object)i18n.extractBundleFromKey("violations_drilldown.page"), (Matcher)Is.is((Object)"org.sonar.l10n.core"));
        Assert.assertThat((Object)i18n.extractBundleFromKey("checkstyle.rule1.name"), (Matcher)Is.is((Object)"org.sonar.l10n.checkstyle"));
        Assert.assertThat((Object)i18n.extractBundleFromKey("sqale.console.page"), (Matcher)Is.is((Object)"org.sonar.l10n.sqale"));
    }

    @Test
    public void shouldFindKeysInEnglishLanguagePack() {
        Assert.assertThat((Object)this.manager.message(Locale.ENGLISH, "checkstyle.rule1.name", null, new Object[0]), (Matcher)Is.is((Object)"Rule one"));
        Assert.assertThat((Object)this.manager.message(Locale.ENGLISH, "by", null, new Object[0]), (Matcher)Is.is((Object)"By"));
        Assert.assertThat((Object)this.manager.message(Locale.ENGLISH, "sqale.page", null, new Object[0]), (Matcher)Is.is((Object)"Sqale page title"));
        Assert.assertThat((Object)this.manager.message(Locale.FRENCH, "checkstyle.rule1.name", null, new Object[0]), (Matcher)Is.is((Object)"Rule un"));
        Assert.assertThat((Object)this.manager.message(Locale.FRENCH, "by", null, new Object[0]), (Matcher)Is.is((Object)"Par"));
        Assert.assertThat((Object)this.manager.message(Locale.FRENCH, "sqale.page", null, new Object[0]), (Matcher)Is.is((Object)"Titre de la page Sqale"));
    }

    @Test
    public void shouldUseDefaultLocale() {
        Assert.assertThat((Object)this.manager.message(Locale.CHINA, "checkstyle.rule1.name", null, new Object[0]), (Matcher)Is.is((Object)"Rule one"));
        Assert.assertThat((Object)this.manager.message(Locale.CHINA, "by", null, new Object[0]), (Matcher)Is.is((Object)"By"));
        Assert.assertThat((Object)this.manager.message(Locale.CHINA, "sqale.page", null, new Object[0]), (Matcher)Is.is((Object)"Sqale page title"));
    }

    @Test
    public void shouldUseLanguagePack() {
        Assert.assertThat((Object)this.manager.message(Locale.FRENCH, "checkstyle.rule1.name", null, new Object[0]), (Matcher)Is.is((Object)"Rule un"));
        Assert.assertThat((Object)this.manager.message(Locale.FRENCH, "by", null, new Object[0]), (Matcher)Is.is((Object)"Par"));
        Assert.assertThat((Object)this.manager.message(Locale.FRENCH, "sqale.page", null, new Object[0]), (Matcher)Is.is((Object)"Titre de la page Sqale"));
    }

    @Test
    public void shouldReturnDefaultValueIfMissingKey() {
        Assert.assertThat((Object)this.manager.message(Locale.ENGLISH, "foo.unknown", "default", new Object[0]), (Matcher)Is.is((Object)"default"));
        Assert.assertThat((Object)this.manager.message(Locale.FRENCH, "foo.unknown", "default", new Object[0]), (Matcher)Is.is((Object)"default"));
    }

    @Test
    public void shouldAcceptEmptyLabels() {
        Assert.assertThat((Object)this.manager.message(Locale.ENGLISH, "empty", "default", new Object[0]), (Matcher)Is.is((Object)""));
        Assert.assertThat((Object)this.manager.message(Locale.FRENCH, "empty", "default", new Object[0]), (Matcher)Is.is((Object)""));
    }

    @Test
    public void shouldFormatMessageWithParameters() {
        Assert.assertThat((Object)this.manager.message(Locale.ENGLISH, "with.parameters", null, new Object[]{"one", "two"}), (Matcher)Is.is((Object)"First is one and second is two"));
    }

    @Test
    public void shouldUseDefaultLocaleIfMissingValueInLocalizedBundle() {
        Assert.assertThat((Object)this.manager.message(Locale.FRENCH, "only.in.english", null, new Object[0]), (Matcher)Is.is((Object)"Missing in French bundle"));
        Assert.assertThat((Object)this.manager.message(Locale.CHINA, "only.in.english", null, new Object[0]), (Matcher)Is.is((Object)"Missing in French bundle"));
    }

    @Test
    public void shouldGetClassLoaderByProperty() {
        Assert.assertThat((Object)this.manager.getClassLoaderForProperty("foo.unknown", Locale.ENGLISH), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)this.manager.getClassLoaderForProperty("by", Locale.ENGLISH), (Matcher)Is.is((Object)this.coreClassLoader));
        Assert.assertThat((Object)this.manager.getClassLoaderForProperty("sqale.page", Locale.ENGLISH), (Matcher)Is.is((Object)this.sqaleClassLoader));
        Assert.assertThat((Object)this.manager.getClassLoaderForProperty("sqale.page", Locale.FRENCH), (Matcher)Is.is((Object)this.sqaleClassLoader));
        Assert.assertThat((Object)this.manager.getClassLoaderForProperty("forge_plugin.page", Locale.ENGLISH), (Matcher)Is.is((Object)this.forgeClassLoader));
        Assert.assertThat((Object)this.manager.getClassLoaderForProperty("forge_plugin.page", Locale.FRENCH), (Matcher)Is.is((Object)this.coreClassLoader));
    }

    @Test
    public void shouldFindEnglishFile() {
        String html = this.manager.messageFromFile(Locale.ENGLISH, "ArchitectureRule.html", "checkstyle.rule1.name", false);
        Assert.assertThat((Object)html, (Matcher)Is.is((Object)"This is the architecture rule"));
    }

    @Test
    public void shouldNotFindFile() {
        String html = this.manager.messageFromFile(Locale.ENGLISH, "UnknownRule.html", "checkstyle.rule1.name", false);
        Assert.assertThat((Object)html, (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void shouldFindFrenchFile() {
        String html = this.manager.messageFromFile(Locale.FRENCH, "ArchitectureRule.html", "checkstyle.rule1.name", false);
        Assert.assertThat((Object)html, (Matcher)Is.is((Object)"R\u00e8gle d'architecture"));
    }

    @Test
    public void shouldNotFindMissingLocale() {
        String html = this.manager.messageFromFile(Locale.CHINA, "ArchitectureRule.html", "checkstyle.rule1.name", false);
        Assert.assertThat((Object)html, (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void shouldNotKeepInCache() {
        Assert.assertThat((Object)this.manager.getFileContentCache().size(), (Matcher)Is.is((Object)0));
        boolean keepInCache = false;
        String html = this.manager.messageFromFile(Locale.ENGLISH, "ArchitectureRule.html", "checkstyle.rule1.name", keepInCache);
        Assert.assertThat((Object)html, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)this.manager.getFileContentCache().size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldKeepInCache() {
        Assert.assertThat((Object)this.manager.getFileContentCache().size(), (Matcher)Is.is((Object)0));
        boolean keepInCache = true;
        String html = this.manager.messageFromFile(Locale.ENGLISH, "ArchitectureRule.html", "checkstyle.rule1.name", keepInCache);
        Assert.assertThat((Object)html, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Map cache = this.manager.getFileContentCache();
        Assert.assertThat((Object)cache.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat(((Map)cache.get("ArchitectureRule.html")).get(Locale.ENGLISH), (Matcher)Is.is((Object)"This is the architecture rule"));
    }

    @Test
    public void shouldLookInCoreClassloaderForPluginsThatDontEmbedAllLanguages() {
        Assertions.assertThat((String)this.manager.message(Locale.ENGLISH, "forge_plugin.page", null, new Object[0])).isEqualTo((Object)"This is my plugin");
        Assertions.assertThat((String)this.manager.message(Locale.FRENCH, "forge_plugin.page", null, new Object[0])).isEqualTo((Object)"C'est mon plugin");
    }

    @Test
    public void shouldFallbackOnOriginalPluginIfTranslationNotPresentInLanguagePack() {
        Assertions.assertThat((String)this.manager.message(Locale.FRENCH, "forge_plugin.page", null, new Object[0])).isEqualTo((Object)"C'est mon plugin");
        Assertions.assertThat((String)this.manager.message(Locale.FRENCH, "forge_plugin.key_not_translated", null, new Object[0])).isEqualTo((Object)"Key Not Translated");
    }

    private URLClassLoader newForgeClassLoader() {
        return this.newClassLoader("/org/sonar/core/i18n/forgePlugin/");
    }

    private URLClassLoader newSqaleClassLoader() {
        return this.newClassLoader("/org/sonar/core/i18n/sqalePlugin/");
    }

    private URLClassLoader newCoreClassLoader() {
        return this.newClassLoader("/org/sonar/core/i18n/englishPack/", "/org/sonar/core/i18n/frenchPack/");
    }

    private URLClassLoader newClassLoader(String ... resourcePaths) {
        URL[] urls = new URL[resourcePaths.length];
        for (int index = 0; index < resourcePaths.length; ++index) {
            urls[index] = this.getClass().getResource(resourcePaths[index]);
        }
        return new URLClassLoader(urls);
    }
}

