/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.notification;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.sonar.api.notifications.Notification;
import org.sonar.core.notification.DefaultNotificationManager;
import org.sonar.core.notification.NotificationQueueElement;
import org.sonar.jpa.test.AbstractDbUnitTestCase;

public class DefaultNotificationManagerTest
extends AbstractDbUnitTestCase {
    private DefaultNotificationManager manager;

    @Before
    public void setUp() {
        this.manager = new DefaultNotificationManager(this.getSessionFactory());
    }

    @Test
    public void shouldPersist() throws Exception {
        Notification notification = new Notification("test");
        this.manager.scheduleForSending(notification);
        NotificationQueueElement queueElement = this.manager.getFromQueue();
        Assert.assertThat((Object)queueElement.getNotification(), (Matcher)Matchers.is((Object)notification));
        Assert.assertThat((Object)this.manager.getFromQueue(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void shouldCheckEnablement() {
        this.setupData("fixture");
        Assert.assertThat((Object)this.manager.isEnabled("simon", "email", "CommentOnReviewAssignedToMe"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.manager.isEnabled("godin", "email", "CommentOnReviewAssignedToMe"), (Matcher)Matchers.is((Object)false));
    }
}

