/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.persistence;

import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.dbunit.Assertion;
import org.dbunit.DataSourceDatabaseTester;
import org.dbunit.DatabaseUnitException;
import org.dbunit.IDatabaseTester;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.CompositeDataSet;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ReplacementDataSet;
import org.dbunit.dataset.filter.DefaultColumnFilter;
import org.dbunit.dataset.xml.FlatXmlDataSet;
import org.dbunit.ext.mssql.InsertIdentityOperation;
import org.dbunit.operation.DatabaseOperation;
import org.junit.Assert;
import org.junit.Before;
import org.sonar.api.config.Settings;
import org.sonar.core.config.Logback;
import org.sonar.core.persistence.Database;
import org.sonar.core.persistence.DatabaseCommands;
import org.sonar.core.persistence.DefaultDatabase;
import org.sonar.core.persistence.H2Database;
import org.sonar.core.persistence.MyBatis;

public abstract class AbstractDaoTestCase {
    private static Database database;
    private static DatabaseCommands databaseCommands;
    private static IDatabaseTester databaseTester;
    private static MyBatis myBatis;

    @Before
    public void startDatabase() throws SQLException {
        if (database == null) {
            Settings settings = new Settings().setProperties((Map)Maps.fromProperties((Properties)System.getProperties()));
            boolean hasDialect = settings.hasKey("sonar.jdbc.dialect");
            database = hasDialect ? new DefaultDatabase(settings) : new H2Database("sonarMyBatis");
            database.start();
            databaseCommands = DatabaseCommands.forDialect(database.getDialect());
            databaseTester = new DataSourceDatabaseTester(database.getDataSource());
            myBatis = new MyBatis(database, settings, new Logback());
            myBatis.start();
        }
        databaseCommands.truncateDatabase(database.getDataSource());
    }

    protected MyBatis getMyBatis() {
        return myBatis;
    }

    protected Database getDatabase() {
        return database;
    }

    protected void setupData(String ... testNames) {
        InputStream[] streams = new InputStream[testNames.length];
        try {
            for (int i = 0; i < testNames.length; ++i) {
                String className = this.getClass().getName();
                className = String.format("/%s/%s.xml", className.replace(".", "/"), testNames[i]);
                streams[i] = this.getClass().getResourceAsStream(className);
                if (streams[i] != null) continue;
                throw new RuntimeException("Test not found :" + className);
            }
            this.setupData(streams);
            databaseCommands.resetPrimaryKeys(database.getDataSource());
        }
        catch (SQLException e) {
            throw AbstractDaoTestCase.translateException("Could not setup DBUnit data", e);
        }
        finally {
            for (InputStream stream : streams) {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
    }

    private void setupData(InputStream ... dataSetStream) {
        IDatabaseConnection connection = null;
        try {
            IDataSet[] dataSets = new IDataSet[dataSetStream.length];
            for (int i = 0; i < dataSetStream.length; ++i) {
                dataSets[i] = this.getData(dataSetStream[i]);
            }
            databaseTester.setDataSet((IDataSet)new CompositeDataSet(dataSets));
            connection = this.createConnection();
            new InsertIdentityOperation(DatabaseOperation.INSERT).execute(connection, databaseTester.getDataSet());
            this.closeQuietly(connection);
        }
        catch (Exception e) {
            try {
                throw AbstractDaoTestCase.translateException("Could not setup DBUnit data", e);
            }
            catch (Throwable throwable) {
                this.closeQuietly(connection);
                throw throwable;
            }
        }
    }

    private void closeQuietly(IDatabaseConnection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected void checkTables(String testName, String ... tables) {
        this.checkTables(testName, new String[0], tables);
    }

    protected void checkTables(String testName, String[] excludedColumnNames, String ... tables) {
        IDatabaseConnection connection = null;
        try {
            connection = this.createConnection();
            IDataSet dataSet = connection.createDataSet();
            IDataSet expectedDataSet = this.getExpectedData(testName);
            for (String table : tables) {
                ITable filteredTable = DefaultColumnFilter.excludedColumnsTable((ITable)dataSet.getTable(table), (String[])excludedColumnNames);
                ITable filteredExpectedTable = DefaultColumnFilter.excludedColumnsTable((ITable)expectedDataSet.getTable(table), (String[])excludedColumnNames);
                Assertion.assertEquals((ITable)filteredExpectedTable, (ITable)filteredTable);
            }
        }
        catch (DatabaseUnitException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (SQLException e) {
            throw AbstractDaoTestCase.translateException("Error while checking results", e);
        }
        finally {
            this.closeQuietly(connection);
        }
    }

    protected void checkTable(String testName, String table, String ... columns) {
        IDatabaseConnection connection = null;
        try {
            connection = this.createConnection();
            IDataSet dataSet = connection.createDataSet();
            IDataSet expectedDataSet = this.getExpectedData(testName);
            ITable filteredTable = DefaultColumnFilter.includedColumnsTable((ITable)dataSet.getTable(table), (String[])columns);
            ITable filteredExpectedTable = DefaultColumnFilter.includedColumnsTable((ITable)expectedDataSet.getTable(table), (String[])columns);
            Assertion.assertEquals((ITable)filteredExpectedTable, (ITable)filteredTable);
        }
        catch (DatabaseUnitException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (SQLException e) {
            throw AbstractDaoTestCase.translateException("Error while checking results", e);
        }
        finally {
            this.closeQuietly(connection);
        }
    }

    protected void assertEmptyTables(String ... emptyTables) {
        IDatabaseConnection connection = null;
        try {
            connection = this.createConnection();
            IDataSet dataSet = connection.createDataSet();
            for (String table : emptyTables) {
                try {
                    Assert.assertEquals((String)("Table " + table + " not empty."), (long)0L, (long)dataSet.getTable(table).getRowCount());
                }
                catch (DataSetException e) {
                    throw AbstractDaoTestCase.translateException("Error while checking results", (Exception)((Object)e));
                }
            }
        }
        catch (SQLException e) {
            throw AbstractDaoTestCase.translateException("Error while checking results", e);
        }
        finally {
            this.closeQuietly(connection);
        }
    }

    private IDatabaseConnection createConnection() {
        try {
            IDatabaseConnection connection = databaseTester.getConnection();
            connection.getConfig().setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)databaseCommands.getDbUnitFactory());
            return connection;
        }
        catch (Exception e) {
            throw AbstractDaoTestCase.translateException("Error while getting connection", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IDataSet getExpectedData(String testName) {
        String className = this.getClass().getName();
        className = String.format("/%s/%s-result.xml", className.replace('.', '/'), testName);
        InputStream in = this.getClass().getResourceAsStream(className);
        try {
            IDataSet iDataSet = this.getData(in);
            return iDataSet;
        }
        finally {
            Closeables.closeQuietly((Closeable)in);
        }
    }

    private IDataSet getData(InputStream stream) {
        try {
            ReplacementDataSet dataSet = new ReplacementDataSet((IDataSet)new FlatXmlDataSet(stream));
            dataSet.addReplacementObject((Object)"[null]", null);
            dataSet.addReplacementObject((Object)"[false]", (Object)Boolean.FALSE);
            dataSet.addReplacementObject((Object)"[true]", (Object)Boolean.TRUE);
            return dataSet;
        }
        catch (Exception e) {
            throw AbstractDaoTestCase.translateException("Could not read the dataset stream", e);
        }
    }

    private static RuntimeException translateException(String msg, Exception cause) {
        RuntimeException runtimeException = new RuntimeException(String.format("%s: [%s] %s", msg, cause.getClass().getName(), cause.getMessage()));
        runtimeException.setStackTrace(cause.getStackTrace());
        return runtimeException;
    }

    protected Connection getConnection() throws SQLException {
        return database.getDataSource().getConnection();
    }
}

