/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.persistence;

import org.apache.ibatis.session.SqlSession;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.sonar.core.persistence.BatchSession;

public class BatchSessionTest {
    @Test
    public void shouldCommitWhenReachingBatchSize() {
        SqlSession mybatisSession = (SqlSession)Mockito.mock(SqlSession.class);
        BatchSession session = new BatchSession(mybatisSession, 10);
        for (int i = 0; i < 9; ++i) {
            session.insert("id" + i);
            ((SqlSession)Mockito.verify((Object)mybatisSession)).insert("id" + i);
            ((SqlSession)Mockito.verify((Object)mybatisSession, (VerificationMode)Mockito.never())).commit();
            ((SqlSession)Mockito.verify((Object)mybatisSession, (VerificationMode)Mockito.never())).commit(Matchers.anyBoolean());
        }
        session.insert("id9");
        ((SqlSession)Mockito.verify((Object)mybatisSession)).commit();
    }

    @Test
    public void shouldResetCounterAfterCommit() {
        SqlSession mybatisSession = (SqlSession)Mockito.mock(SqlSession.class);
        BatchSession session = new BatchSession(mybatisSession, 10);
        for (int i = 0; i < 35; ++i) {
            session.insert("id" + i);
        }
        ((SqlSession)Mockito.verify((Object)mybatisSession, (VerificationMode)Mockito.times((int)3))).commit();
    }
}

