/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.persistence;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.sonar.core.persistence.AbstractDaoTestCase;
import org.sonar.core.persistence.DatabaseVersion;

public class DatabaseVersionTest
extends AbstractDaoTestCase {
    @Test
    public void getVersion() {
        this.setupData("getVersion");
        Integer version = new DatabaseVersion(this.getMyBatis()).getVersion();
        Assert.assertThat((Object)version, (Matcher)Is.is((Object)123));
    }

    @Test
    public void getVersion_no_rows() {
        this.setupData("getVersion_no_rows");
        Integer version = new DatabaseVersion(this.getMyBatis()).getVersion();
        Assert.assertThat((Object)version, (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void getSonarCoreId() {
        this.setupData("getSonarCoreId");
        String sonarCoreId = new DatabaseVersion(this.getMyBatis()).getSonarCoreId();
        Assert.assertThat((Object)sonarCoreId, (Matcher)CoreMatchers.is((Object)"123456"));
    }

    @Test
    public void getStatus() {
        Assert.assertThat((Object)DatabaseVersion.getStatus(null, (int)150), (Matcher)CoreMatchers.is((Object)DatabaseVersion.Status.FRESH_INSTALL));
        Assert.assertThat((Object)DatabaseVersion.getStatus((Integer)123, (int)150), (Matcher)CoreMatchers.is((Object)DatabaseVersion.Status.REQUIRES_UPGRADE));
        Assert.assertThat((Object)DatabaseVersion.getStatus((Integer)150, (int)150), (Matcher)CoreMatchers.is((Object)DatabaseVersion.Status.UP_TO_DATE));
        Assert.assertThat((Object)DatabaseVersion.getStatus((Integer)200, (int)150), (Matcher)CoreMatchers.is((Object)DatabaseVersion.Status.REQUIRES_DOWNGRADE));
    }
}

