/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.persistence;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.fest.assertions.Assertions;
import org.junit.Test;
import org.sonar.core.persistence.DdlUtils;

public class DdlUtilsTest {
    @Test
    public void shouldSupportOnlyH2() {
        Assertions.assertThat((boolean)DdlUtils.supportsDialect((String)"h2")).isTrue();
        Assertions.assertThat((boolean)DdlUtils.supportsDialect((String)"mysql")).isFalse();
        Assertions.assertThat((boolean)DdlUtils.supportsDialect((String)"oracle")).isFalse();
        Assertions.assertThat((boolean)DdlUtils.supportsDialect((String)"mssql")).isFalse();
    }

    @Test
    public void shouldCreateSchema() throws SQLException {
        DriverManager.registerDriver((Driver)new org.h2.Driver());
        Connection connection = DriverManager.getConnection("jdbc:h2:mem:sonar_test");
        DdlUtils.createSchema((Connection)connection, (String)"h2");
        int tableCount = DdlUtilsTest.countTables(connection);
        connection.close();
        Assertions.assertThat((int)tableCount).isGreaterThan(30);
    }

    static int countTables(Connection connection) throws SQLException {
        int count = 0;
        ResultSet resultSet = connection.getMetaData().getTables("", null, null, new String[]{"TABLE"});
        while (resultSet.next()) {
            ++count;
        }
        resultSet.close();
        return count;
    }
}

