/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.persistence.dialect;

import org.fest.assertions.Assertions;
import org.junit.Test;
import org.sonar.core.persistence.dialect.H2;

public class H2Test {
    private H2 h2 = new H2();

    @Test
    public void matchesJdbcURL() {
        Assertions.assertThat((boolean)this.h2.matchesJdbcURL("jdbc:h2:foo")).isTrue();
        Assertions.assertThat((boolean)this.h2.matchesJdbcURL("jdbc:hsql:foo")).isFalse();
    }

    @Test
    public void testBooleanSqlValues() {
        Assertions.assertThat((String)this.h2.getTrueSqlValue()).isEqualTo((Object)"true");
        Assertions.assertThat((String)this.h2.getFalseSqlValue()).isEqualTo((Object)"false");
    }

    @Test
    public void should_configure() {
        Assertions.assertThat((String)this.h2.getId()).isEqualTo((Object)"h2");
        Assertions.assertThat((String)this.h2.getActiveRecordDialectCode()).isEqualTo((Object)".h2.");
        Assertions.assertThat((String)this.h2.getDefaultDriverClassName()).isEqualTo((Object)"org.h2.Driver");
        Assertions.assertThat((String)this.h2.getValidationQuery()).isEqualTo((Object)"SELECT 1");
    }
}

