/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.persistence.dialect;

import java.util.List;
import org.fest.assertions.Assertions;
import org.junit.Test;
import org.sonar.core.persistence.dialect.Oracle;

public class OracleTest {
    private Oracle oracle = new Oracle();

    @Test
    public void matchesJdbcURL() {
        Assertions.assertThat((boolean)this.oracle.matchesJdbcURL("jdbc:oracle:thin:@localhost/XE")).isTrue();
        Assertions.assertThat((boolean)this.oracle.matchesJdbcURL("jdbc:hsql:foo")).isFalse();
    }

    @Test
    public void shouldChangeOracleSchema() {
        List initStatements = this.oracle.getConnectionInitStatements("my_schema");
        Assertions.assertThat((List)initStatements).containsExactly(new Object[]{"ALTER SESSION SET CURRENT_SCHEMA = \"my_schema\""});
    }

    @Test
    public void shouldNotChangeOracleSchemaByDefault() {
        Assertions.assertThat((List)this.oracle.getConnectionInitStatements(null)).isEmpty();
    }

    @Test
    public void testBooleanSqlValues() {
        Assertions.assertThat((String)this.oracle.getTrueSqlValue()).isEqualTo((Object)"1");
        Assertions.assertThat((String)this.oracle.getFalseSqlValue()).isEqualTo((Object)"0");
    }

    @Test
    public void should_configure() {
        Assertions.assertThat((String)this.oracle.getId()).isEqualTo((Object)"oracle");
        Assertions.assertThat((String)this.oracle.getActiveRecordDialectCode()).isEqualTo((Object)"oracle");
        Assertions.assertThat((String)this.oracle.getDefaultDriverClassName()).isEqualTo((Object)"oracle.jdbc.OracleDriver");
        Assertions.assertThat((String)this.oracle.getValidationQuery()).isEqualTo((Object)"SELECT 1 FROM DUAL");
    }
}

