/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.persistence.dialect;

import java.util.List;
import org.fest.assertions.Assertions;
import org.junit.Test;
import org.sonar.core.persistence.dialect.PostgreSql;

public class PostgreSqlTest {
    private PostgreSql postgreSql = new PostgreSql();

    @Test
    public void matchesJdbcURL() {
        Assertions.assertThat((boolean)this.postgreSql.matchesJdbcURL("jdbc:postgresql://localhost/sonar")).isTrue();
        Assertions.assertThat((boolean)this.postgreSql.matchesJdbcURL("jdbc:hsql:foo")).isFalse();
    }

    @Test
    public void should_avoid_conflict_with_other_schemas() {
        List initStatements = this.postgreSql.getConnectionInitStatements("my_schema");
        Assertions.assertThat((List)initStatements).contains(new Object[]{"SET SEARCH_PATH TO my_schema"});
    }

    @Test
    public void shouldNotChangePostgreSearchPathByDefault() {
        for (String statement : this.postgreSql.getConnectionInitStatements(null)) {
            Assertions.assertThat((String)statement).doesNotMatch("SET SEARCH_PATH .*");
        }
    }

    @Test
    public void testBooleanSqlValues() {
        Assertions.assertThat((String)this.postgreSql.getTrueSqlValue()).isEqualTo((Object)"true");
        Assertions.assertThat((String)this.postgreSql.getFalseSqlValue()).isEqualTo((Object)"false");
    }

    @Test
    public void should_configure() {
        Assertions.assertThat((String)this.postgreSql.getId()).isEqualTo((Object)"postgresql");
        Assertions.assertThat((String)this.postgreSql.getActiveRecordDialectCode()).isEqualTo((Object)"postgre");
        Assertions.assertThat((String)this.postgreSql.getDefaultDriverClassName()).isEqualTo((Object)"org.postgresql.Driver");
        Assertions.assertThat((String)this.postgreSql.getValidationQuery()).isEqualTo((Object)"SELECT 1");
    }
}

