/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.plugins;

import com.google.common.collect.Ordering;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.fest.assertions.Assertions;
import org.junit.Test;
import org.sonar.core.plugins.DefaultPluginMetadata;

public class DefaultPluginMetadataTest {
    @Test
    public void testGettersAndSetters() {
        DefaultPluginMetadata metadata = DefaultPluginMetadata.create((File)new File("sonar-checkstyle-plugin.jar"));
        metadata.setKey("checkstyle").setLicense("LGPL").setDescription("description").setHomepage("http://home").setMainClass("org.Main").setOrganization("SonarSource").setOrganizationUrl("http://sonarsource.org").setVersion("1.1").setSonarVersion("3.0").setUseChildFirstClassLoader(true).setCore(false).setImplementationBuild("abcdef");
        Assertions.assertThat((String)metadata.getKey()).isEqualTo((Object)"checkstyle");
        Assertions.assertThat((String)metadata.getLicense()).isEqualTo((Object)"LGPL");
        Assertions.assertThat((String)metadata.getDescription()).isEqualTo((Object)"description");
        Assertions.assertThat((String)metadata.getHomepage()).isEqualTo((Object)"http://home");
        Assertions.assertThat((String)metadata.getMainClass()).isEqualTo((Object)"org.Main");
        Assertions.assertThat((String)metadata.getOrganization()).isEqualTo((Object)"SonarSource");
        Assertions.assertThat((String)metadata.getOrganizationUrl()).isEqualTo((Object)"http://sonarsource.org");
        Assertions.assertThat((String)metadata.getVersion()).isEqualTo((Object)"1.1");
        Assertions.assertThat((String)metadata.getSonarVersion()).isEqualTo((Object)"3.0");
        Assertions.assertThat((boolean)metadata.isUseChildFirstClassLoader()).isTrue();
        Assertions.assertThat((boolean)metadata.isCore()).isFalse();
        Assertions.assertThat((String)metadata.getBasePlugin()).isNull();
        Assertions.assertThat((File)metadata.getFile()).isNotNull();
        Assertions.assertThat((List)metadata.getDeployedFiles()).isEmpty();
        Assertions.assertThat((String)metadata.getImplementationBuild()).isEqualTo((Object)"abcdef");
    }

    @Test
    public void testDeployedFiles() {
        DefaultPluginMetadata metadata = DefaultPluginMetadata.create((File)new File("sonar-checkstyle-plugin.jar")).addDeployedFile(new File("foo.jar")).addDeployedFile(new File("bar.jar"));
        Assertions.assertThat((List)metadata.getDeployedFiles()).hasSize(2);
    }

    @Test
    public void testInternalPathToDependencies() {
        DefaultPluginMetadata metadata = DefaultPluginMetadata.create((File)new File("sonar-checkstyle-plugin.jar")).setPathsToInternalDeps(new String[]{"META-INF/lib/commons-lang.jar", "META-INF/lib/commons-io.jar"});
        Assertions.assertThat((Object[])metadata.getPathsToInternalDeps()).containsOnly(new Object[]{"META-INF/lib/commons-lang.jar", "META-INF/lib/commons-io.jar"});
    }

    @Test
    public void shouldEquals() {
        DefaultPluginMetadata checkstyle = DefaultPluginMetadata.create((File)new File("sonar-checkstyle-plugin.jar")).setKey("checkstyle");
        DefaultPluginMetadata pmd = DefaultPluginMetadata.create((File)new File("sonar-pmd-plugin.jar")).setKey("pmd");
        Assertions.assertThat((Object)checkstyle).isEqualTo((Object)checkstyle);
        Assertions.assertThat((Object)checkstyle).isEqualTo((Object)DefaultPluginMetadata.create((File)new File("sonar-checkstyle-plugin.jar")).setKey("checkstyle"));
        Assertions.assertThat((Object)checkstyle).isNotEqualTo((Object)pmd);
    }

    @Test
    public void shouldCompare() {
        DefaultPluginMetadata checkstyle = DefaultPluginMetadata.create((File)new File("sonar-checkstyle-plugin.jar")).setKey("checkstyle").setName("Checkstyle");
        DefaultPluginMetadata pmd = DefaultPluginMetadata.create((File)new File("sonar-pmd-plugin.jar")).setKey("pmd").setName("PMD");
        List<DefaultPluginMetadata> plugins = Arrays.asList(pmd, checkstyle);
        Assertions.assertThat((List)Ordering.natural().sortedCopy(plugins)).onProperty("key").containsExactly(new Object[]{"checkstyle", "pmd"});
    }

    @Test
    public void should_check_compatibility_with_sonar_version() {
        Assertions.assertThat((boolean)DefaultPluginMetadataTest.pluginWithVersion("1.1").isCompatibleWith("1.1")).isTrue();
        Assertions.assertThat((boolean)DefaultPluginMetadataTest.pluginWithVersion("1.1").isCompatibleWith("1.1.0")).isTrue();
        Assertions.assertThat((boolean)DefaultPluginMetadataTest.pluginWithVersion("1.0").isCompatibleWith("1.0.0")).isTrue();
        Assertions.assertThat((boolean)DefaultPluginMetadataTest.pluginWithVersion("1.0").isCompatibleWith("1.1")).isTrue();
        Assertions.assertThat((boolean)DefaultPluginMetadataTest.pluginWithVersion("1.1.1").isCompatibleWith("1.1.2")).isTrue();
        Assertions.assertThat((boolean)DefaultPluginMetadataTest.pluginWithVersion("2.0").isCompatibleWith("2.1.0")).isTrue();
        Assertions.assertThat((boolean)DefaultPluginMetadataTest.pluginWithVersion("3.2").isCompatibleWith("3.2-RC1")).isTrue();
        Assertions.assertThat((boolean)DefaultPluginMetadataTest.pluginWithVersion("3.2").isCompatibleWith("3.2-RC2")).isTrue();
        Assertions.assertThat((boolean)DefaultPluginMetadataTest.pluginWithVersion("3.2").isCompatibleWith("3.1-RC2")).isFalse();
        Assertions.assertThat((boolean)DefaultPluginMetadataTest.pluginWithVersion("1.1").isCompatibleWith("1.0")).isFalse();
        Assertions.assertThat((boolean)DefaultPluginMetadataTest.pluginWithVersion("2.0.1").isCompatibleWith("2.0.0")).isFalse();
        Assertions.assertThat((boolean)DefaultPluginMetadataTest.pluginWithVersion("2.10").isCompatibleWith("2.1")).isFalse();
        Assertions.assertThat((boolean)DefaultPluginMetadataTest.pluginWithVersion("10.10").isCompatibleWith("2.2")).isFalse();
        Assertions.assertThat((boolean)DefaultPluginMetadataTest.pluginWithVersion("1.1-SNAPSHOT").isCompatibleWith("1.0")).isFalse();
        Assertions.assertThat((boolean)DefaultPluginMetadataTest.pluginWithVersion("1.1-SNAPSHOT").isCompatibleWith("1.1")).isTrue();
        Assertions.assertThat((boolean)DefaultPluginMetadataTest.pluginWithVersion("1.1-SNAPSHOT").isCompatibleWith("1.2")).isTrue();
        Assertions.assertThat((boolean)DefaultPluginMetadataTest.pluginWithVersion("1.0.1-SNAPSHOT").isCompatibleWith("1.0")).isFalse();
        Assertions.assertThat((boolean)DefaultPluginMetadataTest.pluginWithVersion("3.1-RC2").isCompatibleWith("3.2-SNAPSHOT")).isTrue();
        Assertions.assertThat((boolean)DefaultPluginMetadataTest.pluginWithVersion("3.1-RC1").isCompatibleWith("3.2-RC2")).isTrue();
        Assertions.assertThat((boolean)DefaultPluginMetadataTest.pluginWithVersion("3.1-RC1").isCompatibleWith("3.1-RC2")).isTrue();
        Assertions.assertThat((boolean)DefaultPluginMetadataTest.pluginWithVersion(null).isCompatibleWith("0")).isTrue();
        Assertions.assertThat((boolean)DefaultPluginMetadataTest.pluginWithVersion(null).isCompatibleWith("3.1")).isTrue();
    }

    static DefaultPluginMetadata pluginWithVersion(String version) {
        return DefaultPluginMetadata.create(null).setSonarVersion(version);
    }
}

