/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.plugins;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.sonar.api.Plugin;
import org.sonar.api.platform.PluginMetadata;
import org.sonar.api.utils.SonarException;
import org.sonar.core.plugins.DefaultPluginMetadata;
import org.sonar.core.plugins.PluginClassloaders;

public class PluginClassloadersTest {
    private PluginClassloaders classloaders;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void before() {
        this.classloaders = new PluginClassloaders(this.getClass().getClassLoader());
    }

    @After
    public void clean() {
        if (this.classloaders != null) {
            this.classloaders.clean();
        }
    }

    @Test
    public void shouldImport() throws Exception {
        this.classloaders.add((PluginMetadata)DefaultPluginMetadata.create(null).setKey("foo").addDeployedFile(this.getFile("PluginClassloadersTest/foo.jar")));
        this.classloaders.add((PluginMetadata)DefaultPluginMetadata.create(null).setKey("bar").addDeployedFile(this.getFile("PluginClassloadersTest/bar.jar")));
        this.classloaders.done();
        String resourceName = "org/sonar/plugins/bar/api/resource.txt";
        Assertions.assertThat((Object)this.classloaders.get("bar").getResourceAsStream(resourceName)).isNotNull();
        Assertions.assertThat((Object)this.classloaders.get("foo").getResourceAsStream(resourceName)).isNotNull();
    }

    @Test
    public void shouldCreateBaseClassloader() {
        this.classloaders = new PluginClassloaders(this.getClass().getClassLoader());
        DefaultPluginMetadata checkstyle = DefaultPluginMetadata.create(null).setKey("checkstyle").setMainClass("org.sonar.plugins.checkstyle.CheckstylePlugin").addDeployedFile(this.getFile("sonar-checkstyle-plugin-2.8.jar"));
        Map map = this.classloaders.init(Arrays.asList(checkstyle));
        Plugin checkstyleEntryPoint = (Plugin)map.get("checkstyle");
        ClassRealm checkstyleRealm = (ClassRealm)checkstyleEntryPoint.getClass().getClassLoader();
        Assertions.assertThat((String)checkstyleRealm.getId()).isEqualTo((Object)"checkstyle");
    }

    @Test
    public void shouldExtendPlugin() {
        this.classloaders = new PluginClassloaders(this.getClass().getClassLoader());
        DefaultPluginMetadata checkstyle = DefaultPluginMetadata.create(null).setKey("checkstyle").setMainClass("org.sonar.plugins.checkstyle.CheckstylePlugin").addDeployedFile(this.getFile("sonar-checkstyle-plugin-2.8.jar"));
        DefaultPluginMetadata checkstyleExt = DefaultPluginMetadata.create(null).setKey("checkstyle-ext").setBasePlugin("checkstyle").setMainClass("com.mycompany.sonar.checkstyle.CheckstyleExtensionsPlugin").addDeployedFile(this.getFile("sonar-checkstyle-extensions-plugin-0.1-SNAPSHOT.jar"));
        Map map = this.classloaders.init(Arrays.asList(checkstyle, checkstyleExt));
        Plugin checkstyleEntryPoint = (Plugin)map.get("checkstyle");
        Plugin checkstyleExtEntryPoint = (Plugin)map.get("checkstyle-ext");
        Assertions.assertThat((boolean)checkstyleEntryPoint.getClass().getClassLoader().equals(checkstyleExtEntryPoint.getClass().getClassLoader())).isTrue();
    }

    @Test
    public void detect_plugins_compiled_for_bad_java_version() throws Exception {
        this.thrown.expect(SonarException.class);
        this.thrown.expectMessage("The plugin checkstyle is not supported with Java 1.");
        ClassWorld world = (ClassWorld)Mockito.mock(ClassWorld.class);
        Mockito.when((Object)world.newRealm(Matchers.anyString(), (ClassLoader)Matchers.any(ClassLoader.class))).thenThrow(new Throwable[]{new UnsupportedClassVersionError()});
        this.classloaders = new PluginClassloaders(this.getClass().getClassLoader(), world);
        DefaultPluginMetadata checkstyle = DefaultPluginMetadata.create(null).setKey("checkstyle").setMainClass("org.sonar.plugins.checkstyle.CheckstylePlugin").addDeployedFile(this.getFile("sonar-checkstyle-plugin-2.8.jar"));
        this.classloaders.init(Arrays.asList(checkstyle));
    }

    private File getFile(String filename) {
        return FileUtils.toFile((URL)this.getClass().getResource("/org/sonar/core/plugins/" + filename));
    }
}

