/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.plugins;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.fest.assertions.Assertions;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.sonar.core.plugins.DefaultPluginMetadata;
import org.sonar.core.plugins.PluginInstaller;

public class PluginInstallerTest {
    private PluginInstaller extractor = new PluginInstaller();
    @ClassRule
    public static TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void shouldExtractMetadata() {
        DefaultPluginMetadata metadata = this.extractor.extractMetadata(PluginInstallerTest.getFile("sonar-cobertura-plugin-3.1.1.jar"), true);
        Assertions.assertThat((String)metadata.getKey()).isEqualTo((Object)"cobertura");
        Assertions.assertThat((String)metadata.getBasePlugin()).isNull();
        Assertions.assertThat((String)metadata.getName()).isEqualTo((Object)"Cobertura");
        Assertions.assertThat((boolean)metadata.isCore()).isEqualTo(true);
        Assertions.assertThat((String)metadata.getFile().getName()).isEqualTo((Object)"sonar-cobertura-plugin-3.1.1.jar");
        Assertions.assertThat((String)metadata.getVersion()).isEqualTo((Object)"3.1.1");
        Assertions.assertThat((String)metadata.getImplementationBuild()).isEqualTo((Object)"b9283404030db9ce1529b1fadfb98331686b116d");
    }

    @Test
    public void should_read_sonar_version() {
        DefaultPluginMetadata metadata = this.extractor.extractMetadata(PluginInstallerTest.getFile("sonar-switch-off-violations-plugin-1.1.jar"), false);
        Assertions.assertThat((String)metadata.getVersion()).isEqualTo((Object)"1.1");
        Assertions.assertThat((String)metadata.getSonarVersion()).isEqualTo((Object)"2.5");
    }

    @Test
    public void shouldExtractDeprecatedMetadata() {
        DefaultPluginMetadata metadata = this.extractor.extractMetadata(PluginInstallerTest.getFile("sonar-emma-plugin-0.3.jar"), false);
        Assertions.assertThat((String)metadata.getKey()).isEqualTo((Object)"emma");
        Assertions.assertThat((String)metadata.getBasePlugin()).isNull();
        Assertions.assertThat((String)metadata.getName()).isEqualTo((Object)"Emma");
    }

    @Test
    public void shouldExtractExtensionMetadata() {
        DefaultPluginMetadata metadata = this.extractor.extractMetadata(PluginInstallerTest.getFile("sonar-checkstyle-extensions-plugin-0.1-SNAPSHOT.jar"), true);
        Assertions.assertThat((String)metadata.getKey()).isEqualTo((Object)"checkstyleextensions");
        Assertions.assertThat((String)metadata.getBasePlugin()).isEqualTo((Object)"checkstyle");
    }

    @Test
    public void shouldCopyAndExtractDependencies() throws IOException {
        File toDir = temporaryFolder.newFolder();
        DefaultPluginMetadata metadata = this.extractor.install(PluginInstallerTest.getFile("sonar-checkstyle-plugin-2.8.jar"), true, null, toDir);
        Assertions.assertThat((String)metadata.getKey()).isEqualTo((Object)"checkstyle");
        Assertions.assertThat((File)new File(toDir, "sonar-checkstyle-plugin-2.8.jar")).exists();
        Assertions.assertThat((File)new File(toDir, "META-INF/lib/checkstyle-5.1.jar")).exists();
    }

    @Test
    public void shouldExtractOnlyDependencies() throws IOException {
        File toDir = temporaryFolder.newFolder();
        this.extractor.install(PluginInstallerTest.getFile("sonar-checkstyle-plugin-2.8.jar"), true, null, toDir);
        Assertions.assertThat((File)new File(toDir, "sonar-checkstyle-plugin-2.8.jar")).exists();
        Assertions.assertThat((File)new File(toDir, "META-INF/MANIFEST.MF")).doesNotExist();
        Assertions.assertThat((File)new File(toDir, "org/sonar/plugins/checkstyle/CheckstyleVersion.class")).doesNotExist();
    }

    @Test
    public void shouldCopyRuleExtensionsOnServerSide() throws IOException {
        File toDir = temporaryFolder.newFolder();
        DefaultPluginMetadata metadata = DefaultPluginMetadata.create((File)PluginInstallerTest.getFile("sonar-checkstyle-plugin-2.8.jar")).setKey("checkstyle").addDeprecatedExtension(PluginInstallerTest.getFile("checkstyle-extension.xml"));
        this.extractor.install(metadata, toDir);
        Assertions.assertThat((File)new File(toDir, "sonar-checkstyle-plugin-2.8.jar")).exists();
        Assertions.assertThat((File)new File(toDir, "checkstyle-extension.xml")).exists();
    }

    static File getFile(String filename) {
        return FileUtils.toFile((URL)PluginInstallerTest.class.getResource("/org/sonar/core/plugins/" + filename));
    }
}

