/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.qualitymodel;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.internal.matchers.IsCollectionContaining;
import org.sonar.api.qualitymodel.Characteristic;
import org.sonar.api.qualitymodel.Model;
import org.sonar.jpa.test.AbstractDbUnitTestCase;

public class ModelTest
extends AbstractDbUnitTestCase {
    @Test
    public void saveModelAndCharacteristics() {
        Model model = Model.createByName((String)"fake");
        model.createCharacteristicByName("Efficiency");
        model.createCharacteristicByName("Usability");
        this.getSession().save((Object)model);
        this.getSession().commit();
        model = (Model)this.getSession().getSingleResult(Model.class, new Object[]{"name", "fake"});
        Assert.assertThat((Object)model.getName(), (Matcher)Matchers.is((Object)"fake"));
        Assert.assertThat((Object)model.getCharacteristics().size(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)model.getRootCharacteristics().size(), (Matcher)Matchers.is((Object)2));
        Assert.assertNotNull((Object)model.getCharacteristicByName("Efficiency"));
    }

    @Test
    public void saveTreeOfCharacteristics() {
        Model model = Model.createByName((String)"fake");
        Characteristic efficiency = model.createCharacteristicByName("Efficiency");
        Characteristic usability = model.createCharacteristicByName("Usability");
        Characteristic cpuEfficiency = model.createCharacteristicByName("CPU Efficiency");
        Characteristic ramEfficiency = model.createCharacteristicByName("RAM Efficiency");
        efficiency.addChildren(new Characteristic[]{cpuEfficiency, ramEfficiency});
        this.getSession().save((Object)model);
        this.getSession().commit();
        model = (Model)this.getSession().getSingleResult(Model.class, new Object[]{"name", "fake"});
        Assert.assertThat((Object)model.getCharacteristics().size(), (Matcher)Matchers.is((Object)4));
        Assert.assertThat((Object)model.getCharacteristics(), (Matcher)IsCollectionContaining.hasItems((Object[])new Characteristic[]{efficiency, usability, ramEfficiency, cpuEfficiency}));
        Assert.assertThat((Object)efficiency.getChildren(), (Matcher)IsCollectionContaining.hasItems((Object[])new Characteristic[]{ramEfficiency, cpuEfficiency}));
        Assert.assertTrue((boolean)ramEfficiency.getChildren().isEmpty());
        Assert.assertThat((Object)ramEfficiency.getParents(), (Matcher)IsCollectionContaining.hasItems((Object[])new Characteristic[]{efficiency}));
    }

    @Test
    public void testGraphOfCharacteristics() {
        Model model = Model.createByName((String)"fake");
        Characteristic level1a = model.createCharacteristicByName("level1a");
        Characteristic level1b = model.createCharacteristicByName("level1b");
        Characteristic level2a = model.createCharacteristicByName("level2a");
        Characteristic level2b = model.createCharacteristicByName("level2b");
        level1a.addChildren(new Characteristic[]{level2a, level2b});
        level1b.addChildren(new Characteristic[]{level2a, level2b});
        this.getSession().save((Object)model);
        this.getSession().commit();
        Model persistedModel = (Model)this.getSession().getSingleResult(Model.class, new Object[]{"name", "fake"});
        Assert.assertThat((Object)persistedModel.getCharacteristics().size(), (Matcher)Matchers.is((Object)4));
        Assert.assertThat((Object)persistedModel.getRootCharacteristics().size(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)persistedModel.getCharacteristicByName("level1a").getChildren().size(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)persistedModel.getCharacteristicByName("level1b").getChildren().size(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)persistedModel.getCharacteristicByName("level2a").getParents().size(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)persistedModel.getCharacteristicByName("level2b").getParents().size(), (Matcher)Matchers.is((Object)2));
    }
}

