/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.resource;

import java.util.Map;
import org.fest.assertions.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.sonar.core.persistence.AbstractDaoTestCase;
import org.sonar.core.resource.ResourceKeyUpdaterDao;

public class ResourceKeyUpdaterDaoTest
extends AbstractDaoTestCase {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private ResourceKeyUpdaterDao dao;

    @Before
    public void createDao() {
        this.dao = new ResourceKeyUpdaterDao(this.getMyBatis());
    }

    @Test
    public void shouldUpdateKey() {
        this.setupData("shared");
        this.dao.updateKey(2L, "struts:core");
        this.checkTables("shouldUpdateKey", "projects");
    }

    @Test
    public void shouldNotUpdateKey() {
        this.setupData("shared");
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("Impossible to update key: a resource with \"org.struts:struts-ui\" key already exists.");
        this.dao.updateKey(2L, "org.struts:struts-ui");
    }

    @Test
    public void shouldBulkUpdateKey() {
        this.setupData("shared");
        this.dao.bulkUpdateKey(1L, "org.struts", "org.apache.struts");
        this.checkTables("shouldBulkUpdateKey", "projects");
    }

    @Test
    public void shouldBulkUpdateKeyOnOnlyOneSubmodule() {
        this.setupData("shared");
        this.dao.bulkUpdateKey(1L, "struts-ui", "struts-web");
        this.checkTables("shouldBulkUpdateKeyOnOnlyOneSubmodule", "projects");
    }

    @Test
    public void shouldFailBulkUpdateKeyIfKeyAlreadyExist() {
        this.setupData("shared");
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("Impossible to update key: a resource with \"foo:struts-core\" key already exists.");
        this.dao.bulkUpdateKey(1L, "org.struts", "foo");
    }

    @Test
    public void shouldNotUpdateAllSubmodules() throws Exception {
        this.setupData("shouldNotUpdateAllSubmodules");
        this.dao.bulkUpdateKey(1L, "org.struts", "org.apache.struts");
        this.checkTables("shouldNotUpdateAllSubmodules", "projects");
    }

    @Test
    public void shouldCheckModuleKeysBeforeRenaming() {
        this.setupData("shared");
        Map checkResults = this.dao.checkModuleKeysBeforeRenaming(1L, "org.struts", "foo");
        Assertions.assertThat((int)checkResults.size()).isEqualTo(3);
        Assertions.assertThat((String)((String)checkResults.get("org.struts:struts"))).isEqualTo((Object)"foo:struts");
        Assertions.assertThat((String)((String)checkResults.get("org.struts:struts-core"))).isEqualTo((Object)"#duplicate_key#");
        Assertions.assertThat((String)((String)checkResults.get("org.struts:struts-ui"))).isEqualTo((Object)"foo:struts-ui");
    }
}

