/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.review;

import com.google.common.base.Predicate;
import java.util.Collection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.sonar.api.utils.DateUtils;
import org.sonar.core.persistence.AbstractDaoTestCase;
import org.sonar.core.review.ReviewDao;
import org.sonar.core.review.ReviewDto;
import org.sonar.core.review.ReviewPredicates;

public class ReviewDaoTest
extends AbstractDaoTestCase {
    private ReviewDao dao;

    @Before
    public void createDao() {
        this.dao = new ReviewDao(this.getMyBatis());
    }

    @Test
    public void shouldFindReviewById() {
        this.setupData("shared");
        ReviewDto review = this.dao.findById(100L);
        Assert.assertThat((Object)review.getId(), (Matcher)CoreMatchers.is((Object)100L));
        Assert.assertThat((Object)review.getStatus(), (Matcher)CoreMatchers.is((Object)"OPEN"));
        Assert.assertThat((Object)review.getResolution(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)review.getProjectId(), (Matcher)CoreMatchers.is((Object)20));
        Assert.assertThat((Object)review.getViolationPermanentId(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)review.getSeverity(), (Matcher)CoreMatchers.is((Object)"BLOCKER"));
        Assert.assertThat((Object)review.getUserId(), (Matcher)CoreMatchers.is((Object)300));
        Assert.assertThat((Object)review.getResourceId(), (Matcher)CoreMatchers.is((Object)400));
        Assert.assertThat((Object)review.getRuleId(), (Matcher)CoreMatchers.is((Object)500));
        Assert.assertThat((Object)review.getManualViolation(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)review.getActionPlanId(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void shouldSelectOpenByResourceId() {
        this.setupData("shared");
        Collection reviews = this.dao.selectOpenByResourceId(400L, new Predicate[0]);
        Assert.assertThat((Object)reviews.size(), (Matcher)CoreMatchers.is((Object)1));
        ReviewDto review = (ReviewDto)reviews.iterator().next();
        Assert.assertThat((Object)review.getId(), (Matcher)CoreMatchers.is((Object)100L));
        Assert.assertThat((Object)review.getStatus(), (Matcher)CoreMatchers.is((Object)"OPEN"));
        Assert.assertThat((Object)review.getResolution(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)review.getProjectId(), (Matcher)CoreMatchers.is((Object)20));
        Assert.assertThat((Object)review.getViolationPermanentId(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)review.getSeverity(), (Matcher)CoreMatchers.is((Object)"BLOCKER"));
        Assert.assertThat((Object)review.getUserId(), (Matcher)CoreMatchers.is((Object)300));
        Assert.assertThat((Object)review.getResourceId(), (Matcher)CoreMatchers.is((Object)400));
        Assert.assertThat((Object)review.getRuleId(), (Matcher)CoreMatchers.is((Object)500));
        Assert.assertThat((Object)review.getManualViolation(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)review.getActionPlanId(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void shouldReturnEmptyCollectionIfResourceNotFound() {
        this.setupData("shared");
        Assert.assertThat((Object)this.dao.selectOpenByResourceId(123456789L, new Predicate[0]).isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void shouldFilterResults() {
        this.setupData("shared");
        Collection reviews = this.dao.selectOpenByResourceId(401L, new Predicate[]{ReviewPredicates.status((String[])new String[]{"REOPENED"})});
        Assert.assertThat((Object)reviews.size(), (Matcher)CoreMatchers.is((Object)1));
        ReviewDto review = (ReviewDto)reviews.iterator().next();
        Assert.assertThat((Object)review.getId(), (Matcher)CoreMatchers.is((Object)103L));
        Assert.assertThat((Object)review.getStatus(), (Matcher)CoreMatchers.is((Object)"REOPENED"));
    }

    @Test
    public void update() {
        this.setupData("update");
        Collection reviews = this.dao.selectOpenByResourceId(400L, new Predicate[0]);
        ReviewDto review = (ReviewDto)reviews.iterator().next();
        review.setLine(Integer.valueOf(1000));
        review.setResolution("NEW_RESOLUTION");
        review.setStatus("NEW_STATUS");
        review.setSeverity("NEW_SEV");
        review.setAssigneeId(Long.valueOf(1001L));
        review.setManualSeverity(true);
        review.setManualViolation(false);
        review.setTitle("NEW_TITLE");
        review.setCreatedAt(DateUtils.parseDate((String)"2012-05-18"));
        review.setUpdatedAt(DateUtils.parseDate((String)"2012-07-01"));
        review.setData("big=bang");
        this.dao.update(reviews);
        this.checkTables("update", "reviews");
    }
}

