/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.user;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.sonar.api.database.model.User;
import org.sonar.api.security.UserFinder;
import org.sonar.core.user.DefaultUserFinder;
import org.sonar.jpa.test.AbstractDbUnitTestCase;

public class DefaultUserFinderTest
extends AbstractDbUnitTestCase {
    private UserFinder userFinder;

    @Before
    public void setUp() {
        this.setupData("fixture");
        this.userFinder = new DefaultUserFinder(this.getSessionFactory());
    }

    @Test
    public void shouldFindUserByLogin() {
        User user = this.userFinder.findByLogin("simon");
        Assert.assertThat((Object)user.getId(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)user.getLogin(), (Matcher)Matchers.is((Object)"simon"));
        Assert.assertThat((Object)user.getName(), (Matcher)Matchers.is((Object)"Simon Brandhof"));
        Assert.assertThat((Object)user.getEmail(), (Matcher)Matchers.is((Object)"simon.brandhof@sonarsource.com"));
        user = this.userFinder.findByLogin("godin");
        Assert.assertThat((Object)user.getId(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)user.getLogin(), (Matcher)Matchers.is((Object)"godin"));
        Assert.assertThat((Object)user.getName(), (Matcher)Matchers.is((Object)"Evgeny Mandrikov"));
        Assert.assertThat((Object)user.getEmail(), (Matcher)Matchers.is((Object)"evgeny.mandrikov@sonarsource.com"));
        user = this.userFinder.findByLogin("user");
        Assert.assertThat((Object)user, (Matcher)Matchers.nullValue());
    }

    @Test
    public void shouldFindUserById() {
        User user = this.userFinder.findById(1);
        Assert.assertThat((Object)user.getId(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)user.getLogin(), (Matcher)Matchers.is((Object)"simon"));
        Assert.assertThat((Object)user.getName(), (Matcher)Matchers.is((Object)"Simon Brandhof"));
        Assert.assertThat((Object)user.getEmail(), (Matcher)Matchers.is((Object)"simon.brandhof@sonarsource.com"));
        user = this.userFinder.findById(2);
        Assert.assertThat((Object)user.getId(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)user.getLogin(), (Matcher)Matchers.is((Object)"godin"));
        Assert.assertThat((Object)user.getName(), (Matcher)Matchers.is((Object)"Evgeny Mandrikov"));
        Assert.assertThat((Object)user.getEmail(), (Matcher)Matchers.is((Object)"evgeny.mandrikov@sonarsource.com"));
        user = this.userFinder.findById(3);
        Assert.assertThat((Object)user, (Matcher)Matchers.nullValue());
    }
}

