/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.workflow;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fest.assertions.Assertions;
import org.hamcrest.Matcher;
import org.junit.Rule;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.junit.rules.ExpectedException;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.sonar.api.config.Settings;
import org.sonar.api.workflow.MutableReview;
import org.sonar.api.workflow.Review;
import org.sonar.api.workflow.WorkflowContext;
import org.sonar.api.workflow.condition.Condition;
import org.sonar.api.workflow.condition.HasProjectPropertyCondition;
import org.sonar.api.workflow.function.Function;
import org.sonar.api.workflow.internal.DefaultReview;
import org.sonar.api.workflow.internal.DefaultWorkflow;
import org.sonar.api.workflow.internal.DefaultWorkflowContext;
import org.sonar.api.workflow.screen.CommentScreen;
import org.sonar.api.workflow.screen.Screen;
import org.sonar.core.workflow.ImmutableReview;
import org.sonar.core.workflow.ReviewStore;
import org.sonar.core.workflow.WorkflowEngine;

public class WorkflowEngineTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void listAvailableScreensForReview_empty() {
        WorkflowEngine engine = new WorkflowEngine(new DefaultWorkflow(), (ReviewStore)Mockito.mock(ReviewStore.class), new Settings());
        List screens = engine.listAvailableScreens((Review)new DefaultReview(), new DefaultWorkflowContext(), true);
        Assertions.assertThat((List)screens).isEmpty();
    }

    @Test
    public void listAvailableScreensForReview() {
        DefaultWorkflow workflow = new DefaultWorkflow();
        workflow.addCommand("command-without-screen");
        workflow.addCommand("resolve");
        CommentScreen screen = new CommentScreen();
        workflow.setScreen("resolve", (Screen)screen);
        WorkflowEngine engine = new WorkflowEngine(workflow, (ReviewStore)Mockito.mock(ReviewStore.class), new Settings());
        List screens = engine.listAvailableScreens((Review)new DefaultReview(), new DefaultWorkflowContext(), true);
        Assertions.assertThat((List)screens).containsExactly(new Object[]{screen});
    }

    @Test
    public void listAvailableScreensForReview_verify_conditions() {
        DefaultWorkflow workflow = new DefaultWorkflow();
        workflow.addCommand("resolve");
        Condition condition = (Condition)Mockito.mock(Condition.class);
        Mockito.when((Object)condition.doVerify((Review)Matchers.any(Review.class), (WorkflowContext)Matchers.any(WorkflowContext.class))).thenReturn((Object)false);
        workflow.addCondition("resolve", condition);
        workflow.setScreen("resolve", (Screen)new CommentScreen());
        WorkflowEngine engine = new WorkflowEngine(workflow, (ReviewStore)Mockito.mock(ReviewStore.class), new Settings());
        DefaultReview review = new DefaultReview();
        DefaultWorkflowContext context = new DefaultWorkflowContext();
        Assertions.assertThat((List)engine.listAvailableScreens((Review)review, context, true)).isEmpty();
        ((Condition)Mockito.verify((Object)condition)).doVerify((Review)review, (WorkflowContext)context);
    }

    @Test
    public void listAvailableScreensForReviews_empty() {
        WorkflowEngine engine = new WorkflowEngine(new DefaultWorkflow(), (ReviewStore)Mockito.mock(ReviewStore.class), new Settings());
        ListMultimap screens = engine.listAvailableScreens(new DefaultReview[]{new DefaultReview().setViolationId(Long.valueOf(1000L)), new DefaultReview().setViolationId(Long.valueOf(2000L))}, new DefaultWorkflowContext(), true);
        Assertions.assertThat((int)screens.size()).isEqualTo(0);
    }

    @Test
    public void listAvailableScreensForReviews() {
        DefaultWorkflow workflow = new DefaultWorkflow();
        workflow.addCommand("command-without-screen");
        workflow.addCommand("resolve");
        CommentScreen screen = new CommentScreen();
        workflow.setScreen("resolve", (Screen)screen);
        WorkflowEngine engine = new WorkflowEngine(workflow, (ReviewStore)Mockito.mock(ReviewStore.class), new Settings());
        ListMultimap screens = engine.listAvailableScreens(new DefaultReview[]{new DefaultReview().setViolationId(Long.valueOf(1000L)), new DefaultReview().setViolationId(Long.valueOf(2000L))}, new DefaultWorkflowContext(), true);
        Assertions.assertThat((int)screens.size()).isEqualTo(2);
        Assertions.assertThat((List)screens.get((Object)1000L)).containsExactly(new Object[]{screen});
        Assertions.assertThat((List)screens.get((Object)2000L)).containsExactly(new Object[]{screen});
    }

    @Test
    public void listAvailableScreensForReviews_load_project_properties() {
        DefaultWorkflow workflow = new DefaultWorkflow();
        workflow.addCommand("resolve");
        workflow.addCondition("resolve", (Condition)new HasProjectPropertyCondition("foo"));
        ReviewStore store = (ReviewStore)Mockito.mock(ReviewStore.class);
        WorkflowEngine engine = new WorkflowEngine(workflow, store, new Settings());
        engine.listAvailableScreens(new DefaultReview[]{new DefaultReview().setViolationId(Long.valueOf(1000L)), new DefaultReview().setViolationId(Long.valueOf(2000L))}, new DefaultWorkflowContext().setProjectId(Long.valueOf(300L)), true);
        ((ReviewStore)Mockito.verify((Object)store)).completeProjectSettings(Long.valueOf(Mockito.eq((long)300L)), (Settings)Matchers.any(Settings.class), (List)Mockito.argThat((Matcher)JUnitMatchers.hasItem((Object)"foo")));
    }

    @Test
    public void execute_conditions_pass() {
        DefaultWorkflow workflow = new DefaultWorkflow();
        workflow.addCommand("resolve");
        workflow.addCondition("resolve", (Condition)new HasProjectPropertyCondition("foo"));
        Function function = (Function)Mockito.mock(Function.class);
        workflow.addFunction("resolve", function);
        ReviewStore store = (ReviewStore)Mockito.mock(ReviewStore.class);
        Settings settings = new Settings();
        settings.setProperty("foo", "bar");
        WorkflowEngine engine = new WorkflowEngine(workflow, store, settings);
        DefaultReview review = new DefaultReview().setViolationId(Long.valueOf(1000L));
        HashMap parameters = Maps.newHashMap();
        DefaultWorkflowContext context = new DefaultWorkflowContext().setProjectId(Long.valueOf(300L));
        engine.execute("resolve", review, context, (Map)parameters);
        ((ReviewStore)Mockito.verify((Object)store)).completeProjectSettings(Long.valueOf(Mockito.eq((long)300L)), (Settings)Matchers.any(Settings.class), (List)Mockito.argThat((Matcher)JUnitMatchers.hasItem((Object)"foo")));
        ((Function)Mockito.verify((Object)function)).doExecute((MutableReview)Mockito.eq((Object)review), (Review)Matchers.any(ImmutableReview.class), (WorkflowContext)Mockito.eq((Object)context), (Map)Mockito.eq((Object)parameters));
    }

    @Test
    public void execute_fail_if_conditions_dont_pass() {
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("Condition is not respected: Property foo must be set");
        DefaultWorkflow workflow = new DefaultWorkflow();
        workflow.addCommand("resolve");
        workflow.addCondition("resolve", (Condition)new HasProjectPropertyCondition("foo"));
        Function function = (Function)Mockito.mock(Function.class);
        workflow.addFunction("resolve", function);
        ReviewStore store = (ReviewStore)Mockito.mock(ReviewStore.class);
        Settings settings = new Settings();
        WorkflowEngine engine = new WorkflowEngine(workflow, store, settings);
        DefaultReview review = new DefaultReview().setViolationId(Long.valueOf(1000L));
        HashMap parameters = Maps.newHashMap();
        DefaultWorkflowContext context = new DefaultWorkflowContext().setProjectId(Long.valueOf(300L));
        engine.execute("resolve", review, context, (Map)parameters);
    }
}

