/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.test.miniC;

import com.google.common.collect.Lists;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.api.Preprocessor;
import com.sonar.sslr.api.PreprocessorAction;
import com.sonar.sslr.api.RecognitionException;
import com.sonar.sslr.api.Rule;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.Trivia;
import com.sonar.sslr.impl.Parser;
import com.sonar.sslr.test.miniC.MiniCLexer;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MiniCPreprocessor
extends Preprocessor {
    private final List<Token> buffer = Lists.newLinkedList();
    private AstNode structure;
    private Grammar structureGrammar;

    public void init() {
        this.buffer.clear();
    }

    private boolean isBufferValid() {
        Parser parser = Parser.builder((Grammar)new MiniCPreprocessorGrammar()).build();
        try {
            AstNode node;
            this.structure = node = parser.parse(this.buffer);
            this.structureGrammar = parser.getGrammar();
            return true;
        }
        catch (RecognitionException re) {
            return false;
        }
    }

    private Trivia preprocessBuffer() {
        return Trivia.createPreprocessingDirective((AstNode)this.structure, (Grammar)this.structureGrammar);
    }

    public PreprocessorAction process(List<Token> tokens) {
        LinkedList<Trivia> triviaToInject = new LinkedList<Trivia>();
        if (!(this.buffer.isEmpty() || tokens.get(0).getType() != GenericTokenType.EOF && tokens.get(0).getLine() == this.buffer.get(0).getLine())) {
            if (!this.isBufferValid()) {
                throw new IllegalStateException("FIXME Pushback would be required!");
            }
            triviaToInject.add(this.preprocessBuffer());
            this.buffer.clear();
        }
        if (this.buffer.isEmpty()) {
            if (tokens.get(0).getType() == MiniCLexer.Punctuators.HASH) {
                this.buffer.add(tokens.get(0));
                return new PreprocessorAction(1, triviaToInject, new LinkedList());
            }
            return new PreprocessorAction(0, triviaToInject, new LinkedList());
        }
        this.buffer.add(tokens.get(0));
        return new PreprocessorAction(1, triviaToInject, new LinkedList());
    }

    public class MiniCPreprocessorGrammar
    extends Grammar {
        public Rule defineDirective;
        public Rule binDefinition;

        public MiniCPreprocessorGrammar() {
            this.defineDirective.is(new Object[]{MiniCLexer.Punctuators.HASH, "define", this.binDefinition});
            this.binDefinition.is(new Object[]{GenericTokenType.IDENTIFIER});
        }

        public Rule getRootRule() {
            return this.defineDirective;
        }
    }
}

