/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.test.channel;

import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.sonar.sslr.channel.Channel;
import org.sonar.sslr.channel.CodeReader;

public class ChannelMatcher<O>
extends BaseMatcher<Channel<O>> {
    private final String sourceCode;
    private final O output;
    private final CodeReader reader;

    public ChannelMatcher(String sourceCode, O output) {
        this.sourceCode = sourceCode;
        this.output = output;
        this.reader = new CodeReader(sourceCode);
    }

    public ChannelMatcher(CodeReader reader, O output) {
        this.output = output;
        this.sourceCode = new String(reader.peek(30));
        this.reader = reader;
    }

    public boolean matches(Object arg0) {
        if (!(arg0 instanceof Channel)) {
            return false;
        }
        Channel channel = (Channel)arg0;
        return channel.consume(this.reader, this.output);
    }

    public void describeTo(Description description) {
        description.appendText("Channel consumes '" + this.sourceCode + "'");
    }
}

