/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.internal.toolkit;

import com.google.common.base.Preconditions;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.impl.Parser;
import com.sonar.sslr.impl.ast.AstXmlPrinter;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.List;
import org.sonar.colorizer.HtmlOptions;
import org.sonar.colorizer.HtmlRenderer;
import org.sonar.colorizer.Tokenizer;
import org.sonar.sslr.internal.guava.Files;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceCodeModel {
    private final Parser<?> parser;
    private final List<Tokenizer> tokenizers;
    private final HtmlRenderer htmlRenderer = new HtmlRenderer(new HtmlOptions(false, null, false));
    private String sourceCode;
    private AstNode astNode;

    public SourceCodeModel(Parser<?> parser, List<Tokenizer> tokenizers) {
        Preconditions.checkNotNull(parser);
        Preconditions.checkNotNull(tokenizers);
        this.parser = parser;
        this.tokenizers = tokenizers;
    }

    public void setSourceCode(File source, Charset charset) {
        this.astNode = this.parser.parse(source);
        this.sourceCode = Files.toString(source, charset);
    }

    public void setSourceCode(String sourceCode) {
        this.astNode = this.parser.parse(sourceCode);
        this.sourceCode = sourceCode;
    }

    public String getHighlightedSourceCode() {
        return this.htmlRenderer.render((Reader)new StringReader(this.sourceCode), this.tokenizers);
    }

    public String getXml() {
        return AstXmlPrinter.print((AstNode)this.astNode);
    }

    public AstNode getAstNode() {
        return this.astNode;
    }
}

