/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stomp.tcp;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import javax.net.SocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.stomp.StompFrame;
import org.codehaus.stomp.StompHandler;
import org.codehaus.stomp.StompMarshaller;
import org.codehaus.stomp.util.IntrospectionSupport;
import org.codehaus.stomp.util.ServiceSupport;

public class TcpTransport
extends ServiceSupport
implements Runnable,
StompHandler {
    private static final Log log = LogFactory.getLog(TcpTransport.class);
    private StompMarshaller marshaller = new StompMarshaller();
    private StompHandler inputHandler;
    private final URI remoteLocation;
    private final URI localLocation;
    private int connectionTimeout = 30000;
    private int soTimeout = 0;
    private int socketBufferSize = 65536;
    private int ioBufferSize = 8192;
    private Socket socket;
    private DataOutputStream dataOut;
    private DataInputStream dataIn;
    private boolean trace;
    private boolean useLocalHost = true;
    private SocketFactory socketFactory;
    private Map socketOptions;
    private Boolean keepAlive;
    private Boolean tcpNoDelay;
    private boolean daemon = false;
    private Thread runner;

    public TcpTransport(Socket socket, Map socketOptions) throws IOException {
        this.socketOptions = socketOptions;
        this.socket = socket;
        this.remoteLocation = null;
        this.localLocation = null;
        this.setDaemon(true);
    }

    public TcpTransport(StompHandler stompHandler, SocketFactory socketFactory, URI remoteLocation, URI localLocation) throws IOException {
        this.inputHandler = stompHandler;
        this.socketFactory = socketFactory;
        try {
            this.socket = socketFactory.createSocket();
        }
        catch (SocketException e) {
            this.socket = null;
        }
        this.remoteLocation = remoteLocation;
        this.localLocation = localLocation;
        this.setDaemon(false);
    }

    public synchronized void onStompFrame(StompFrame command) throws Exception {
        this.checkStarted();
        this.marshaller.marshal(command, this.dataOut);
        this.dataOut.flush();
    }

    public void onException(Exception e) {
        log.error((Object)("Caught: " + e), (Throwable)e);
    }

    public void close() throws Exception {
        this.stop();
    }

    public String toString() {
        return "tcp://" + this.socket.getInetAddress() + ":" + this.socket.getPort();
    }

    public void run() {
        log.trace((Object)"StompConnect TCP consumer thread starting");
        while (!this.isStopped()) {
            try {
                StompFrame frame = this.marshaller.unmarshal(this.dataIn);
                this.inputHandler.onStompFrame(frame);
            }
            catch (SocketTimeoutException frame) {
            }
            catch (InterruptedIOException frame) {
            }
            catch (Exception e) {
                try {
                    this.stop();
                }
                catch (Exception e2) {
                    log.warn((Object)("Caught while closing: " + e2 + ". Now Closed"), (Throwable)e2);
                }
                if (e instanceof EOFException) continue;
                this.inputHandler.onException(e);
            }
        }
    }

    public StompHandler getInputHandler() {
        return this.inputHandler;
    }

    public void setInputHandler(StompHandler inputHandler) {
        this.inputHandler = inputHandler;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public boolean isTrace() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public boolean isUseLocalHost() {
        return this.useLocalHost;
    }

    public void setUseLocalHost(boolean useLocalHost) {
        this.useLocalHost = useLocalHost;
    }

    public int getSocketBufferSize() {
        return this.socketBufferSize;
    }

    public void setSocketBufferSize(int socketBufferSize) {
        this.socketBufferSize = socketBufferSize;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public Boolean getKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(Boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public Boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(Boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public int getIoBufferSize() {
        return this.ioBufferSize;
    }

    public void setIoBufferSize(int ioBufferSize) {
        this.ioBufferSize = ioBufferSize;
    }

    public void setSocketOptions(Map socketOptions) {
        this.socketOptions = new HashMap(socketOptions);
    }

    public String getRemoteAddress() {
        if (this.socket != null) {
            return "" + this.socket.getRemoteSocketAddress();
        }
        return null;
    }

    protected String resolveHostName(String host) throws UnknownHostException {
        String localName = InetAddress.getLocalHost().getHostName();
        if (localName != null && this.isUseLocalHost() && localName.equals(host)) {
            return "localhost";
        }
        return host;
    }

    protected void initialiseSocket(Socket sock) throws SocketException {
        if (this.socketOptions != null) {
            IntrospectionSupport.setProperties(this.socket, this.socketOptions);
        }
        try {
            sock.setReceiveBufferSize(this.socketBufferSize);
            sock.setSendBufferSize(this.socketBufferSize);
        }
        catch (SocketException se) {
            log.warn((Object)("Cannot set socket buffer size = " + this.socketBufferSize));
            log.debug((Object)("Cannot set socket buffer size. Reason: " + se), (Throwable)se);
        }
        sock.setSoTimeout(this.soTimeout);
        if (this.keepAlive != null) {
            sock.setKeepAlive(this.keepAlive);
        }
        if (this.tcpNoDelay != null) {
            sock.setTcpNoDelay(this.tcpNoDelay);
        }
    }

    protected void doStart() throws Exception {
        this.connect();
        this.runner = new Thread((Runnable)this, "StompConnect Transport: " + this.toString());
        this.runner.setDaemon(this.daemon);
        this.runner.start();
    }

    protected void connect() throws Exception {
        if (this.socket == null && this.socketFactory == null) {
            throw new IllegalStateException("Cannot connect if the socket or socketFactory have not been set");
        }
        InetSocketAddress localAddress = null;
        InetSocketAddress remoteAddress = null;
        if (this.localLocation != null) {
            localAddress = new InetSocketAddress(InetAddress.getByName(this.localLocation.getHost()), this.localLocation.getPort());
        }
        if (this.remoteLocation != null) {
            String host = this.resolveHostName(this.remoteLocation.getHost());
            remoteAddress = new InetSocketAddress(host, this.remoteLocation.getPort());
        }
        if (this.socket != null) {
            if (localAddress != null) {
                this.socket.bind(localAddress);
            }
            if (remoteAddress != null) {
                if (this.connectionTimeout >= 0) {
                    this.socket.connect(remoteAddress, this.connectionTimeout);
                } else {
                    this.socket.connect(remoteAddress);
                }
            }
        } else {
            this.socket = localAddress != null ? this.socketFactory.createSocket(remoteAddress.getAddress(), remoteAddress.getPort(), localAddress.getAddress(), localAddress.getPort()) : this.socketFactory.createSocket(remoteAddress.getAddress(), remoteAddress.getPort());
        }
        this.initialiseSocket(this.socket);
        this.initializeStreams();
    }

    protected void doStop() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Stopping transport " + this));
        }
        if (this.inputHandler != null) {
            this.inputHandler.close();
        }
        if (this.socket != null) {
            this.socket.close();
        }
    }

    protected void checkStarted() throws IOException {
        if (!this.isStarted()) {
            throw new IOException("The transport is not running.");
        }
    }

    protected void initializeStreams() throws Exception {
        this.dataIn = new DataInputStream(this.socket.getInputStream());
        this.dataOut = new DataOutputStream(this.socket.getOutputStream());
    }

    protected void closeStreams() throws IOException {
        if (this.dataOut != null) {
            this.dataOut.close();
        }
        if (this.dataIn != null) {
            this.dataIn.close();
        }
    }
}

