/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.swizzle.jira;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.swizzle.jira.Issue;
import org.codehaus.swizzle.jira.IssueFiller;
import org.codehaus.swizzle.jira.Jira;
import org.codehaus.swizzle.jira.JiraRss;
import org.codehaus.swizzle.jira.ServerInfo;
import org.codehaus.swizzle.jira.User;
import org.codehaus.swizzle.stream.DelimitedTokenReplacementInputStream;
import org.codehaus.swizzle.stream.IncludeFilterInputStream;
import org.codehaus.swizzle.stream.StreamTokenHandler;
import org.codehaus.swizzle.stream.StringTokenHandler;

public class VotersFiller
implements IssueFiller {
    private final Jira jira;
    private boolean enabled;

    public VotersFiller(Jira jira) {
        this.jira = jira;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void fill(Issue issue) {
        if (!this.enabled) {
            return;
        }
        ServerInfo serverInfo = this.jira.getServerInfo();
        String baseUrlString = serverInfo.getBaseUrl();
        this.getVotes(baseUrlString, issue);
    }

    public static List fill(JiraRss jiraRss) throws Exception {
        VotersFiller filler = new VotersFiller(null);
        List issues = jiraRss.getIssues();
        for (int i = 0; i < issues.size(); ++i) {
            Issue issue = (Issue)issues.get(i);
            String link = issue.getLink();
            link = link.replaceFirst("/browse/.*$", "/");
            filler.getVotes(link, issue);
        }
        return issues;
    }

    private void getVotes(String baseUrlString, Issue issue) {
        try {
            final ArrayList votes = new ArrayList();
            URL baseUrl = new URL(baseUrlString);
            URL url = new URL(baseUrl, "secure/ViewVoters!default.jspa?id=" + issue.getId());
            BufferedInputStream in = new BufferedInputStream(url.openStream());
            in = new IncludeFilterInputStream((InputStream)in, "<a id=\"voter_link", "/a>");
            in = new DelimitedTokenReplacementInputStream((InputStream)in, "name=", "<", (StreamTokenHandler)new StringTokenHandler(){

                public String handleToken(String token) throws IOException {
                    String[] s = token.split("\">");
                    try {
                        if (VotersFiller.this.jira == null) {
                            User user = new User();
                            user.setName(s[0]);
                            user.setFullname(s[1]);
                            votes.add(user);
                        } else {
                            User user = VotersFiller.this.jira.getUser(s[0]);
                            if (user != null) {
                                votes.add(user);
                            }
                        }
                    }
                    catch (Exception e) {
                        System.err.println("Bad voter string: " + token + ", " + e.getClass().getName() + ": " + e.getMessage());
                    }
                    return "";
                }
            });
            int i = ((InputStream)in).read();
            while (i != -1) {
                i = ((InputStream)in).read();
            }
            ((InputStream)in).close();
            issue.setVoters(votes);
        }
        catch (IOException e) {
            System.err.println(e.getClass().getName() + ": " + e.getMessage());
        }
    }
}

