/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.gen.jsr181;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.codehaus.xfire.fault.FaultInfoException;
import org.codehaus.xfire.gen.GenerationContext;
import org.codehaus.xfire.gen.GenerationException;
import org.codehaus.xfire.gen.GeneratorPlugin;
import org.codehaus.xfire.gen.SchemaSupport;
import org.codehaus.xfire.gen.jsr181.AbstractPlugin;
import org.codehaus.xfire.service.FaultInfo;
import org.codehaus.xfire.service.MessagePartInfo;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaultGenerator
extends AbstractPlugin
implements GeneratorPlugin {
    public static final String EXCEPTION_CLASSES = "exception.classes";
    private Map<QName, JClass> exClasses = new HashMap<QName, JClass>();

    @Override
    public void generate(GenerationContext context) throws Exception {
        context.setProperty(EXCEPTION_CLASSES, this.exClasses);
        for (Map.Entry<QName, Collection<Service>> entry : context.getServices().entrySet()) {
            this.generate(context, entry.getKey(), (List)entry.getValue());
        }
    }

    public void generate(GenerationContext context, QName name, List<Service> services) throws Exception {
        for (Service service : services) {
            for (OperationInfo op : service.getServiceInfo().getOperations()) {
                for (FaultInfo fault : op.getFaults()) {
                    List messageParts = fault.getMessageParts();
                    MessagePartInfo part = (MessagePartInfo)messageParts.get(0);
                    if (this.exClasses.containsKey(fault.getMessageName())) continue;
                    JClass excls = this.generateExceptionClass(context, fault, part);
                    this.exClasses.put(fault.getMessageName(), excls);
                }
            }
        }
    }

    protected JClass generateExceptionClass(GenerationContext context, FaultInfo fault, MessagePartInfo part) throws GenerationException {
        JDefinedClass exCls2;
        JCodeModel model = context.getCodeModel();
        SchemaSupport schema = context.getSchemaGenerator();
        String name = this.javify(fault.getMessageName().getLocalPart());
        name = name.substring(0, 1).toUpperCase() + name.substring(1);
        JType paramType = schema.getType(context, part.getName(), part.getSchemaType().getSchemaType());
        String clsName = this.getPackage(fault.getOperation().getService().getService().getName(), context) + "." + name;
        try {
            exCls2 = model._class(clsName);
        }
        catch (JClassAlreadyExistsException e) {
            clsName = clsName + "_Exception";
            try {
                exCls2 = model._class(clsName);
            }
            catch (JClassAlreadyExistsException e1) {
                JDefinedClass exCls2 = model._getClass(clsName);
                return exCls2;
            }
        }
        return this.generateExceptionClass(part, model, paramType, exCls2);
    }

    protected JClass generateExceptionClass(MessagePartInfo part, JCodeModel model, JType paramType, JDefinedClass exCls) {
        exCls._extends(FaultInfoException.class);
        exCls.field(4, paramType, "faultInfo");
        JMethod getFaultInfo = exCls.method(1, paramType, "getFaultInfo");
        getFaultInfo.body()._return((JExpression)JExpr.ref((String)"faultInfo"));
        JMethod cons = exCls.constructor(1);
        cons.param(String.class, "message");
        cons.param(paramType, "faultInfo");
        cons.body().invoke("super").arg((JExpression)JExpr.ref((String)"message"));
        cons.body().assign((JAssignmentTarget)JExpr.refthis((String)"faultInfo"), (JExpression)JExpr.ref((String)"faultInfo"));
        cons = exCls.constructor(1);
        cons.param(String.class, "message");
        cons.param(Throwable.class, "t");
        cons.param(paramType, "faultInfo");
        cons.body().invoke("super").arg((JExpression)JExpr.ref((String)"message")).arg((JExpression)JExpr.ref((String)"t"));
        cons.body().assign((JAssignmentTarget)JExpr.refthis((String)"faultInfo"), (JExpression)JExpr.ref((String)"faultInfo"));
        JClass qType = model.ref(QName.class);
        JMethod getName = exCls.method(17, (JType)qType, "getFaultName");
        getName.body()._return((JExpression)JExpr._new((JClass)qType).arg(part.getName().getNamespaceURI()).arg(part.getName().getLocalPart()));
        return exCls;
    }
}

