/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.jaxb2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.jaxb2.JaxbType;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.transport.TransportManager;
import org.codehaus.xfire.wsdl.SchemaType;
import org.codehaus.xfire.wsdl11.builder.WSDLBuilder;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.input.DOMBuilder;
import org.w3c.dom.Document;

public class JaxbWSDLBuilder
extends WSDLBuilder {
    private Set<Class> classes = new HashSet<Class>();
    private Set<JaxbType> types = new HashSet<JaxbType>();
    private Set<String> namespaces = new HashSet<String>();

    public JaxbWSDLBuilder(Service service, TransportManager transportManager) throws WSDLException {
        super(service, transportManager);
    }

    public void addDependency(SchemaType type) {
        if (!this.hasDependency(type)) {
            if (type instanceof JaxbType) {
                JaxbType jaxbType = (JaxbType)type;
                if (this.types.contains((Object)jaxbType)) {
                    return;
                }
                this.classes.add(jaxbType.getTypeClass());
                this.namespaces.add(jaxbType.getSchemaType().getNamespaceURI());
                this.types.add(jaxbType);
            }
        } else {
            super.addDependency(type);
        }
    }

    protected void writeComplexTypes() {
        if (this.getService().getProperty("objectServiceFactory.schemas") == null) {
            this.generateJaxbSchemas();
        }
        super.writeComplexTypes();
    }

    private void generateJaxbSchemas() {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])this.classes.toArray(new Class[0]));
            final ArrayList results = new ArrayList();
            for (String ns : this.namespaces) {
                System.out.println("writing complex types");
                context.generateSchema(new SchemaOutputResolver(){

                    public Result createOutput(String ns, String file) throws IOException {
                        DOMResult result = new DOMResult();
                        result.setSystemId(file);
                        results.add(result);
                        return result;
                    }
                });
            }
            Types types = this.getDefinition().getTypes();
            if (types == null) {
                types = this.getDefinition().createTypes();
                this.getDefinition().setTypes(types);
            }
            DOMBuilder domBuilder = new DOMBuilder();
            for (DOMResult result : results) {
                Element schema = domBuilder.build(((Document)result.getNode()).getDocumentElement());
                schema.detach();
                this.getSchemaTypes().addContent((Content)schema);
            }
        }
        catch (JAXBException e) {
            throw new XFireRuntimeException("Couldn't generate a schema for the JAXB objects!", (Throwable)e);
        }
        catch (IOException e) {
            throw new XFireRuntimeException("Couldn't generate a schema for the JAXB objects!", (Throwable)e);
        }
    }
}

