/* The following code was generated by JFlex 1.4.1 on 8/2/06 6:03 AM */

/*
 * Copyright 2000-2006 Omnicore Software, Hans Kratz & Dennis Strein GbR,
 *                     Geert Bevin <gbevin[remove] at uwyn dot com>.
 * Distributed under the terms of either:
 * - the common development and distribution license (CDDL), v1.0; or
 * - the GNU Lesser General Public License, v2.1 or later
 * $Id: JavaHighlighter.java 3431 2006-08-02 04:09:28Z gbevin $
 */
package com.uwyn.jhighlight.highlighter;

import java.io.Reader;
import java.io.IOException;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.1
 * on 8/2/06 6:03 AM from the specification file
 * <tt>com/uwyn/jhighlight/highlighter/JavaHighlighter.flex</tt>
 */
public class JavaHighlighter implements ExplicitStateHighlighter {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 128;

  /** lexical states */
  public static final int YYINITIAL = 0;
  public static final int IN_COMMENT = 1;
  public static final int IN_JAVA_DOC_COMMENT = 2;

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\4\1\0\1\50\1\0\1\0\1\0\16\4\4\0\1\0\1\54"+
    "\1\47\1\0\1\2\1\54\1\54\1\52\1\53\1\53\1\55\1\24"+
    "\1\53\1\24\1\21\1\56\1\6\7\15\2\1\1\54\1\53\1\54"+
    "\1\54\1\54\1\54\1\57\3\14\1\17\1\23\1\17\5\5\1\10"+
    "\13\5\1\12\2\5\1\53\1\51\1\53\1\54\1\3\1\0\1\25"+
    "\1\26\1\13\1\20\1\22\1\16\1\45\1\33\1\36\1\2\1\32"+
    "\1\7\1\41\1\35\1\34\1\42\1\2\1\31\1\27\1\30\1\37"+
    "\1\43\1\44\1\11\1\40\1\46\1\53\1\54\1\53\1\54\41\4"+
    "\2\0\4\2\4\0\1\2\2\0\1\4\7\0\1\2\4\0\1\2"+
    "\5\0\27\2\1\0\37\2\1\0\u013f\2\31\0\162\2\4\0\14\2"+
    "\16\0\5\2\11\0\1\2\21\0\130\4\5\0\23\4\12\0\1\2"+
    "\13\0\1\2\1\0\3\2\1\0\1\2\1\0\24\2\1\0\54\2"+
    "\1\0\46\2\1\0\5\2\4\0\202\2\1\0\4\4\3\0\105\2"+
    "\1\0\46\2\2\0\2\2\6\0\20\2\41\0\46\2\2\0\1\2"+
    "\7\0\47\2\11\0\21\4\1\0\27\4\1\0\3\4\1\0\1\4"+
    "\1\0\2\4\1\0\1\4\13\0\33\2\5\0\3\2\15\0\4\4"+
    "\14\0\6\4\13\0\32\2\5\0\13\2\16\4\7\0\12\4\4\0"+
    "\2\2\1\4\143\2\1\0\1\2\10\4\1\0\6\4\2\2\2\4"+
    "\1\0\4\4\2\2\12\4\3\2\2\0\1\2\17\0\1\4\1\2"+
    "\1\4\36\2\33\4\2\0\3\2\60\0\46\2\13\4\1\2\u014f\0"+
    "\3\4\66\2\2\0\1\4\1\2\20\4\2\0\1\2\4\4\3\0"+
    "\12\2\2\4\2\0\12\4\21\0\3\4\1\0\10\2\2\0\2\2"+
    "\2\0\26\2\1\0\7\2\1\0\1\2\3\0\4\2\2\0\1\4"+
    "\1\2\7\4\2\0\2\4\2\0\3\4\11\0\1\4\4\0\2\2"+
    "\1\0\3\2\2\4\2\0\12\4\4\2\15\0\3\4\1\0\6\2"+
    "\4\0\2\2\2\0\26\2\1\0\7\2\1\0\2\2\1\0\2\2"+
    "\1\0\2\2\2\0\1\4\1\0\5\4\4\0\2\4\2\0\3\4"+
    "\13\0\4\2\1\0\1\2\7\0\14\4\3\2\14\0\3\4\1\0"+
    "\11\2\1\0\3\2\1\0\26\2\1\0\7\2\1\0\2\2\1\0"+
    "\5\2\2\0\1\4\1\2\10\4\1\0\3\4\1\0\3\4\2\0"+
    "\1\2\17\0\2\2\2\4\2\0\12\4\1\0\1\2\17\0\3\4"+
    "\1\0\10\2\2\0\2\2\2\0\26\2\1\0\7\2\1\0\2\2"+
    "\1\0\5\2\2\0\1\4\1\2\6\4\3\0\2\4\2\0\3\4"+
    "\10\0\2\4\4\0\2\2\1\0\3\2\4\0\12\4\1\0\1\2"+
    "\20\0\1\4\1\2\1\0\6\2\3\0\3\2\1\0\4\2\3\0"+
    "\2\2\1\0\1\2\1\0\2\2\3\0\2\2\3\0\3\2\3\0"+
    "\10\2\1\0\3\2\4\0\5\4\3\0\3\4\1\0\4\4\11\0"+
    "\1\4\17\0\11\4\11\0\1\2\7\0\3\4\1\0\10\2\1\0"+
    "\3\2\1\0\27\2\1\0\12\2\1\0\5\2\4\0\7\4\1\0"+
    "\3\4\1\0\4\4\7\0\2\4\11\0\2\2\4\0\12\4\22\0"+
    "\2\4\1\0\10\2\1\0\3\2\1\0\27\2\1\0\12\2\1\0"+
    "\5\2\2\0\1\4\1\2\7\4\1\0\3\4\1\0\4\4\7\0"+
    "\2\4\7\0\1\2\1\0\2\2\4\0\12\4\22\0\2\4\1\0"+
    "\10\2\1\0\3\2\1\0\27\2\1\0\20\2\4\0\6\4\2\0"+
    "\3\4\1\0\4\4\11\0\1\4\10\0\2\2\4\0\12\4\22\0"+
    "\2\4\1\0\22\2\3\0\30\2\1\0\11\2\1\0\1\2\2\0"+
    "\7\2\3\0\1\4\4\0\6\4\1\0\1\4\1\0\10\4\22\0"+
    "\2\4\15\0\60\2\1\4\2\2\7\4\4\0\10\2\10\4\1\0"+
    "\12\4\47\0\2\2\1\0\1\2\2\0\2\2\1\0\1\2\2\0"+
    "\1\2\6\0\4\2\1\0\7\2\1\0\3\2\1\0\1\2\1\0"+
    "\1\2\2\0\2\2\1\0\4\2\1\4\2\2\6\4\1\0\2\4"+
    "\1\2\2\0\5\2\1\0\1\2\1\0\6\4\2\0\12\4\2\0"+
    "\2\2\42\0\1\2\27\0\2\4\6\0\12\4\13\0\1\4\1\0"+
    "\1\4\1\0\1\4\4\0\2\4\10\2\1\0\42\2\6\0\24\4"+
    "\1\0\2\4\4\2\4\0\10\4\1\0\44\4\11\0\1\4\71\0"+
    "\42\2\1\0\5\2\1\0\2\2\1\0\7\4\3\0\4\4\6\0"+
    "\12\4\6\0\6\2\4\4\106\0\46\2\12\0\51\2\7\0\132\2"+
    "\5\0\104\2\5\0\122\2\6\0\7\2\1\0\77\2\1\0\1\2"+
    "\1\0\4\2\2\0\7\2\1\0\1\2\1\0\4\2\2\0\47\2"+
    "\1\0\1\2\1\0\4\2\2\0\37\2\1\0\1\2\1\0\4\2"+
    "\2\0\7\2\1\0\1\2\1\0\4\2\2\0\7\2\1\0\7\2"+
    "\1\0\27\2\1\0\37\2\1\0\1\2\1\0\4\2\2\0\7\2"+
    "\1\0\47\2\1\0\23\2\16\0\11\4\56\0\125\2\14\0\u026c\2"+
    "\2\0\10\2\12\0\32\2\5\0\113\2\3\0\3\2\17\0\15\2"+
    "\1\0\4\2\3\4\13\0\22\2\3\4\13\0\22\2\2\4\14\0"+
    "\15\2\1\0\3\2\1\0\2\4\14\0\64\2\40\4\3\0\1\2"+
    "\3\0\2\2\1\4\2\0\12\4\41\0\3\4\2\0\12\4\6\0"+
    "\130\2\10\0\51\2\1\4\126\0\35\2\3\0\14\4\4\0\14\4"+
    "\12\0\12\4\36\2\2\0\5\2\u038b\0\154\2\224\0\234\2\4\0"+
    "\132\2\6\0\26\2\2\0\6\2\2\0\46\2\2\0\6\2\2\0"+
    "\10\2\1\0\1\2\1\0\1\2\1\0\1\2\1\0\37\2\2\0"+
    "\65\2\1\0\7\2\1\0\1\2\3\0\3\2\1\0\7\2\3\0"+
    "\4\2\2\0\6\2\4\0\15\2\5\0\3\2\1\0\7\2\17\0"+
    "\4\4\32\0\5\4\20\0\2\2\23\0\1\2\13\0\4\4\6\0"+
    "\6\4\1\0\1\2\15\0\1\2\40\0\22\2\36\0\15\4\4\0"+
    "\1\4\3\0\6\4\27\0\1\2\4\0\1\2\2\0\12\2\1\0"+
    "\1\2\3\0\5\2\6\0\1\2\1\0\1\2\1\0\1\2\1\0"+
    "\4\2\1\0\3\2\1\0\7\2\3\0\3\2\5\0\5\2\26\0"+
    "\44\2\u0e81\0\3\2\31\0\11\2\6\4\1\0\5\2\2\0\5\2"+
    "\4\0\126\2\2\0\2\4\2\0\3\2\1\0\137\2\5\0\50\2"+
    "\4\0\136\2\21\0\30\2\70\0\20\2\u0200\0\u19b6\2\112\0\u51a6\2"+
    "\132\0\u048d\2\u0773\0\u2ba4\2\u215c\0\u012e\2\2\0\73\2\225\0\7\2"+
    "\14\0\5\2\5\0\1\2\1\4\12\2\1\0\15\2\1\0\5\2"+
    "\1\0\1\2\1\0\2\2\1\0\2\2\1\0\154\2\41\0\u016b\2"+
    "\22\0\100\2\2\0\66\2\50\0\15\2\3\0\20\4\20\0\4\4"+
    "\17\0\2\2\30\0\3\2\31\0\1\2\6\0\5\2\1\0\207\2"+
    "\2\0\1\4\4\0\1\2\13\0\12\4\7\0\32\2\4\0\1\2"+
    "\1\0\32\2\12\0\132\2\3\0\6\2\2\0\6\2\2\0\6\2"+
    "\2\0\3\2\3\0\2\2\3\0\2\2\22\0\3\4\4\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\3\0\1\1\1\2\2\1\1\2\4\1\1\3\1\1"+
    "\1\4\15\1\1\3\1\4\1\1\1\5\1\1\3\6"+
    "\1\1\3\2\1\0\1\1\1\7\4\2\12\1\1\10"+
    "\22\1\1\10\10\1\4\0\1\11\3\0\1\12\1\13"+
    "\1\14\1\2\1\0\1\2\37\1\1\7\11\1\1\15"+
    "\1\7\20\1\1\2\14\1\1\10\11\1\1\10\12\1"+
    "\1\16\25\1";

  private static int [] zzUnpackAction() {
    int [] result = new int[214];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\60\0\140\0\220\0\300\0\360\0\u0120\0\u0150"+
    "\0\u0180\0\u01b0\0\u01e0\0\u0210\0\u0240\0\u0270\0\220\0\u02a0"+
    "\0\u02d0\0\u0300\0\u0330\0\u0360\0\u0390\0\u03c0\0\u03f0\0\u0420"+
    "\0\u0450\0\u0480\0\u04b0\0\u04e0\0\220\0\u0510\0\u0540\0\220"+
    "\0\u0570\0\220\0\u05a0\0\u05d0\0\u0600\0\220\0\u0600\0\u0630"+
    "\0\u0660\0\u0690\0\u06c0\0\u06f0\0\u0720\0\u0750\0\u0780\0\u07b0"+
    "\0\u07e0\0\u0810\0\u0840\0\u0870\0\u08a0\0\u08d0\0\u0900\0\u0930"+
    "\0\u0960\0\u0990\0\u09c0\0\u09f0\0\u0a20\0\u0a50\0\u0a80\0\u0ab0"+
    "\0\u0ae0\0\u0b10\0\u0b40\0\u0b70\0\u0ba0\0\u0bd0\0\u0c00\0\u0c30"+
    "\0\u0c60\0\u0c90\0\u0cc0\0\u0cf0\0\360\0\u0d20\0\u0d50\0\u0d80"+
    "\0\u0db0\0\u0de0\0\u0e10\0\u0e40\0\u0e70\0\u04b0\0\u0ea0\0\u04e0"+
    "\0\u0ed0\0\u0f00\0\u0f30\0\u0540\0\u0570\0\220\0\220\0\u0f60"+
    "\0\u0f90\0\u0fc0\0\u0ff0\0\u1020\0\u1050\0\u1080\0\u10b0\0\u10e0"+
    "\0\u1110\0\u1140\0\u1170\0\u11a0\0\u11d0\0\u1200\0\u1230\0\u1260"+
    "\0\u1290\0\u12c0\0\u12f0\0\u1320\0\u1350\0\u1380\0\u13b0\0\u13e0"+
    "\0\u1410\0\u1440\0\u1470\0\u14a0\0\u14d0\0\u1500\0\u1530\0\u1560"+
    "\0\u1590\0\u15c0\0\u15f0\0\u1620\0\u1650\0\u1680\0\u16b0\0\u16e0"+
    "\0\u1710\0\u1740\0\u1770\0\u17a0\0\u17d0\0\360\0\u1800\0\u1830"+
    "\0\u1860\0\u1890\0\u18c0\0\u18f0\0\u1920\0\u1950\0\u1980\0\u19b0"+
    "\0\u19e0\0\u1a10\0\u1a40\0\u1a70\0\u1aa0\0\u1ad0\0\360\0\u1b00"+
    "\0\u1b30\0\u1b60\0\u1b90\0\u1bc0\0\u1bf0\0\u1c20\0\u1c50\0\u1c80"+
    "\0\u1cb0\0\u1ce0\0\u1d10\0\u1d40\0\u1d70\0\u1da0\0\u1dd0\0\u1e00"+
    "\0\u1e30\0\u1e60\0\u1e90\0\u1ec0\0\u1ef0\0\u1500\0\u1f20\0\u1f50"+
    "\0\u1f80\0\u1fb0\0\u1fe0\0\u2010\0\u2040\0\u2070\0\u20a0\0\u20d0"+
    "\0\360\0\u2100\0\u2130\0\u2160\0\u2190\0\u21c0\0\u21f0\0\u2220"+
    "\0\u2250\0\u2280\0\u22b0\0\u22e0\0\u2310\0\u2340\0\u2370\0\u23a0"+
    "\0\u23d0\0\u2400\0\u2430\0\u2460\0\u2490\0\u24c0";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[214];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\4\1\5\2\6\1\4\1\7\1\10\1\11\1\7"+
    "\1\6\1\7\1\12\1\7\1\5\1\13\1\7\1\14"+
    "\1\15\1\16\1\7\1\17\1\20\1\21\1\22\1\23"+
    "\1\24\3\6\1\25\1\26\3\6\1\27\1\30\1\31"+
    "\1\32\1\6\1\33\2\4\1\34\1\35\2\17\1\36"+
    "\1\4\50\37\1\40\4\37\1\41\2\37\55\42\1\43"+
    "\1\42\1\44\61\0\1\5\1\0\1\45\1\0\1\45"+
    "\1\5\1\46\1\47\1\0\1\45\1\0\1\45\1\5"+
    "\1\46\1\47\1\46\1\50\1\51\1\52\35\0\20\6"+
    "\1\0\2\6\1\0\22\6\12\0\1\7\1\53\1\7"+
    "\1\53\2\7\1\53\1\7\1\53\1\7\1\53\2\7"+
    "\1\53\1\7\1\53\1\0\1\53\1\7\1\0\22\53"+
    "\12\0\1\54\1\0\1\45\1\0\1\45\1\55\1\46"+
    "\1\47\1\56\1\57\1\0\1\45\1\55\1\46\1\47"+
    "\1\46\1\50\1\51\1\52\35\0\20\6\1\0\2\6"+
    "\1\0\7\6\1\60\12\6\12\0\6\6\1\61\11\6"+
    "\1\0\2\6\1\0\1\62\5\6\1\63\1\64\12\6"+
    "\12\0\6\6\1\65\11\6\1\0\2\6\1\0\1\66"+
    "\6\6\1\67\1\6\1\70\10\6\12\0\20\6\1\0"+
    "\1\71\1\6\1\0\7\6\1\72\12\6\12\0\1\50"+
    "\4\0\1\50\6\0\1\50\43\0\6\6\1\73\1\6"+
    "\1\74\7\6\1\0\2\6\1\0\22\6\12\0\20\6"+
    "\1\0\2\6\1\0\1\6\1\75\1\76\17\6\12\0"+
    "\20\6\1\0\2\6\1\0\4\6\1\77\2\6\1\100"+
    "\3\6\1\101\6\6\12\0\20\6\1\0\2\6\1\0"+
    "\3\6\1\102\2\6\1\103\3\6\1\104\1\105\3\6"+
    "\1\106\2\6\12\0\20\6\1\0\2\6\1\0\4\6"+
    "\1\107\1\6\1\110\13\6\12\0\20\6\1\0\1\111"+
    "\1\6\1\0\22\6\12\0\20\6\1\0\1\112\1\6"+
    "\1\0\1\113\11\6\1\114\7\6\12\0\15\6\1\115"+
    "\2\6\1\0\2\6\1\0\10\6\1\116\3\6\1\117"+
    "\5\6\12\0\20\6\1\0\2\6\1\0\1\120\3\6"+
    "\1\121\5\6\1\122\7\6\12\0\20\6\1\0\2\6"+
    "\1\0\7\6\1\123\12\6\12\0\20\6\1\0\2\6"+
    "\1\0\6\6\1\124\13\6\12\0\20\6\1\0\2\6"+
    "\1\0\7\6\1\125\12\6\11\0\47\126\2\46\1\127"+
    "\6\126\50\130\1\46\1\131\1\46\5\130\55\0\1\132"+
    "\1\133\1\0\50\134\1\40\4\134\1\135\52\134\1\40"+
    "\4\134\1\135\1\136\1\134\56\0\1\137\3\0\2\140"+
    "\1\0\1\140\1\0\6\140\1\0\3\140\1\0\2\140"+
    "\1\0\22\140\12\0\1\45\1\0\1\45\1\0\2\45"+
    "\1\0\1\45\1\0\1\45\1\0\2\45\1\0\1\45"+
    "\3\0\1\45\35\0\1\50\4\0\1\50\6\0\1\50"+
    "\3\46\1\0\2\51\35\0\1\141\4\0\1\141\6\0"+
    "\1\141\6\0\1\142\34\0\1\143\1\0\1\45\1\0"+
    "\1\45\1\143\1\0\1\45\1\0\1\45\1\0\1\45"+
    "\1\143\1\0\1\45\3\0\1\45\1\142\34\0\20\53"+
    "\1\0\2\53\1\0\22\53\12\0\1\54\1\0\1\45"+
    "\1\0\1\45\1\54\1\0\1\45\1\0\1\45\1\0"+
    "\1\45\1\54\1\46\1\47\1\46\1\50\1\51\1\52"+
    "\35\0\1\54\1\0\1\45\1\0\1\45\1\55\1\46"+
    "\1\47\1\0\1\45\1\0\1\45\1\55\1\46\1\47"+
    "\1\46\1\50\1\51\1\52\35\0\1\56\4\0\1\56"+
    "\2\46\2\0\6\56\1\0\2\56\1\0\2\56\32\0"+
    "\1\57\1\0\1\45\1\0\1\45\1\57\1\46\1\47"+
    "\1\0\1\45\1\56\2\57\1\56\1\57\1\56\1\0"+
    "\1\56\1\57\1\0\2\56\32\0\20\6\1\0\2\6"+
    "\1\0\10\6\1\144\11\6\12\0\20\6\1\0\2\6"+
    "\1\0\1\145\21\6\12\0\20\6\1\0\2\6\1\0"+
    "\2\6\1\146\1\147\16\6\12\0\20\6\1\0\2\6"+
    "\1\0\1\150\21\6\12\0\20\6\1\0\2\6\1\0"+
    "\10\6\1\151\11\6\12\0\20\6\1\0\2\6\1\0"+
    "\7\6\1\152\12\6\12\0\6\6\1\153\11\6\1\0"+
    "\2\6\1\0\22\6\12\0\20\6\1\0\2\6\1\0"+
    "\4\6\1\115\15\6\12\0\20\6\1\0\2\6\1\0"+
    "\10\6\1\154\11\6\12\0\15\6\1\155\2\6\1\0"+
    "\2\6\1\0\22\6\12\0\20\6\1\0\2\6\1\0"+
    "\12\6\1\156\7\6\12\0\20\6\1\0\2\6\1\0"+
    "\2\6\1\146\17\6\12\0\20\6\1\0\2\6\1\0"+
    "\3\6\1\157\16\6\12\0\20\6\1\0\2\6\1\0"+
    "\2\6\1\160\17\6\12\0\20\6\1\0\2\6\1\0"+
    "\2\6\1\161\17\6\12\0\20\6\1\0\1\162\1\6"+
    "\1\0\22\6\12\0\20\6\1\0\2\6\1\0\7\6"+
    "\1\163\12\6\12\0\20\6\1\0\2\6\1\0\3\6"+
    "\1\164\16\6\12\0\20\6\1\0\2\6\1\0\1\165"+
    "\3\6\1\166\15\6\12\0\20\6\1\0\2\6\1\0"+
    "\7\6\1\167\12\6\12\0\20\6\1\0\2\6\1\0"+
    "\15\6\1\170\4\6\12\0\20\6\1\0\2\6\1\0"+
    "\10\6\1\171\11\6\12\0\20\6\1\0\2\6\1\0"+
    "\11\6\1\172\10\6\12\0\20\6\1\0\2\6\1\0"+
    "\1\173\11\6\1\174\1\115\6\6\12\0\20\6\1\0"+
    "\2\6\1\0\4\6\1\175\4\6\1\176\10\6\12\0"+
    "\20\6\1\0\2\6\1\0\3\6\1\177\16\6\12\0"+
    "\20\6\1\0\2\6\1\0\17\6\1\115\2\6\12\0"+
    "\20\6\1\0\2\6\1\0\3\6\1\200\16\6\12\0"+
    "\6\6\1\201\11\6\1\0\2\6\1\0\22\6\12\0"+
    "\20\6\1\0\2\6\1\0\2\6\1\202\1\203\16\6"+
    "\12\0\20\6\1\0\2\6\1\0\15\6\1\204\4\6"+
    "\12\0\12\6\1\205\5\6\1\0\2\6\1\0\22\6"+
    "\12\0\20\6\1\0\2\6\1\0\7\6\1\206\1\6"+
    "\1\207\10\6\12\0\20\6\1\0\2\6\1\0\1\6"+
    "\1\210\20\6\12\0\6\6\1\211\11\6\1\0\2\6"+
    "\1\0\11\6\1\212\10\6\12\0\20\6\1\0\2\6"+
    "\1\0\11\6\1\213\10\6\12\0\20\6\1\0\2\6"+
    "\1\0\3\6\1\214\16\6\11\0\50\126\1\46\7\126"+
    "\50\130\1\46\7\130\55\0\1\215\2\0\50\133\1\40"+
    "\7\133\1\0\20\140\1\0\2\140\1\0\22\140\12\0"+
    "\1\141\4\0\1\141\6\0\1\141\3\46\40\0\1\141"+
    "\4\0\1\141\6\0\1\141\43\0\1\143\1\0\1\45"+
    "\1\0\1\45\1\143\1\0\1\45\1\0\1\45\1\0"+
    "\1\45\1\143\1\46\1\47\1\46\2\0\1\45\35\0"+
    "\20\6\1\0\2\6\1\0\20\6\1\216\1\6\12\0"+
    "\20\6\1\0\2\6\1\0\2\6\1\176\17\6\12\0"+
    "\20\6\1\0\1\115\1\6\1\0\22\6\12\0\12\6"+
    "\1\217\5\6\1\0\2\6\1\0\22\6\12\0\20\6"+
    "\1\0\2\6\1\0\4\6\1\216\15\6\12\0\20\6"+
    "\1\0\2\6\1\0\2\6\1\220\1\221\16\6\12\0"+
    "\20\6\1\0\2\6\1\0\1\222\21\6\12\0\20\6"+
    "\1\0\2\6\1\0\2\6\1\174\17\6\12\0\20\6"+
    "\1\0\2\6\1\0\1\223\21\6\12\0\20\6\1\0"+
    "\2\6\1\0\1\224\21\6\12\0\20\6\1\0\2\6"+
    "\1\0\1\6\1\225\20\6\12\0\20\6\1\0\1\226"+
    "\1\6\1\0\22\6\12\0\20\6\1\0\2\6\1\0"+
    "\3\6\1\227\16\6\12\0\20\6\1\0\1\230\1\6"+
    "\1\0\22\6\12\0\20\6\1\0\2\6\1\0\1\231"+
    "\21\6\12\0\6\6\1\232\11\6\1\0\2\6\1\0"+
    "\22\6\12\0\20\6\1\0\1\216\1\6\1\0\22\6"+
    "\12\0\20\6\1\0\2\6\1\0\3\6\1\233\16\6"+
    "\12\0\20\6\1\0\2\6\1\0\11\6\1\234\10\6"+
    "\12\0\20\6\1\0\2\6\1\0\4\6\1\222\15\6"+
    "\12\0\20\6\1\0\1\67\1\6\1\0\22\6\12\0"+
    "\12\6\1\235\5\6\1\0\2\6\1\0\22\6\12\0"+
    "\20\6\1\0\2\6\1\0\3\6\1\147\16\6\12\0"+
    "\20\6\1\0\2\6\1\0\10\6\1\236\11\6\12\0"+
    "\20\6\1\0\1\237\1\6\1\0\22\6\12\0\20\6"+
    "\1\0\2\6\1\0\7\6\1\240\12\6\12\0\20\6"+
    "\1\0\2\6\1\0\2\6\1\115\17\6\12\0\20\6"+
    "\1\0\2\6\1\0\12\6\1\241\7\6\12\0\20\6"+
    "\1\0\2\6\1\0\11\6\1\242\10\6\12\0\6\6"+
    "\1\237\11\6\1\0\2\6\1\0\22\6\12\0\20\6"+
    "\1\0\2\6\1\0\3\6\1\243\16\6\12\0\20\6"+
    "\1\0\1\244\1\6\1\0\22\6\12\0\6\6\1\245"+
    "\11\6\1\0\2\6\1\0\7\6\1\246\12\6\12\0"+
    "\20\6\1\0\2\6\1\0\5\6\1\247\14\6\12\0"+
    "\20\6\1\0\2\6\1\0\3\6\1\250\16\6\12\0"+
    "\20\6\1\0\2\6\1\0\16\6\1\251\3\6\12\0"+
    "\6\6\1\233\11\6\1\0\2\6\1\0\22\6\12\0"+
    "\20\6\1\0\2\6\1\0\1\252\21\6\12\0\17\6"+
    "\1\216\1\0\2\6\1\0\22\6\12\0\6\6\1\146"+
    "\11\6\1\0\2\6\1\0\22\6\12\0\20\6\1\0"+
    "\2\6\1\0\7\6\1\115\12\6\67\0\1\40\2\0"+
    "\20\6\1\0\2\6\1\0\6\6\1\115\13\6\12\0"+
    "\20\6\1\0\2\6\1\0\3\6\1\115\16\6\12\0"+
    "\20\6\1\0\2\6\1\0\11\6\1\253\10\6\12\0"+
    "\20\6\1\0\2\6\1\0\3\6\1\216\16\6\12\0"+
    "\6\6\1\254\11\6\1\0\2\6\1\0\22\6\12\0"+
    "\20\6\1\0\2\6\1\0\12\6\1\255\7\6\12\0"+
    "\6\6\1\164\11\6\1\0\2\6\1\0\22\6\12\0"+
    "\20\6\1\0\2\6\1\0\10\6\1\256\11\6\12\0"+
    "\20\6\1\0\2\6\1\0\4\6\1\257\15\6\12\0"+
    "\20\6\1\0\2\6\1\0\4\6\1\260\15\6\12\0"+
    "\20\6\1\0\2\6\1\0\5\6\1\115\14\6\12\0"+
    "\20\6\1\0\1\261\1\6\1\0\22\6\12\0\20\6"+
    "\1\0\2\6\1\0\11\6\1\262\10\6\12\0\12\6"+
    "\1\263\5\6\1\0\2\6\1\0\22\6\12\0\20\6"+
    "\1\0\2\6\1\0\6\6\1\264\13\6\12\0\20\6"+
    "\1\0\2\6\1\0\2\6\1\265\17\6\12\0\20\6"+
    "\1\0\2\6\1\0\17\6\1\266\2\6\12\0\20\6"+
    "\1\0\2\6\1\0\4\6\1\267\15\6\12\0\20\6"+
    "\1\0\2\6\1\0\16\6\1\146\3\6\12\0\20\6"+
    "\1\0\2\6\1\0\1\270\21\6\12\0\20\6\1\0"+
    "\2\6\1\0\4\6\1\271\15\6\12\0\20\6\1\0"+
    "\1\272\1\6\1\0\22\6\12\0\20\6\1\0\2\6"+
    "\1\0\4\6\1\220\15\6\12\0\20\6\1\0\2\6"+
    "\1\0\1\273\21\6\12\0\20\6\1\0\1\274\1\6"+
    "\1\0\22\6\12\0\20\6\1\0\2\6\1\0\1\275"+
    "\21\6\12\0\20\6\1\0\2\6\1\0\3\6\1\124"+
    "\16\6\12\0\20\6\1\0\2\6\1\0\10\6\1\276"+
    "\11\6\12\0\6\6\1\277\11\6\1\0\2\6\1\0"+
    "\22\6\12\0\6\6\1\220\11\6\1\0\2\6\1\0"+
    "\22\6\12\0\17\6\1\176\1\0\2\6\1\0\22\6"+
    "\12\0\20\6\1\0\2\6\1\0\1\300\21\6\12\0"+
    "\20\6\1\0\2\6\1\0\3\6\1\301\16\6\12\0"+
    "\20\6\1\0\2\6\1\0\1\302\21\6\12\0\12\6"+
    "\1\115\5\6\1\0\2\6\1\0\22\6\12\0\20\6"+
    "\1\0\2\6\1\0\3\6\1\303\16\6\12\0\20\6"+
    "\1\0\2\6\1\0\4\6\1\304\15\6\12\0\20\6"+
    "\1\0\2\6\1\0\11\6\1\305\10\6\12\0\20\6"+
    "\1\0\2\6\1\0\10\6\1\115\11\6\12\0\20\6"+
    "\1\0\2\6\1\0\10\6\1\306\11\6\12\0\15\6"+
    "\1\307\2\6\1\0\2\6\1\0\22\6\12\0\20\6"+
    "\1\0\2\6\1\0\14\6\1\310\5\6\12\0\20\6"+
    "\1\0\2\6\1\0\20\6\1\146\1\6\12\0\12\6"+
    "\1\311\5\6\1\0\2\6\1\0\22\6\12\0\20\6"+
    "\1\0\2\6\1\0\3\6\1\146\16\6\12\0\20\6"+
    "\1\0\2\6\1\0\12\6\1\146\7\6\12\0\20\6"+
    "\1\0\2\6\1\0\13\6\1\115\6\6\12\0\12\6"+
    "\1\220\5\6\1\0\2\6\1\0\22\6\12\0\20\6"+
    "\1\0\2\6\1\0\10\6\1\216\11\6\12\0\15\6"+
    "\1\312\2\6\1\0\2\6\1\0\22\6\12\0\20\6"+
    "\1\0\2\6\1\0\7\6\1\313\12\6\12\0\20\6"+
    "\1\0\1\314\1\6\1\0\22\6\12\0\12\6\1\315"+
    "\5\6\1\0\2\6\1\0\22\6\12\0\20\6\1\0"+
    "\2\6\1\0\1\316\21\6\12\0\20\6\1\0\1\317"+
    "\1\6\1\0\22\6\12\0\20\6\1\0\2\6\1\0"+
    "\3\6\1\320\16\6\12\0\20\6\1\0\2\6\1\0"+
    "\15\6\1\115\4\6\12\0\20\6\1\0\2\6\1\0"+
    "\10\6\1\321\11\6\12\0\20\6\1\0\2\6\1\0"+
    "\10\6\1\220\11\6\12\0\20\6\1\0\1\322\1\6"+
    "\1\0\22\6\12\0\12\6\1\146\5\6\1\0\2\6"+
    "\1\0\22\6\12\0\20\6\1\0\2\6\1\0\10\6"+
    "\1\323\11\6\12\0\20\6\1\0\1\324\1\6\1\0"+
    "\22\6\12\0\20\6\1\0\2\6\1\0\11\6\1\325"+
    "\10\6\12\0\20\6\1\0\2\6\1\0\7\6\1\326"+
    "\12\6\12\0\20\6\1\0\2\6\1\0\3\6\1\176"+
    "\16\6\12\0\17\6\1\115\1\0\2\6\1\0\22\6"+
    "\12\0\20\6\1\0\2\6\1\0\21\6\1\320\12\0"+
    "\15\6\1\115\2\6\1\0\2\6\1\0\22\6\11\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[9456];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\3\0\1\11\12\1\1\11\15\1\1\11\2\1\1\11"+
    "\1\1\1\11\3\1\1\11\2\1\1\0\54\1\4\0"+
    "\1\1\3\0\2\11\2\1\1\0\164\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[214];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the textposition at the last state to be included in yytext */
  private int zzPushbackPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */
	public static boolean ASSERT_IS_KEYWORD = false;

	/* styles */
	
	public static final byte PLAIN_STYLE = 1;
	public static final byte KEYWORD_STYLE = 2;
	public static final byte TYPE_STYLE = 3;
	public static final byte OPERATOR_STYLE = 4;
	public static final byte SEPARATOR_STYLE = 5;
	public static final byte LITERAL_STYLE = 6;
	public static final byte JAVA_COMMENT_STYLE = 7;
	public static final byte JAVADOC_COMMENT_STYLE = 8;
	public static final byte JAVADOC_TAG_STYLE = 9;
	
	/* Highlighter implementation */
	
	public int getStyleCount()
	{
		return 9;
	}
	
	public byte getStartState()
	{
		return YYINITIAL+1;
	}
	
	public byte getCurrentState()
	{
		return (byte) (yystate()+1);
	}
	
	public void setState(byte newState)
	{
		yybegin(newState-1);
	}
	
	public byte getNextToken()
	throws IOException
	{
		return (byte) yylex();
	}
	
	public int getTokenLength()
	{
		return yylength();
	}
	
	public void setReader(Reader r)
	{
		this.zzReader = r;
	}

	public JavaHighlighter()
	{
	}


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public JavaHighlighter(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public JavaHighlighter(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 1778) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzPushbackPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead < 0) {
      return true;
    }
    else {
      zzEndRead+= numRead;
      return false;
    }
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = zzPushbackPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public int yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = zzLexicalState;


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 14: 
          { return ASSERT_IS_KEYWORD ? KEYWORD_STYLE : PLAIN_STYLE;
          }
        case 15: break;
        case 5: 
          { return JAVA_COMMENT_STYLE;
          }
        case 16: break;
        case 1: 
          { return PLAIN_STYLE;
          }
        case 17: break;
        case 8: 
          { return KEYWORD_STYLE;
          }
        case 18: break;
        case 4: 
          { return OPERATOR_STYLE;
          }
        case 19: break;
        case 2: 
          { return LITERAL_STYLE;
          }
        case 20: break;
        case 11: 
          { yybegin(YYINITIAL); return JAVADOC_COMMENT_STYLE;
          }
        case 21: break;
        case 10: 
          { yybegin(YYINITIAL); return JAVA_COMMENT_STYLE;
          }
        case 22: break;
        case 3: 
          { return SEPARATOR_STYLE;
          }
        case 23: break;
        case 7: 
          { return TYPE_STYLE;
          }
        case 24: break;
        case 9: 
          { yybegin(IN_COMMENT);  return JAVA_COMMENT_STYLE;
          }
        case 25: break;
        case 13: 
          { yybegin(IN_JAVA_DOC_COMMENT); return JAVADOC_COMMENT_STYLE;
          }
        case 26: break;
        case 12: 
          { return JAVADOC_TAG_STYLE;
          }
        case 27: break;
        case 6: 
          { return JAVADOC_COMMENT_STYLE;
          }
        case 28: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            return YYEOF;
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
