/*
 * Decompiled with CFR 0.152.
 */
package org.codenarc.util;

import groovy.lang.Closure;
import groovy.lang.MetaClass;
import groovy.lang.Range;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codenarc.source.SourceCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AstUtil {
    private static final Logger LOG = LoggerFactory.getLogger(AstUtil.class);
    private static final char NEWLINE = '\n';
    public static final List<String> AUTO_IMPORTED_PACKAGES = Arrays.asList("java.lang", "java.io", "java.net", "java.util", "groovy.lang", "groovy.util");
    public static final List<String> AUTO_IMPORTED_CLASSES = Arrays.asList("java.math.BigDecimal", "java.math.BigInteger");
    public static final List<String> COMPARISON_OPERATORS = Arrays.asList("==", "!=", "<", "<=", ">", ">=", "<=>");
    private static final Map<String, List<String>> PREDEFINED_CONSTANTS = new HashMap<String, List<String>>();

    private AstUtil() {
    }

    public static boolean isConstantOrLiteral(Expression expression) {
        if (expression instanceof ConstantExpression) {
            return true;
        }
        if (expression instanceof ListExpression) {
            return true;
        }
        if (expression instanceof MapExpression) {
            return true;
        }
        return AstUtil.isPredefinedConstant(expression);
    }

    private static boolean isPredefinedConstant(Expression expression) {
        if (expression instanceof PropertyExpression) {
            List<String> predefinedConstantNames;
            Expression object = ((PropertyExpression)expression).getObjectExpression();
            Expression property = ((PropertyExpression)expression).getProperty();
            if (object instanceof VariableExpression && (predefinedConstantNames = PREDEFINED_CONSTANTS.get(((VariableExpression)object).getName())) != null && predefinedConstantNames.contains(property.getText())) {
                return true;
            }
        }
        return false;
    }

    public static boolean isConstantOrConstantLiteral(Expression expression) {
        return expression instanceof ConstantExpression || AstUtil.isPredefinedConstant(expression) || AstUtil.isMapLiteralWithOnlyConstantValues(expression) || AstUtil.isListLiteralWithOnlyConstantValues(expression);
    }

    public static boolean isMapLiteralWithOnlyConstantValues(Expression expression) {
        if (expression instanceof MapExpression) {
            List entries = ((MapExpression)expression).getMapEntryExpressions();
            for (MapEntryExpression entry : entries) {
                if (AstUtil.isConstantOrConstantLiteral(entry.getKeyExpression()) && AstUtil.isConstantOrConstantLiteral(entry.getValueExpression())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isListLiteralWithOnlyConstantValues(Expression expression) {
        if (expression instanceof ListExpression) {
            List expressions = ((ListExpression)expression).getExpressions();
            for (Expression e : expressions) {
                if (AstUtil.isConstantOrConstantLiteral(e)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isConstant(Expression expression, Object expected) {
        return expression instanceof ConstantExpression && expected.equals(((ConstantExpression)expression).getValue());
    }

    public static boolean isPropertyNamed(Expression property, Object expectedName) {
        return property instanceof PropertyExpression && AstUtil.isConstant(((PropertyExpression)property).getProperty(), expectedName);
    }

    public static boolean isBlock(Statement statement) {
        return statement instanceof BlockStatement;
    }

    public static boolean isEmptyBlock(Statement origStatement) {
        Stack<Object> stack = new Stack<Object>();
        stack.push(origStatement);
        while (!stack.isEmpty()) {
            ASTNode statement = (ASTNode)stack.pop();
            if (!(statement instanceof BlockStatement)) {
                return false;
            }
            if (((BlockStatement)statement).isEmpty()) {
                return true;
            }
            if (((BlockStatement)statement).getStatements().size() != 1) {
                return false;
            }
            stack.push(((BlockStatement)statement).getStatements().get(0));
        }
        return false;
    }

    public static ASTNode getEmptyBlock(Statement origStatement) {
        Stack<Object> stack = new Stack<Object>();
        stack.push(origStatement);
        while (!stack.isEmpty()) {
            ASTNode statement = (ASTNode)stack.pop();
            if (!(statement instanceof BlockStatement)) {
                return null;
            }
            if (((BlockStatement)statement).isEmpty()) {
                return statement;
            }
            if (((BlockStatement)statement).getStatements().size() != 1) {
                return null;
            }
            stack.push(((BlockStatement)statement).getStatements().get(0));
        }
        return null;
    }

    public static List<? extends Expression> getMethodArguments(ASTNode methodCall) {
        if (methodCall instanceof ConstructorCallExpression) {
            return AstUtil.extractExpressions(((ConstructorCallExpression)methodCall).getArguments());
        }
        if (methodCall instanceof MethodCallExpression) {
            return AstUtil.extractExpressions(((MethodCallExpression)methodCall).getArguments());
        }
        if (methodCall instanceof StaticMethodCallExpression) {
            return AstUtil.extractExpressions(((StaticMethodCallExpression)methodCall).getArguments());
        }
        if (AstUtil.respondsTo(methodCall, "getArguments")) {
            throw new RuntimeException();
        }
        return new ArrayList();
    }

    private static List<? extends Expression> extractExpressions(Expression argumentsExpression) {
        if (argumentsExpression instanceof ArrayExpression) {
            return ((ArrayExpression)argumentsExpression).getExpressions();
        }
        if (argumentsExpression instanceof ListExpression) {
            return ((ListExpression)argumentsExpression).getExpressions();
        }
        if (argumentsExpression instanceof TupleExpression) {
            return ((TupleExpression)argumentsExpression).getExpressions();
        }
        if (argumentsExpression instanceof MapExpression) {
            return ((MapExpression)argumentsExpression).getMapEntryExpressions();
        }
        if (AstUtil.respondsTo(argumentsExpression, "getExpressions")) {
            throw new RuntimeException();
        }
        if (AstUtil.respondsTo(argumentsExpression, "getMapEntryExpressions")) {
            throw new RuntimeException();
        }
        return new ArrayList();
    }

    public static boolean isMethodCallOnObject(Expression expression, String methodObjectPattern) {
        if (expression instanceof MethodCallExpression) {
            String name;
            Expression objectExpression = ((MethodCallExpression)expression).getObjectExpression();
            if (objectExpression instanceof VariableExpression && (name = ((VariableExpression)objectExpression).getName()) != null && name.matches(methodObjectPattern)) {
                return true;
            }
            if (objectExpression instanceof PropertyExpression && objectExpression.getText() != null && objectExpression.getText().matches(methodObjectPattern)) {
                return true;
            }
            if (objectExpression instanceof MethodCallExpression && AstUtil.isMethodNamed((MethodCallExpression)objectExpression, methodObjectPattern)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isMethodCall(Statement stmt, String methodObject, String methodName, int numArguments) {
        Expression expression;
        if (stmt instanceof ExpressionStatement && (expression = ((ExpressionStatement)stmt).getExpression()) instanceof MethodCallExpression) {
            return AstUtil.isMethodCall(expression, methodObject, methodName, numArguments);
        }
        return false;
    }

    public static boolean isMethodCall(MethodCallExpression methodCall, String methodObjectPattern, String methodPattern, int numArguments) {
        return AstUtil.isMethodCall((Expression)methodCall, methodObjectPattern, methodPattern) && AstUtil.getMethodArguments((ASTNode)methodCall).size() == numArguments;
    }

    public static boolean isMethodCall(Expression expression, String methodObject, String methodName, int numArguments) {
        return expression instanceof MethodCallExpression && AstUtil.isMethodCall((MethodCallExpression)expression, methodObject, methodName, numArguments);
    }

    public static boolean isMethodCall(Expression expression, String methodObjectPattern, String methodNamePattern) {
        return AstUtil.isMethodCallOnObject(expression, methodObjectPattern) && AstUtil.isMethodNamed((MethodCallExpression)expression, methodNamePattern);
    }

    public static boolean isMethodCall(MethodCallExpression methodCall, List<String> methodObjects, List<String> methodNames, Integer numArguments) {
        if (methodNames != null) {
            for (String name : methodNames) {
                if (methodObjects == null) continue;
                for (String objectName : methodObjects) {
                    boolean match;
                    boolean bl = match = AstUtil.isMethodCallOnObject((Expression)methodCall, objectName) && AstUtil.isMethodNamed(methodCall, name);
                    if (match && numArguments == null) {
                        return true;
                    }
                    if (!match || AstUtil.getMethodArguments((ASTNode)methodCall).size() != numArguments.intValue()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isMethodCall(MethodCallExpression methodCall, List<String> methodObjects, List<String> methodNames) {
        return AstUtil.isMethodCall(methodCall, methodObjects, methodNames, null);
    }

    public static boolean isMethodCall(Expression expression, String methodName, int numArguments) {
        return expression instanceof MethodCallExpression && AstUtil.isMethodNamed((MethodCallExpression)expression, methodName) && AstUtil.getMethodArguments((ASTNode)expression).size() == numArguments;
    }

    public static boolean isMethodCall(Expression expression, String methodName, Range numArguments) {
        int arity;
        return expression instanceof MethodCallExpression && AstUtil.isMethodNamed((MethodCallExpression)expression, methodName) && (arity = AstUtil.getMethodArguments((ASTNode)expression).size()) >= (Integer)numArguments.getFrom() && arity <= (Integer)numArguments.getTo();
    }

    public static boolean isMethodNamed(MethodCallExpression methodCall, String methodNamePattern, Integer numArguments) {
        Expression method = methodCall.getMethod();
        boolean IS_NAME_MATCH = false;
        if (method instanceof ConstantExpression && ((ConstantExpression)method).getValue() instanceof String) {
            IS_NAME_MATCH = ((String)((ConstantExpression)method).getValue()).matches(methodNamePattern);
        }
        if (IS_NAME_MATCH && numArguments != null) {
            return AstUtil.getMethodArguments((ASTNode)methodCall).size() == numArguments.intValue();
        }
        return IS_NAME_MATCH;
    }

    public static boolean isMethodNamed(MethodCallExpression methodCall, String methodNamePattern) {
        return AstUtil.isMethodNamed(methodCall, methodNamePattern, null);
    }

    public static boolean isConstructorCall(Expression expression, List<String> classNames) {
        return expression instanceof ConstructorCallExpression && classNames.contains(expression.getType().getName());
    }

    public static boolean isConstructorCall(Expression expression, String classNamePattern) {
        return expression instanceof ConstructorCallExpression && expression.getType().getName().matches(classNamePattern);
    }

    public static AnnotationNode getAnnotation(AnnotatedNode node, String name) {
        return node.getAnnotations().stream().filter(a -> a.getClassNode().getName().equals(name)).findFirst().orElse(null);
    }

    public static boolean hasAnnotation(AnnotatedNode node, String name) {
        return AstUtil.getAnnotation(node, name) != null;
    }

    public static boolean hasAnyAnnotation(AnnotatedNode node, String ... names) {
        for (String name : names) {
            if (!AstUtil.hasAnnotation(node, name)) continue;
            return true;
        }
        return false;
    }

    public static List<Expression> getVariableExpressions(DeclarationExpression declarationExpression) {
        Expression leftExpression = declarationExpression.getLeftExpression();
        if (leftExpression instanceof ArrayExpression) {
            List<Expression> expressions = ((ArrayExpression)leftExpression).getExpressions();
            return expressions.isEmpty() ? Arrays.asList(leftExpression) : expressions;
        }
        if (leftExpression instanceof ListExpression) {
            List<Expression> expressions = ((ListExpression)leftExpression).getExpressions();
            return expressions.isEmpty() ? Arrays.asList(leftExpression) : expressions;
        }
        if (leftExpression instanceof TupleExpression) {
            List<Expression> expressions = ((TupleExpression)leftExpression).getExpressions();
            return expressions.isEmpty() ? Arrays.asList(leftExpression) : expressions;
        }
        if (leftExpression instanceof VariableExpression) {
            return Arrays.asList(leftExpression);
        }
        return Collections.emptyList();
    }

    public static boolean isFinalVariable(DeclarationExpression declarationExpression, SourceCode sourceCode) {
        if (AstUtil.isFromGeneratedSourceCode((ASTNode)declarationExpression)) {
            return false;
        }
        List<Expression> variableExpressions = AstUtil.getVariableExpressions(declarationExpression);
        if (!variableExpressions.isEmpty()) {
            Expression variableExpression = variableExpressions.get(0);
            int startOfDeclaration = declarationExpression.getColumnNumber();
            int startOfVariableName = variableExpression.getColumnNumber();
            int sourceLineNumber = AstUtil.findFirstNonAnnotationLine((ASTNode)declarationExpression, sourceCode);
            String sourceLine = sourceCode.getLines().get(sourceLineNumber - 1);
            String modifiers = startOfDeclaration >= 0 && startOfVariableName >= 0 && sourceLine.length() >= startOfVariableName ? sourceLine.substring(startOfDeclaration - 1, startOfVariableName - 1) : "";
            return modifiers.contains("final");
        }
        return false;
    }

    public static boolean isFromGeneratedSourceCode(ASTNode node) {
        return node.getLineNumber() < 0 || node instanceof ClassNode && ((ClassNode)node).isScript();
    }

    public static boolean isTrue(Expression expression) {
        if (expression == null) {
            return false;
        }
        if (expression instanceof PropertyExpression && AstUtil.classNodeImplementsType(((PropertyExpression)expression).getObjectExpression().getType(), Boolean.class) && ((PropertyExpression)expression).getProperty() instanceof ConstantExpression && "TRUE".equals(((ConstantExpression)((PropertyExpression)expression).getProperty()).getValue())) {
            return true;
        }
        return expression instanceof ConstantExpression && ((ConstantExpression)expression).isTrueExpression() || "Boolean.TRUE".equals(expression.getText());
    }

    public static boolean isBoolean(Expression expression) {
        return AstUtil.isTrue(expression) || AstUtil.isFalse(expression);
    }

    public static boolean isNull(ASTNode expression) {
        return expression instanceof ConstantExpression && ((ConstantExpression)expression).isNullExpression();
    }

    public static boolean isFalse(Expression expression) {
        if (expression == null) {
            return false;
        }
        if (expression instanceof PropertyExpression && AstUtil.classNodeImplementsType(((PropertyExpression)expression).getObjectExpression().getType(), Boolean.class) && ((PropertyExpression)expression).getProperty() instanceof ConstantExpression && "FALSE".equals(((ConstantExpression)((PropertyExpression)expression).getProperty()).getValue())) {
            return true;
        }
        return expression instanceof ConstantExpression && ((ConstantExpression)expression).isFalseExpression() || "Boolean.FALSE".equals(expression.getText());
    }

    public static boolean respondsTo(Object object, String methodName) {
        MetaClass metaClass = DefaultGroovyMethods.getMetaClass((Object)object);
        if (!metaClass.respondsTo(object, methodName).isEmpty()) {
            return true;
        }
        Map properties = DefaultGroovyMethods.getProperties((Object)object);
        return properties.containsKey(methodName);
    }

    public static boolean classNodeImplementsType(ClassNode node, Class target) {
        ClassNode targetNode = ClassHelper.make((Class)target);
        if (node.implementsInterface(targetNode)) {
            return true;
        }
        if (node.isDerivedFrom(targetNode)) {
            return true;
        }
        if (node.getName().equals(target.getName())) {
            return true;
        }
        if (node.getName().equals(target.getSimpleName())) {
            return true;
        }
        if (node.getSuperClass() != null && node.getSuperClass().getName().equals(target.getName())) {
            return true;
        }
        if (node.getSuperClass() != null && node.getSuperClass().getName().equals(target.getSimpleName())) {
            return true;
        }
        if (node.getInterfaces() != null) {
            for (ClassNode declaredInterface : node.getInterfaces()) {
                if (!AstUtil.classNodeImplementsType(declaredInterface, target)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isClosureDeclaration(ASTNode expression) {
        if (expression instanceof DeclarationExpression && ((DeclarationExpression)expression).getRightExpression() instanceof ClosureExpression) {
            return true;
        }
        if (expression instanceof FieldNode) {
            ClassNode type = ((FieldNode)expression).getType();
            if (AstUtil.classNodeImplementsType(type, Closure.class)) {
                return true;
            }
            if (((FieldNode)expression).getInitialValueExpression() instanceof ClosureExpression) {
                return true;
            }
        }
        return false;
    }

    public static List<String> getParameterNames(MethodNode node) {
        ArrayList<String> result = new ArrayList<String>();
        if (node.getParameters() != null) {
            for (Parameter parameter : node.getParameters()) {
                result.add(parameter.getName());
            }
        }
        return result;
    }

    public static List<String> getArgumentNames(MethodCallExpression methodCall) {
        ArrayList<String> result = new ArrayList<String>();
        Expression arguments = methodCall.getArguments();
        List argExpressions = null;
        if (arguments instanceof ArrayExpression) {
            argExpressions = ((ArrayExpression)arguments).getExpressions();
        } else if (arguments instanceof ListExpression) {
            argExpressions = ((ListExpression)arguments).getExpressions();
        } else if (arguments instanceof TupleExpression) {
            argExpressions = ((TupleExpression)arguments).getExpressions();
        } else {
            LOG.warn("getArgumentNames arguments is not an expected type");
        }
        if (argExpressions != null) {
            for (Expression exp : argExpressions) {
                if (!(exp instanceof VariableExpression)) continue;
                result.add(((VariableExpression)exp).getName());
            }
        }
        return result;
    }

    public static boolean isBinaryExpressionType(Expression expression, String token) {
        return expression instanceof BinaryExpression && token.equals(((BinaryExpression)expression).getOperation().getText());
    }

    public static boolean isBinaryExpressionType(Expression expression, List<String> tokens) {
        return expression instanceof BinaryExpression && tokens.contains(((BinaryExpression)expression).getOperation().getText());
    }

    public static boolean isSafe(Expression expression) {
        if (expression instanceof MethodCallExpression) {
            return ((MethodCallExpression)expression).isSafe();
        }
        if (expression instanceof PropertyExpression) {
            return ((PropertyExpression)expression).isSafe();
        }
        return false;
    }

    public static boolean isSpreadSafe(Expression expression) {
        if (expression instanceof MethodCallExpression) {
            return ((MethodCallExpression)expression).isSpreadSafe();
        }
        if (expression instanceof PropertyExpression) {
            return ((PropertyExpression)expression).isSpreadSafe();
        }
        return false;
    }

    public static boolean isMethodNode(ASTNode node, String methodNamePattern, Integer numArguments, Class returnType) {
        if (!(node instanceof MethodNode)) {
            return false;
        }
        if (!((MethodNode)node).getName().matches(methodNamePattern)) {
            return false;
        }
        if (numArguments != null && ((MethodNode)node).getParameters() != null && ((MethodNode)node).getParameters().length != numArguments) {
            return false;
        }
        return returnType == null || AstUtil.classNodeImplementsType(((MethodNode)node).getReturnType(), returnType);
    }

    public static boolean isMethodNode(ASTNode node, String methodNamePattern, Integer numArguments) {
        return AstUtil.isMethodNode(node, methodNamePattern, numArguments, null);
    }

    public static boolean isMethodNode(ASTNode node, String methodNamePattern) {
        return AstUtil.isMethodNode(node, methodNamePattern, null, null);
    }

    public static boolean isVariable(ASTNode expression, String pattern) {
        return expression instanceof VariableExpression && ((VariableExpression)expression).getName().matches(pattern);
    }

    public static boolean isPublic(ASTNode node) {
        Integer modifiers = null;
        if (node instanceof ClassNode) {
            modifiers = ((ClassNode)node).getModifiers();
        } else if (node instanceof FieldNode) {
            modifiers = ((FieldNode)node).getModifiers();
        } else if (node instanceof MethodNode) {
            modifiers = ((MethodNode)node).getModifiers();
        } else if (node instanceof PropertyNode) {
            modifiers = ((PropertyNode)node).getModifiers();
        } else {
            LOG.warn("isPublic node is not an expected type");
        }
        if (modifiers != null) {
            return Modifier.isPublic(modifiers);
        }
        return false;
    }

    public static boolean isNotNullCheck(Object expression) {
        return expression instanceof BinaryExpression && "!=".equals(((BinaryExpression)expression).getOperation().getText()) && (AstUtil.isNull((ASTNode)((BinaryExpression)expression).getLeftExpression()) || AstUtil.isNull((ASTNode)((BinaryExpression)expression).getRightExpression()));
    }

    public static boolean isNullCheck(Object expression) {
        return expression instanceof BinaryExpression && "==".equals(((BinaryExpression)expression).getOperation().getText()) && (AstUtil.isNull((ASTNode)((BinaryExpression)expression).getLeftExpression()) || AstUtil.isNull((ASTNode)((BinaryExpression)expression).getRightExpression()));
    }

    public static String getNullComparisonTarget(Object expression) {
        if (expression instanceof BinaryExpression && "!=".equals(((BinaryExpression)expression).getOperation().getText())) {
            if (AstUtil.isNull((ASTNode)((BinaryExpression)expression).getLeftExpression())) {
                return ((BinaryExpression)expression).getRightExpression().getText();
            }
            if (AstUtil.isNull((ASTNode)((BinaryExpression)expression).getRightExpression())) {
                return ((BinaryExpression)expression).getLeftExpression().getText();
            }
        }
        return null;
    }

    public static boolean isInstanceOfCheck(Object expression) {
        return expression instanceof BinaryExpression && "instanceof".equals(((BinaryExpression)expression).getOperation().getText());
    }

    public static String getInstanceOfTarget(Object expression) {
        if (AstUtil.isInstanceOfCheck(expression)) {
            return ((BinaryExpression)expression).getLeftExpression().getText();
        }
        return null;
    }

    public static Class getFieldType(ClassNode node, String fieldName) {
        while (node != null) {
            for (FieldNode field : node.getFields()) {
                if (!field.getName().equals(fieldName)) continue;
                return AstUtil.getFieldType(field);
            }
            node = node.getOuterClass();
        }
        return null;
    }

    public static Class getFieldType(FieldNode field) {
        Class castType;
        Class declaredType = AstUtil.getClassForClassNode(field.getType());
        if (declaredType != null) {
            return declaredType;
        }
        if (field.getInitialExpression() != null && (castType = AstUtil.getClassForClassNode(field.getInitialExpression().getType())) != null) {
            return castType;
        }
        if (field.getInitialExpression() instanceof ConstantExpression) {
            Object constantValue = ((ConstantExpression)field.getInitialExpression()).getValue();
            if (constantValue == null) {
                return null;
            }
            if (constantValue instanceof String) {
                return String.class;
            }
            if (AstUtil.isBoolean(field.getInitialExpression())) {
                return Boolean.class;
            }
            if (constantValue.getClass() == Integer.class || constantValue.getClass() == Integer.TYPE) {
                return Integer.class;
            }
            if (constantValue.getClass() == Long.class || constantValue.getClass() == Long.TYPE) {
                return Long.class;
            }
            if (constantValue.getClass() == Double.class || constantValue.getClass() == Double.TYPE) {
                return Double.class;
            }
            if (constantValue.getClass() == Float.class || constantValue.getClass() == Float.TYPE) {
                return Float.class;
            }
        }
        return null;
    }

    private static Class getClassForClassNode(ClassNode type) {
        Class primitiveType = AstUtil.getPrimitiveType(type);
        if (primitiveType != null) {
            return primitiveType;
        }
        if (AstUtil.classNodeImplementsType(type, String.class)) {
            return String.class;
        }
        if (AstUtil.classNodeImplementsType(type, ReentrantLock.class)) {
            return ReentrantLock.class;
        }
        if (type.getName() != null && type.getName().endsWith("[]")) {
            return Object[].class;
        }
        return null;
    }

    private static Class getPrimitiveType(ClassNode type) {
        if (AstUtil.classNodeImplementsType(type, Boolean.class) || AstUtil.classNodeImplementsType(type, Boolean.TYPE)) {
            return Boolean.class;
        }
        if (AstUtil.classNodeImplementsType(type, Long.class) || AstUtil.classNodeImplementsType(type, Long.TYPE)) {
            return Long.class;
        }
        if (AstUtil.classNodeImplementsType(type, Short.class) || AstUtil.classNodeImplementsType(type, Short.TYPE)) {
            return Short.class;
        }
        if (AstUtil.classNodeImplementsType(type, Double.class) || AstUtil.classNodeImplementsType(type, Double.TYPE)) {
            return Double.class;
        }
        if (AstUtil.classNodeImplementsType(type, Float.class) || AstUtil.classNodeImplementsType(type, Float.TYPE)) {
            return Float.class;
        }
        if (AstUtil.classNodeImplementsType(type, Character.class) || AstUtil.classNodeImplementsType(type, Character.TYPE)) {
            return Character.class;
        }
        if (AstUtil.classNodeImplementsType(type, Integer.class) || AstUtil.classNodeImplementsType(type, Integer.TYPE)) {
            return Integer.class;
        }
        if (AstUtil.classNodeImplementsType(type, Long.class) || AstUtil.classNodeImplementsType(type, Long.TYPE)) {
            return Long.class;
        }
        if (AstUtil.classNodeImplementsType(type, Byte.class) || AstUtil.classNodeImplementsType(type, Byte.TYPE)) {
            return Byte.class;
        }
        return null;
    }

    public static boolean isThisReference(Expression expression) {
        return expression instanceof VariableExpression && "this".equals(((VariableExpression)expression).getName());
    }

    public static boolean isSuperReference(Expression expression) {
        return expression instanceof VariableExpression && "super".equals(((VariableExpression)expression).getName());
    }

    public static boolean classNodeHasProperty(ClassNode classNode, String propertyName) {
        if (classNode.getFields() != null) {
            for (FieldNode field : classNode.getFields()) {
                if (!propertyName.equals(field.getName())) continue;
                return true;
            }
        }
        if (classNode.getProperties() != null) {
            for (PropertyNode property : classNode.getProperties()) {
                if (!propertyName.equals(property.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public static int findClassDeclarationLineNumber(ClassNode node, SourceCode sourceCode) {
        AnnotationNode lastAnnotation;
        int lineNumber = node.getLineNumber();
        if (!node.getAnnotations().isEmpty() && (lastAnnotation = (AnnotationNode)node.getAnnotations().get(node.getAnnotations().size() - 1)).getLastLineNumber() != -1) {
            Pattern classDeclarationPattern = Pattern.compile("class\\s+" + node.getNameWithoutPackage());
            for (int i = lastAnnotation.getLastLineNumber(); i <= sourceCode.getLines().size(); ++i) {
                String line = sourceCode.line(i - 1);
                Matcher matcher = classDeclarationPattern.matcher(line);
                if (!matcher.find()) continue;
                return i;
            }
        }
        return lineNumber;
    }

    public static int findFirstNonAnnotationLine(ASTNode node, SourceCode sourceCode) {
        if (node instanceof AnnotatedNode && !((AnnotatedNode)node).getAnnotations().isEmpty()) {
            List annotations = ((AnnotatedNode)node).getAnnotations();
            AnnotationNode lastAnnotation = (AnnotationNode)annotations.get(annotations.size() - 1);
            String rawLine = AstUtil.getRawLine(sourceCode, lastAnnotation.getLastLineNumber() - 1);
            if (rawLine == null) {
                return node.getLineNumber();
            }
            if (rawLine.length() > lastAnnotation.getLastColumnNumber()) {
                boolean doesItEndsWithLineComment = rawLine.substring(lastAnnotation.getLastColumnNumber() - 1).trim().startsWith("//");
                if (doesItEndsWithLineComment) {
                    return lastAnnotation.getLastLineNumber() + 1;
                }
                if (node.getClass() == ClassNode.class) {
                    if (rawLine.contains("class")) {
                        return lastAnnotation.getLastLineNumber();
                    }
                } else if (node.getClass() == MethodNode.class) {
                    if (rawLine.contains(((MethodNode)node).getName())) {
                        return lastAnnotation.getLastLineNumber();
                    }
                } else if (node instanceof FieldNode) {
                    if (rawLine.contains(((FieldNode)node).getName())) {
                        return lastAnnotation.getLastLineNumber();
                    }
                } else {
                    return lastAnnotation.getLastLineNumber();
                }
            }
            return lastAnnotation.getLastLineNumber() + 1;
        }
        return node.getLineNumber();
    }

    public static String getRawLine(SourceCode sourceCode, int lineNumber) {
        List<String> allLines = sourceCode.getLines();
        return lineNumber >= 0 && lineNumber < allLines.size() ? allLines.get(lineNumber) : null;
    }

    public static boolean isOneLiner(Object statement) {
        return statement instanceof BlockStatement && ((BlockStatement)statement).getStatements() != null && ((BlockStatement)statement).getStatements().size() == 1;
    }

    public static boolean expressionIsNullCheck(ASTNode node) {
        if (!(node instanceof IfStatement)) {
            return false;
        }
        if (((IfStatement)node).getBooleanExpression() == null) {
            return false;
        }
        BooleanExpression booleanExp = ((IfStatement)node).getBooleanExpression();
        if (AstUtil.isBinaryExpressionType(booleanExp.getExpression(), "==")) {
            if (AstUtil.isNull((ASTNode)((BinaryExpression)booleanExp.getExpression()).getLeftExpression()) && ((BinaryExpression)booleanExp.getExpression()).getRightExpression() instanceof VariableExpression) {
                return true;
            }
            if (AstUtil.isNull((ASTNode)((BinaryExpression)booleanExp.getExpression()).getRightExpression()) && ((BinaryExpression)booleanExp.getExpression()).getLeftExpression() instanceof VariableExpression) {
                return true;
            }
        } else if (booleanExp.getExpression() instanceof NotExpression && ((NotExpression)booleanExp.getExpression()).getExpression() instanceof VariableExpression) {
            return true;
        }
        return false;
    }

    public static boolean expressionIsAssignment(ASTNode node, String variableName) {
        return node instanceof Expression && AstUtil.isBinaryExpressionType((Expression)node, "=") ? AstUtil.isVariable((ASTNode)((BinaryExpression)node).getLeftExpression(), variableName) : node instanceof ExpressionStatement && AstUtil.isBinaryExpressionType(((ExpressionStatement)node).getExpression(), "=") && AstUtil.isVariable((ASTNode)((BinaryExpression)((ExpressionStatement)node).getExpression()).getLeftExpression(), variableName);
    }

    private static String repeat(char c, int count) {
        String result = "";
        for (int x = 0; x <= count; ++x) {
            result = result + c;
        }
        return result;
    }

    public static String getNodeText(ASTNode expression, SourceCode sourceCode) {
        String line = sourceCode.getLines().get(expression.getLineNumber() - 1);
        int endColumn = expression.getLineNumber() == expression.getLastLineNumber() ? expression.getLastColumnNumber() - 1 : line.length();
        return line.substring(expression.getColumnNumber() - 1, endColumn);
    }

    public static String getLastLineOfNodeText(ASTNode expression, SourceCode sourceCode) {
        String line = sourceCode.getLines().get(expression.getLastLineNumber() - 1);
        int startColumn = expression.getLineNumber() == expression.getLastLineNumber() ? expression.getColumnNumber() - 1 : 0;
        return line.substring(startColumn, expression.getLastColumnNumber() - 1);
    }

    public static List<String> getSourceLinesForNode(ASTNode node, SourceCode sourceCode) {
        if (node.getLineNumber() < 1 || node.getLastLineNumber() < 1) {
            return Collections.emptyList();
        }
        ArrayList<String> lines = new ArrayList<String>();
        for (int lineIndex = node.getLineNumber() - 1; lineIndex <= node.getLastLineNumber() - 1; ++lineIndex) {
            String line = AstUtil.getRawLine(sourceCode, lineIndex);
            if (lineIndex == node.getLineNumber() - 1) {
                line = line.substring(node.getColumnNumber() - 1);
            }
            lines.add(line.trim());
        }
        return lines;
    }

    public static String getDeclaration(ASTNode node, SourceCode sourceCode) {
        if (node.getLineNumber() < 1) {
            return "";
        }
        if (node.getLastLineNumber() < 1) {
            return "";
        }
        if (node.getColumnNumber() < 1) {
            return "";
        }
        if (node.getLastColumnNumber() < 1) {
            return "";
        }
        String acc = "";
        for (int lineIndex = node.getLineNumber() - 1; lineIndex <= node.getLastLineNumber() - 1; ++lineIndex) {
            String line = AstUtil.getRawLine(sourceCode, lineIndex);
            if (lineIndex == node.getLineNumber() - 1) {
                int nonRelevantColumns = node.getColumnNumber() - 1;
                line = line.replaceFirst(".{" + nonRelevantColumns + "}", AstUtil.repeat(' ', nonRelevantColumns));
            }
            if (lineIndex == node.getLastLineNumber() - 1) {
                // empty if block
            }
            if (line.contains("{")) {
                acc = acc + line.substring(0, line.indexOf("{"));
                break;
            }
            acc = acc + line + " ";
        }
        return acc;
    }

    public static String createPrettyExpression(ASTNode expression) {
        if (expression instanceof ConstantExpression && ((ConstantExpression)expression).getValue() instanceof String) {
            return "'" + expression.getText() + "'";
        }
        if (expression instanceof GStringExpression) {
            return "\"" + expression.getText() + "\"";
        }
        return expression.getText();
    }

    public static String getSourceBetweenNodes(ASTNode beforeNode, ASTNode afterNode, SourceCode sourceCode) {
        if (AstUtil.isFromGeneratedSourceCode(beforeNode) || AstUtil.isFromGeneratedSourceCode(afterNode)) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        String beforeLastLine = AstUtil.lastSourceLine(beforeNode, sourceCode);
        int firstColumnAfterBeforeNode = beforeNode.getLastColumnNumber() - 1;
        if (beforeNode.getLastLineNumber() == afterNode.getLineNumber()) {
            str.append(beforeLastLine, firstColumnAfterBeforeNode, afterNode.getColumnNumber() - 1);
        } else {
            str.append(beforeLastLine.substring(firstColumnAfterBeforeNode));
            str.append('\n');
            for (int i = beforeNode.getLastLineNumber(); i < afterNode.getLineNumber() - 1; ++i) {
                str.append(sourceCode.line(i));
                str.append('\n');
            }
            String afterFirstLine = AstUtil.sourceLine(afterNode, sourceCode);
            str.append(afterFirstLine, 0, afterNode.getColumnNumber() - 1);
        }
        return str.toString();
    }

    private static String lastSourceLine(ASTNode node, SourceCode sourceCode) {
        return sourceCode.getLines().get(node.getLastLineNumber() - 1);
    }

    private static String sourceLine(ASTNode node, SourceCode sourceCode) {
        return sourceCode.getLines().get(AstUtil.findFirstNonAnnotationLine(node, sourceCode) - 1);
    }

    static {
        PREDEFINED_CONSTANTS.put("Boolean", Arrays.asList("FALSE", "TRUE"));
    }
}

