/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.oort.jakarta;

import jakarta.servlet.ServletConfig;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import org.cometd.oort.Oort;
import org.cometd.oort.OortMulticastConfigurer;
import org.cometd.oort.jakarta.OortConfigServlet;

public class OortMulticastConfigServlet
extends OortConfigServlet {
    public static final String OORT_MULTICAST_BIND_ADDRESS_PARAM = "oort.multicast.bindAddress";
    public static final String OORT_MULTICAST_GROUP_ADDRESS_PARAM = "oort.multicast.groupAddress";
    public static final String OORT_MULTICAST_GROUP_PORT_PARAM = "oort.multicast.groupPort";
    public static final String OORT_MULTICAST_GROUP_INTERFACES_PARAM = "oort.multicast.groupInterfaces";
    public static final String OORT_MULTICAST_TIME_TO_LIVE_PARAM = "oort.multicast.timeToLive";
    public static final String OORT_MULTICAST_ADVERTISE_INTERVAL_PARAM = "oort.multicast.advertiseInterval";
    public static final String OORT_MULTICAST_CONNECT_TIMEOUT_PARAM = "oort.multicast.connectTimeout";
    public static final String OORT_MULTICAST_MAX_TRANSMISSION_LENGTH_PARAM = "oort.multicast.maxTransmissionLength";
    private OortMulticastConfigurer configurer;

    @Override
    protected void configureCloud(ServletConfig config, Oort oort) throws Exception {
        String maxTransmissionLength;
        String connectTimeout;
        String advertiseInterval;
        String timeToLive;
        String groupInterfaceList;
        String groupPort;
        String groupAddress;
        this.configurer = new OortMulticastConfigurer(oort);
        String bindAddress = config.getInitParameter(OORT_MULTICAST_BIND_ADDRESS_PARAM);
        if (bindAddress != null) {
            this.configurer.setBindAddress(InetAddress.getByName(bindAddress));
        }
        if ((groupAddress = config.getInitParameter(OORT_MULTICAST_GROUP_ADDRESS_PARAM)) != null) {
            this.configurer.setGroupAddress(InetAddress.getByName(groupAddress));
        }
        if ((groupPort = config.getInitParameter(OORT_MULTICAST_GROUP_PORT_PARAM)) != null) {
            this.configurer.setGroupPort(Integer.parseInt(groupPort));
        }
        if ((groupInterfaceList = config.getInitParameter(OORT_MULTICAST_GROUP_INTERFACES_PARAM)) != null) {
            String[] groupInterfaces;
            ArrayList<NetworkInterface> networkInterfaces = new ArrayList<NetworkInterface>();
            for (String groupInterface : groupInterfaces = groupInterfaceList.split(",")) {
                if ((groupInterface = groupInterface.trim()).isEmpty()) continue;
                networkInterfaces.add(NetworkInterface.getByInetAddress(InetAddress.getByName(groupInterface)));
            }
            this.configurer.setGroupInterfaces(networkInterfaces);
        }
        if ((timeToLive = config.getInitParameter(OORT_MULTICAST_TIME_TO_LIVE_PARAM)) != null) {
            this.configurer.setTimeToLive(Integer.parseInt(timeToLive));
        }
        if ((advertiseInterval = config.getInitParameter(OORT_MULTICAST_ADVERTISE_INTERVAL_PARAM)) != null) {
            this.configurer.setAdvertiseInterval(Long.parseLong(advertiseInterval));
        }
        if ((connectTimeout = config.getInitParameter(OORT_MULTICAST_CONNECT_TIMEOUT_PARAM)) != null) {
            this.configurer.setConnectTimeout(Long.parseLong(connectTimeout));
        }
        if ((maxTransmissionLength = config.getInitParameter(OORT_MULTICAST_MAX_TRANSMISSION_LENGTH_PARAM)) != null) {
            this.configurer.setMaxTransmissionLength(Integer.parseInt(maxTransmissionLength));
        }
        this.configurer.start();
    }

    @Override
    public void destroy() {
        if (this.configurer != null) {
            this.stopConfigurer();
            this.configurer.join(1000L);
        }
        super.destroy();
    }

    private void stopConfigurer() {
        try {
            this.configurer.stop();
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }
}

