/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.oort;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import org.cometd.bayeux.ChannelId;
import org.cometd.bayeux.client.ClientSession;
import org.cometd.bayeux.client.ClientSessionChannel;
import org.cometd.client.BayeuxClient;
import org.cometd.client.transport.ClientTransport;
import org.cometd.oort.Oort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OortComet
extends BayeuxClient {
    private final Logger logger = LoggerFactory.getLogger((String)(((Object)((Object)this)).getClass().getName() + "." + Integer.toHexString(System.identityHashCode((Object)this))));
    private final ConcurrentMap<String, ClientSessionChannel.MessageListener> _subscriptions = new ConcurrentHashMap<String, ClientSessionChannel.MessageListener>();
    private final Oort _oort;
    private final String _cometURL;
    private volatile boolean _subscriptionsAllowed;

    public OortComet(Oort oort, String cometURL, ScheduledExecutorService scheduler, ClientTransport transport, ClientTransport ... transports) {
        super(cometURL, scheduler, transport, transports);
        this._oort = oort;
        this._cometURL = cometURL;
    }

    protected void subscribe(Set<String> observedChannels) {
        if (!this._subscriptionsAllowed) {
            return;
        }
        for (String channel : observedChannels) {
            ClientSessionChannel.MessageListener listener;
            ClientSessionChannel.MessageListener existing;
            if (this._subscriptions.containsKey(channel) || (existing = this._subscriptions.putIfAbsent(channel, listener = (c, message) -> {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Republishing message {} from {}", (Object)message, (Object)this._cometURL);
                }
                if (ChannelId.isBroadcast((String)message.getChannel())) {
                    this._oort.getOortSession().getChannel(message.getChannel()).publish((Object)message);
                }
            })) != null) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Subscribing to messages on {} from {}", (Object)channel, (Object)this._cometURL);
            }
            this.getChannel(channel).subscribe(listener);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Subscriptions to messages on {} from {}", this._subscriptions, (Object)this._cometURL);
        }
    }

    protected void unsubscribe(String channel) {
        ClientSessionChannel.MessageListener listener = (ClientSessionChannel.MessageListener)this._subscriptions.remove(channel);
        if (listener != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Unsubscribing to messages on {} from {}", (Object)channel, (Object)this._cometURL);
            }
            this.getChannel(channel).unsubscribe(listener);
        }
    }

    protected void clearSubscriptions() {
        for (String channel : this._oort.getObservedChannels()) {
            this.unsubscribe(channel);
        }
    }

    void open(ClientSession.MessageListener callback) {
        this.batch(() -> {
            this.getChannel("/oort/cloud").subscribe((channel, message) -> {
                if (message.isSuccessful()) {
                    this._oort.joinComets(message);
                }
            });
            this.clearSubscriptions();
            this._subscriptionsAllowed = true;
            Set<String> channels = this._oort.getObservedChannels();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Observing channels {}", channels);
            }
            this.subscribe(channels);
            this.getChannel("/oort/cloud").publish(new ArrayList<String>(this._oort.getKnownComets()));
            HashMap<String, String> data = new HashMap<String, String>(2);
            data.put("oortId", this._oort.getId());
            data.put("oortURL", this._oort.getURL());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Sending join data {}", data);
            }
            this.getChannel("/service/oort").publish(data, callback);
        });
    }

    public String toString() {
        return String.format("%s[%s]", super.toString(), this._cometURL);
    }
}

