/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.websocket.common;

import java.net.HttpCookie;
import java.net.SocketAddress;
import java.security.Principal;
import java.text.ParseException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.cometd.bayeux.server.BayeuxContext;
import org.cometd.server.websocket.common.CookieParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBayeuxContext
implements BayeuxContext {
    private static final Logger logger = LoggerFactory.getLogger(BayeuxContext.class);
    private final String url;
    private final String contextPath;
    private final Map<String, List<String>> headers;
    private final Map<String, List<String>> parameters;
    private final Principal principal;
    private final SocketAddress localAddress;
    private final SocketAddress remoteAddress;
    private final List<Locale> locales;
    private final String protocol;
    private final boolean secure;

    public AbstractBayeuxContext(String uri, String contextPath, String query, Map<String, List<String>> headers, Map<String, List<String>> parameters, Principal principal, SocketAddress local, SocketAddress remote, List<Locale> locales, String protocol, boolean secure) {
        this.url = uri + (String)(query == null ? "" : "?" + query);
        this.contextPath = contextPath;
        this.headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        this.headers.putAll(headers);
        this.parameters = parameters;
        this.principal = principal;
        this.localAddress = local;
        this.remoteAddress = remote;
        this.locales = locales;
        this.protocol = protocol;
        this.secure = secure;
    }

    public String getURL() {
        return this.url;
    }

    public String getHeader(String name) {
        List<String> values = this.headers.get(name);
        return values != null && values.size() > 0 ? values.get(0) : null;
    }

    public List<String> getHeaderValues(String name) {
        return this.headers.get(name);
    }

    public String getParameter(String name) {
        List<String> values = this.parameters.get(name);
        return values != null && values.size() > 0 ? values.get(0) : null;
    }

    public List<String> getParameterValues(String name) {
        return this.parameters.get(name);
    }

    public Principal getUserPrincipal() {
        return this.principal;
    }

    public boolean isUserInRole(String role) {
        return false;
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public SocketAddress getLocalAddress() {
        return this.localAddress;
    }

    public List<Locale> getLocales() {
        return this.locales;
    }

    public String getCookie(String name) {
        try {
            List<String> values = this.headers.get("Cookie");
            if (values != null) {
                for (String value : values) {
                    for (HttpCookie cookie : CookieParser.parse(value)) {
                        if (!cookie.getName().equals(name)) continue;
                        return cookie.getValue();
                    }
                }
            }
            return null;
        }
        catch (ParseException x) {
            logger.debug("Error parsing cookie " + x.getMessage() + " at index " + x.getErrorOffset(), (Throwable)x);
            return null;
        }
    }

    public Object getContextAttribute(String name) {
        return null;
    }

    public Object getRequestAttribute(String name) {
        return null;
    }

    public String getSessionId() {
        return null;
    }

    public Object getSessionAttribute(String name) {
        return null;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public boolean isSecure() {
        return this.secure;
    }
}

