/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.websocket.jakarta;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.Extension;
import jakarta.websocket.HandshakeResponse;
import jakarta.websocket.server.HandshakeRequest;
import jakarta.websocket.server.ServerContainer;
import jakarta.websocket.server.ServerEndpointConfig;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.cometd.bayeux.server.BayeuxContext;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.websocket.common.AbstractBayeuxContext;
import org.cometd.server.websocket.common.AbstractWebSocketEndPoint;
import org.cometd.server.websocket.common.AbstractWebSocketTransport;
import org.cometd.server.websocket.jakarta.WebSocketEndPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketTransport
extends AbstractWebSocketTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketTransport.class);

    public WebSocketTransport(BayeuxServerImpl bayeux) {
        super(bayeux);
    }

    public void init() {
        super.init();
        ServletContext context = (ServletContext)this.getBayeuxServer().getOption(ServletContext.class.getName());
        if (context == null) {
            throw new IllegalArgumentException("Missing ServletContext");
        }
        String cometdURLMapping = (String)this.getOption("cometdURLMapping");
        if (cometdURLMapping == null) {
            throw new IllegalArgumentException("Missing 'cometdURLMapping' parameter");
        }
        ServerContainer container = (ServerContainer)context.getAttribute(ServerContainer.class.getName());
        if (container == null) {
            throw new IllegalArgumentException("Missing WebSocket ServerContainer");
        }
        long maxMessageSize = this.getMaxMessageSize();
        if (maxMessageSize < 0L) {
            maxMessageSize = container.getDefaultMaxTextMessageBufferSize();
        }
        container.setDefaultMaxTextMessageBufferSize((int)maxMessageSize);
        long idleTimeout = this.getOption("idleTimeout", container.getDefaultMaxSessionIdleTimeout());
        container.setDefaultMaxSessionIdleTimeout(idleTimeout);
        String protocol = this.getProtocol();
        List<String> protocols = protocol == null ? null : List.of(protocol);
        Configurator configurator = new Configurator(context);
        for (String mapping : this.normalizeURLMapping(cometdURLMapping)) {
            ServerEndpointConfig config = ServerEndpointConfig.Builder.create(WebSocketEndPoint.class, (String)mapping).subprotocols(protocols).configurator((ServerEndpointConfig.Configurator)configurator).build();
            try {
                container.addEndpoint(config);
            }
            catch (DeploymentException x) {
                throw new RuntimeException(x);
            }
        }
    }

    protected boolean checkOrigin(String origin) {
        return true;
    }

    protected void modifyHandshake(HandshakeRequest request, HandshakeResponse response) {
    }

    protected Object newWebSocketEndPoint(BayeuxContext bayeuxContext) {
        return new EndPoint(bayeuxContext);
    }

    private static List<Locale> retrieveLocales(Map<String, Object> userProperties) {
        List locales = (List)userProperties.get("jakarta.websocket.upgrade.locales");
        if (locales == null || locales.isEmpty()) {
            return List.of(Locale.getDefault());
        }
        return locales;
    }

    private static boolean isSecure(HandshakeRequest request) {
        String scheme = request.getRequestURI().getScheme();
        return "https".equalsIgnoreCase(scheme) || "wss".equalsIgnoreCase(scheme);
    }

    private class Configurator
    extends ServerEndpointConfig.Configurator {
        private final ServletContext servletContext;

        private Configurator(ServletContext servletContext) {
            this.servletContext = servletContext;
        }

        public void modifyHandshake(ServerEndpointConfig sec, HandshakeRequest request, HandshakeResponse response) {
            BayeuxContextHolder context = this.provideContext();
            context.bayeuxContext = new JakartaWebSocketContext(this.servletContext, request, sec.getUserProperties());
            WebSocketTransport.this.modifyHandshake(request, response);
        }

        public boolean checkOrigin(String originHeaderValue) {
            return WebSocketTransport.this.checkOrigin(originHeaderValue);
        }

        public String getNegotiatedSubprotocol(List<String> supported, List<String> requested) {
            BayeuxContextHolder context = this.provideContext();
            context.protocolMatches = this.checkProtocol(supported, requested);
            if (context.protocolMatches) {
                return super.getNegotiatedSubprotocol(supported, requested);
            }
            LOGGER.warn("Could not negotiate WebSocket SubProtocols: server{} != client{}", supported, requested);
            return null;
        }

        public List<Extension> getNegotiatedExtensions(List<Extension> installed, List<Extension> requested) {
            LinkedHashSet<Extension> negotiated = new LinkedHashSet<Extension>();
            block0: for (Extension requestedExtension : requested) {
                String name = requestedExtension.getName();
                boolean option = WebSocketTransport.this.getOption("enableExtension." + name, true);
                if (!option) continue;
                for (Extension installedExtension : installed) {
                    if (!installedExtension.getName().equals(name)) continue;
                    negotiated.add(requestedExtension);
                    continue block0;
                }
            }
            return new ArrayList<Extension>(negotiated);
        }

        public <T> T getEndpointInstance(Class<T> endpointClass) throws InstantiationException {
            BayeuxContextHolder holder = this.provideContext();
            if (!WebSocketTransport.this.getBayeuxServer().getAllowedTransports().contains(WebSocketTransport.this.getName())) {
                throw new InstantiationException("Transport not allowed");
            }
            if (!holder.protocolMatches) {
                throw new InstantiationException("Could not negotiate WebSocket SubProtocols");
            }
            Object instance = WebSocketTransport.this.newWebSocketEndPoint((BayeuxContext)holder.bayeuxContext);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Created {}", instance);
            }
            holder.clear();
            return (T)instance;
        }

        private boolean checkProtocol(List<String> serverProtocols, List<String> clientProtocols) {
            if (serverProtocols.isEmpty()) {
                return true;
            }
            for (String clientProtocol : clientProtocols) {
                if (!serverProtocols.contains(clientProtocol)) continue;
                return true;
            }
            return false;
        }

        private BayeuxContextHolder provideContext() {
            BayeuxContextHolder holder = BayeuxContextHolder.holder.get();
            if (holder == null) {
                holder = new BayeuxContextHolder();
                holder.clear();
                BayeuxContextHolder.holder.set(holder);
            }
            return holder;
        }
    }

    public class EndPoint
    extends WebSocketEndPoint {
        public EndPoint(BayeuxContext bayeuxContext) {
            super(WebSocketTransport.this, bayeuxContext);
        }

        @Override
        protected void writeComplete(AbstractWebSocketEndPoint.Context context, List<ServerMessage> messages) {
            WebSocketTransport.this.writeComplete(context, messages);
        }
    }

    private static class BayeuxContextHolder {
        private static final ThreadLocal<BayeuxContextHolder> holder = new ThreadLocal();
        private JakartaWebSocketContext bayeuxContext;
        private boolean protocolMatches;

        private BayeuxContextHolder() {
        }

        public void clear() {
            holder.set(null);
            this.bayeuxContext = null;
            this.protocolMatches = true;
        }
    }

    private static class JakartaWebSocketContext
    extends AbstractBayeuxContext {
        private final Map<String, Object> contextAttributes;
        private final Map<String, Object> requestAttributes;
        private final String sessionId;
        private final Map<String, Object> sessionAttributes;

        private JakartaWebSocketContext(ServletContext context, HandshakeRequest request, Map<String, Object> userProperties) {
            super(request.getRequestURI().toString(), context.getContextPath(), request.getQueryString(), request.getHeaders(), request.getParameterMap(), request.getUserPrincipal(), (SocketAddress)userProperties.get("jakarta.websocket.endpoint.localAddress"), (SocketAddress)userProperties.get("jakarta.websocket.endpoint.remoteAddress"), WebSocketTransport.retrieveLocales(userProperties), "HTTP/1.1", WebSocketTransport.isSecure(request));
            this.contextAttributes = Map.copyOf(JakartaWebSocketContext.attributesToMap(context));
            this.requestAttributes = Map.of();
            HttpSession httpSession = (HttpSession)request.getHttpSession();
            this.sessionId = httpSession == null ? null : httpSession.getId();
            this.sessionAttributes = Map.copyOf(JakartaWebSocketContext.attributesToMap(httpSession));
        }

        private static Map<String, Object> attributesToMap(ServletContext context) {
            return JakartaWebSocketContext.attributesToMap(context.getAttributeNames(), arg_0 -> ((ServletContext)context).getAttribute(arg_0));
        }

        private static Map<String, Object> attributesToMap(HttpSession session) {
            if (session == null) {
                return Map.of();
            }
            return JakartaWebSocketContext.attributesToMap(session.getAttributeNames(), arg_0 -> ((HttpSession)session).getAttribute(arg_0));
        }

        private static Map<String, Object> attributesToMap(Enumeration<String> names, Function<String, Object> getter) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            while (names.hasMoreElements()) {
                String name = names.nextElement();
                result.put(name, getter.apply(name));
            }
            return result;
        }

        public Object getContextAttribute(String name) {
            return this.contextAttributes.get(name);
        }

        public Object getRequestAttribute(String name) {
            return this.requestAttributes.get(name);
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public Object getSessionAttribute(String name) {
            return this.sessionAttributes.get(name);
        }
    }
}

