/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.cdi.util.weft;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.commonjava.cdi.util.weft.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextSensitiveExecutorService
implements ScheduledExecutorService {
    private ExecutorService delegate;

    public ContextSensitiveExecutorService(ExecutorService delegate) {
        this.delegate = delegate;
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.delegate.awaitTermination(l, timeUnit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        return this.delegate.submit(this.wrapCallable(callable));
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T t) {
        return this.delegate.submit(this.wrapRunnable(runnable), t);
    }

    @Override
    public Future<?> submit(Runnable runnable) {
        return this.delegate.submit(this.wrapRunnable(runnable));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection) throws InterruptedException {
        return this.delegate.invokeAll(this.wrapAll(collection));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection, long l, TimeUnit timeUnit) throws InterruptedException {
        return this.delegate.invokeAll(this.wrapAll(collection), l, timeUnit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection) throws InterruptedException, ExecutionException {
        return this.delegate.invokeAny(this.wrapAll(collection));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection, long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.invokeAny(this.wrapAll(collection), l, timeUnit);
    }

    @Override
    public void execute(Runnable runnable) {
        this.delegate.execute(this.wrapRunnable(runnable));
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable runnable, long l, TimeUnit timeUnit) {
        return this.asScheduled(d -> d.schedule(this.wrapRunnable(runnable), l, timeUnit));
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long l, TimeUnit timeUnit) {
        return this.asScheduled(d -> d.schedule(this.wrapCallable(callable), l, timeUnit));
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable runnable, long l, long l1, TimeUnit timeUnit) {
        return this.asScheduled(d -> d.scheduleAtFixedRate(this.wrapRunnable(runnable), l, l1, timeUnit));
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable runnable, long l, long l1, TimeUnit timeUnit) {
        return this.asScheduled(d -> d.scheduleWithFixedDelay(this.wrapRunnable(runnable), l, l1, timeUnit));
    }

    private <T> ScheduledFuture<T> asScheduled(Function<ScheduledExecutorService, ScheduledFuture<T>> consumer) {
        if (this.delegate instanceof ScheduledExecutorService) {
            return consumer.apply((ScheduledExecutorService)this.delegate);
        }
        throw new IllegalStateException("Cannot run scheduled executions; underlying ExecutorService is not instanceof ScheduledExecutorService. Try using @WeftScheduledExecutor annotation in CDI injection.");
    }

    private <T> Collection<Callable<T>> wrapAll(Collection<? extends Callable<T>> collection) {
        ThreadContext ctx = ThreadContext.getContext(false);
        return collection.parallelStream().map(callable -> {
            ThreadContext old = ThreadContext.setContext(ctx);
            Logger logger = LoggerFactory.getLogger(this.getClass());
            logger.debug("Using ThreadContext: {} (saving: {}) in {}", new Object[]{ctx, old, Thread.currentThread().getName()});
            return () -> {
                try {
                    Object v = callable.call();
                    return v;
                }
                finally {
                    logger.debug("Restoring ThreadContext: {} in: {}", (Object)old, (Object)Thread.currentThread().getName());
                    ThreadContext.setContext(old);
                }
            };
        }).collect(Collectors.toList());
    }

    private Runnable wrapRunnable(Runnable runnable) {
        ThreadContext ctx = ThreadContext.getContext(false);
        return () -> {
            ThreadContext old = ThreadContext.setContext(ctx);
            Logger logger = LoggerFactory.getLogger(this.getClass());
            logger.debug("Using ThreadContext: {} (saving: {}) in {}", new Object[]{ctx, old, Thread.currentThread().getName()});
            try {
                runnable.run();
            }
            finally {
                logger.debug("Restoring ThreadContext: {} in: {}", (Object)old, (Object)Thread.currentThread().getName());
                ThreadContext.setContext(old);
            }
        };
    }

    private <T> Callable<T> wrapCallable(Callable<T> callable) {
        ThreadContext ctx = ThreadContext.getContext(false);
        return () -> {
            ThreadContext old = ThreadContext.setContext(ctx);
            Logger logger = LoggerFactory.getLogger(this.getClass());
            logger.debug("Using ThreadContext: {} (saving: {}) in {}", new Object[]{ctx, old, Thread.currentThread().getName()});
            try {
                Object v = callable.call();
                return v;
            }
            finally {
                logger.debug("Restoring ThreadContext: {} in: {}", (Object)old, (Object)Thread.currentThread().getName());
                ThreadContext.setContext(old);
            }
        };
    }
}

