/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.atlas.graph.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.commonjava.maven.atlas.graph.model.EProjectRelationshipCollection;
import org.commonjava.maven.atlas.graph.rel.ProjectRelationship;
import org.commonjava.maven.atlas.graph.rel.RelationshipComparator;
import org.commonjava.maven.atlas.graph.util.RelationshipUtils;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;

public class EProjectCycle
implements Iterable<ProjectRelationship<?, ?>>,
EProjectRelationshipCollection {
    private static final long serialVersionUID = 1L;
    private List<ProjectRelationship<?, ?>> relationships = new ArrayList();

    public EProjectCycle() {
    }

    public EProjectCycle(List<ProjectRelationship<?, ?>> cycle) {
        this.relationships = new ArrayList(cycle);
    }

    public boolean contains(ProjectRelationship<?, ?> rel) {
        return this.relationships.contains(rel);
    }

    public boolean contains(ProjectVersionRef ref) {
        for (ProjectRelationship<?, ?> rel : this.relationships) {
            if (!rel.getDeclaring().equals(ref)) continue;
            return true;
        }
        return false;
    }

    public int indexOf(ProjectRelationship<?, ?> rel) {
        return this.relationships.indexOf(rel);
    }

    public int indexOf(ProjectVersionRef ref) {
        int targetIdx = -1;
        for (int i = 0; i < this.relationships.size(); ++i) {
            ProjectRelationship<?, ?> rel = this.relationships.get(i);
            if (rel.getDeclaring().equals(ref)) {
                return i;
            }
            if (targetIdx >= 0 || !rel.getTarget().asProjectVersionRef().equals(ref)) continue;
            targetIdx = i;
        }
        return targetIdx;
    }

    @Override
    public Iterator<ProjectRelationship<?, ?>> iterator() {
        return this.relationships.iterator();
    }

    @Override
    public Collection<ProjectRelationship<?, ?>> getAllRelationships() {
        Collection<ProjectRelationship<?, ?>> rels = this.getExactAllRelationships();
        RelationshipUtils.filterTerminalParents(rels);
        return rels;
    }

    @Override
    public Collection<ProjectRelationship<?, ?>> getExactAllRelationships() {
        return new ArrayList(this.relationships);
    }

    public Set<ProjectVersionRef> getAllParticipatingProjects() {
        HashSet<ProjectVersionRef> refs = new HashSet<ProjectVersionRef>();
        for (ProjectRelationship<?, ?> rel : this.relationships) {
            refs.add(rel.getDeclaring());
            refs.add(rel.getTarget().asProjectVersionRef());
        }
        return refs;
    }

    public List<ProjectRelationship<?, ?>> getRelationships() {
        return this.relationships;
    }

    public void setRelationships(List<ProjectRelationship<?, ?>> relationships) {
        this.relationships = relationships;
    }

    public String toString() {
        return String.format("Project cycle: [%s]", StringUtils.join(this.relationships, (String)" -> "));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        ArrayList sorted = new ArrayList(this.relationships);
        Collections.sort(sorted, RelationshipComparator.INSTANCE);
        result = 31 * result + sorted.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EProjectCycle other = (EProjectCycle)obj;
        if (this.relationships == null) {
            if (other.relationships != null) {
                return false;
            }
        } else {
            HashSet cycle = new HashSet(this.relationships);
            HashSet otherCycle = new HashSet(other.relationships);
            for (ProjectRelationship projectRelationship : cycle) {
                if (otherCycle.contains(projectRelationship)) continue;
                return false;
            }
        }
        return true;
    }

    public static final class Builder {
        private final List<ProjectRelationship<?, ?>> participants;

        public Builder(ProjectRelationship<?, ?> ... rels) {
            this.participants = new ArrayList(Arrays.asList(rels));
        }

        public Builder(List<ProjectRelationship<?, ?>> rels) {
            this.participants = new ArrayList(rels);
        }

        public Builder(Builder builder) {
            this.participants = new ArrayList(builder.participants);
        }

        public Builder(Builder builder, int start) {
            this.participants = new ArrayList(builder.participants);
            for (int i = 0; i < start; ++i) {
                this.participants.remove(0);
            }
        }

        public Builder with(ProjectRelationship<?, ?> rel) {
            this.participants.add(rel);
            return this;
        }

        public Builder withoutLast() {
            this.participants.remove(this.participants.size() - 1);
            return this;
        }

        public EProjectCycle build() {
            return new EProjectCycle(this.participants);
        }

        public int indexOf(ProjectVersionRef ref) {
            return this.build().indexOf(ref);
        }

        public int indexOf(ProjectRelationship<?, ?> rel) {
            return this.build().indexOf(rel);
        }

        public boolean contains(ProjectVersionRef ref) {
            return this.build().contains(ref);
        }

        public boolean contains(ProjectRelationship<?, ?> rel) {
            return this.build().contains(rel);
        }
    }
}

