/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.reflect.FieldUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.config.ReleaseDescriptorBuilder;
import org.apache.maven.shared.release.config.ReleaseUtils;
import org.apache.maven.shared.release.transform.ModelETLRequest;
import org.apache.maven.shared.release.transform.jdom2.JDomModelETL;
import org.apache.maven.shared.release.transform.jdom2.JDomModelETLFactory;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.jdom.JDOMModelConverter;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.common.session.MavenSessionHandler;
import org.commonjava.maven.ext.common.util.LineSeparator;
import org.commonjava.maven.ext.common.util.ManifestUtils;
import org.commonjava.maven.ext.io.FileIO;
import org.commonjava.maven.galley.maven.parse.PomPeek;
import org.jdom2.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class PomIO {
    public static final String PARSE_POM_TEMPLATES = "parsePomTemplates";
    private static final String MODIFIED_BY = "Modified by POM Manipulation Extension for Maven";
    private static final Logger logger = LoggerFactory.getLogger(PomIO.class);
    private final JDomModelETLFactory modelETLFactories = new JDomModelETLFactory();
    private final ReleaseDescriptorBuilder releaseDescriptorBuilder = new ReleaseDescriptorBuilder();
    private final JDOMModelConverter jdomModelConverter = new JDOMModelConverter();
    private final boolean parsePomTemplates;
    private String manifestComment;

    @Inject
    public PomIO(MavenSessionHandler handler) {
        this.parsePomTemplates = Boolean.parseBoolean(handler.getUserProperties().getProperty(PARSE_POM_TEMPLATES, "true"));
    }

    public PomIO() {
        this.parsePomTemplates = true;
    }

    public List<Project> parseProject(File pom) throws ManipulationException {
        List<PomPeek> peeked = this.peekAtPomHierarchy(pom);
        try {
            return this.readModelsForManipulation(pom.getCanonicalFile(), peeked);
        }
        catch (IOException e) {
            throw new ManipulationException("Error getting canonical file", (Throwable)e);
        }
    }

    private List<Project> readModelsForManipulation(File executionRoot, List<PomPeek> peeked) throws ManipulationException {
        ArrayList<Project> projects = new ArrayList<Project>();
        HashMap<Project, ProjectVersionRef> projectToParent = new HashMap<Project, ProjectVersionRef>();
        for (PomPeek peek : peeked) {
            Model raw;
            File pom = peek.getPom();
            try (FileInputStream in = new FileInputStream(pom);){
                raw = new MavenXpp3Reader().read((InputStream)in);
            }
            catch (IOException | XmlPullParserException e) {
                throw new ManipulationException("Failed to build model for POM: ({}) : {}", new Object[]{pom, e.getMessage(), e});
            }
            if (raw == null) continue;
            Project project = new Project(pom, raw);
            projectToParent.put(project, peek.getParentKey());
            project.setInheritanceRoot(peek.isInheritanceRoot());
            if (executionRoot.equals(pom)) {
                if (logger.isDebugEnabled()) {
                    String s = project.isInheritanceRoot() ? " and is the inheritance root. " : "";
                    logger.debug("Setting execution root to {} with file {}{}", new Object[]{project, pom, s});
                }
                project.setExecutionRoot();
                try {
                    if (FileUtils.readFileToString((File)pom, (Charset)StandardCharsets.UTF_8).contains(MODIFIED_BY)) {
                        project.setIncrementalPME(true);
                    }
                }
                catch (IOException e) {
                    throw new ManipulationException("Failed to read POM: {}", new Object[]{pom, e});
                }
            }
            projects.add(project);
        }
        for (Project p : projects) {
            ProjectVersionRef pvr = (ProjectVersionRef)projectToParent.get(p);
            p.setProjectParent(this.getParent(projects, pvr));
        }
        return projects;
    }

    private Project getParent(List<Project> projects, ProjectVersionRef pvr) {
        for (Project p : projects) {
            if (!p.getKey().equals(pvr)) continue;
            return p;
        }
        return null;
    }

    public ProjectVersionRef rewritePOMs(Set<Project> changed) throws ManipulationException {
        ProjectVersionRef result = null;
        this.manifestComment = "Modified by POM Manipulation Extension for Maven " + ManifestUtils.getManifestInformation(PomIO.class);
        for (Project project : changed) {
            if (project.isExecutionRoot()) {
                result = project.getKey();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{} modified! Rewriting.", (Object)project);
            }
            File pom = project.getPom();
            Model model = project.getModel();
            logger.trace("Rewriting: {} in place of: {}{}       to POM: {}", new Object[]{model.getId(), project.getKey(), System.lineSeparator(), pom});
            this.write(project, pom, model);
            if (!pom.getName().equals("interpolated-pom.xml")) continue;
            File dir = pom.getParentFile();
            pom = dir == null ? new File("pom.xml") : new File(dir, "pom.xml");
            this.write(project, pom, model);
        }
        return result;
    }

    public void writeModel(Model model, File target) throws ManipulationException {
        try {
            new MavenXpp3Writer().write((Writer)new FileWriter(target), model);
        }
        catch (IOException e) {
            throw new ManipulationException("Unable to write file", (Throwable)e);
        }
    }

    private void write(Project project, File pom, Model model) throws ManipulationException {
        try {
            LineSeparator ls = FileIO.determineEOL(pom);
            MavenProject mp = new MavenProject(model);
            ModelETLRequest request = new ModelETLRequest();
            request.setLineSeparator(ls.value());
            request.setProject(mp);
            request.setReleaseDescriptor((ReleaseDescriptor)ReleaseUtils.buildReleaseDescriptor((ReleaseDescriptorBuilder)this.releaseDescriptorBuilder));
            JDomModelETL etl = this.modelETLFactories.newInstance(request);
            etl.extract(pom);
            Document doc = (Document)FieldUtils.getDeclaredField(JDomModelETL.class, (String)"document", (boolean)true).get(etl);
            this.jdomModelConverter.convertModelToJDOM(model, doc);
            if (project.isExecutionRoot()) {
                String outtro = (String)FieldUtils.getDeclaredField(JDomModelETL.class, (String)"outtro", (boolean)true).get(etl);
                String commentStart = ls.value() + "<!--" + ls.value();
                String commentEnd = ls.value() + "-->" + ls.value();
                if (outtro.equals(ls.value())) {
                    logger.debug("Outtro contains newlines only");
                    outtro = commentStart + this.manifestComment + commentEnd;
                } else {
                    outtro = outtro.replaceAll("Modified by.*", this.manifestComment);
                }
                FieldUtils.writeDeclaredField((Object)etl, (String)"outtro", (Object)outtro, (boolean)true);
            }
            etl.load(pom);
        }
        catch (IllegalAccessException | ReleaseExecutionException e) {
            throw new ManipulationException("Failed to parse POM for rewrite: {}. Reason: ", new Object[]{pom, e.getMessage(), e});
        }
    }

    private List<PomPeek> peekAtPomHierarchy(File topPom) throws ManipulationException {
        ArrayList<PomPeek> peeked = new ArrayList<PomPeek>();
        try {
            LinkedList<File> pendingPoms = new LinkedList<File>();
            pendingPoms.add(topPom.getCanonicalFile());
            String topDir = topPom.getCanonicalFile().getParentFile().getCanonicalPath();
            HashSet<File> seen = new HashSet<File>();
            File topLevelParent = topPom;
            while (!pendingPoms.isEmpty()) {
                File pom = (File)pendingPoms.removeFirst();
                seen.add(pom);
                logger.debug("PEEK: {}", (Object)pom);
                PomPeek peek = new PomPeek(pom);
                if (this.parsePomTemplates || peek.getKey() != null) {
                    Set modules;
                    peeked.add(peek);
                    File dir = pom.getParentFile();
                    String relPath = peek.getParentRelativePath();
                    if (relPath != null) {
                        logger.debug("Found parent relativePath: {} in pom: {}", (Object)relPath, (Object)pom);
                        File parent = new File(dir, relPath);
                        if (parent.isDirectory()) {
                            parent = new File(parent, "pom.xml");
                        }
                        if ((parent = parent.getCanonicalFile()).getParentFile().getCanonicalPath().startsWith(topDir) && parent.exists() && !seen.contains(parent) && !pendingPoms.contains(parent)) {
                            topLevelParent = parent;
                            logger.debug("Possible top-level parent {}", (Object)parent);
                            pendingPoms.add(parent);
                        } else {
                            logger.debug("Skipping reference to non-existent parent relativePath: '{}' in: {}", (Object)relPath, (Object)pom);
                        }
                    }
                    if ((modules = peek.getModules()) == null || modules.isEmpty()) continue;
                    for (String module : modules) {
                        File modPom;
                        if (logger.isDebugEnabled()) {
                            logger.debug("Found module: {} in pom: {}", (Object)module, (Object)pom);
                        }
                        if ((modPom = new File(dir, module)).isDirectory()) {
                            modPom = new File(modPom, "pom.xml");
                        }
                        if (modPom.exists() && !seen.contains(modPom) && !pendingPoms.contains(modPom)) {
                            pendingPoms.addLast(modPom);
                            continue;
                        }
                        logger.debug("Skipping reference to non-existent module: '{}' in: {}", (Object)module, (Object)pom);
                    }
                    continue;
                }
                logger.debug("Skipping {} as its a template file.", (Object)pom);
            }
            HashSet<ProjectVersionRef> projectrefs = new HashSet<ProjectVersionRef>();
            for (PomPeek p : peeked) {
                if (p.getKey() != null) {
                    projectrefs.add(p.getKey());
                }
                if (!p.getPom().equals(topLevelParent)) continue;
                logger.debug("Setting top level parent to {} :: {}", (Object)p.getPom(), (Object)p.getKey());
                p.setInheritanceRoot(true);
            }
            for (PomPeek p : peeked) {
                if (p.getParentKey() != null && this.seenThisParent(projectrefs, p.getParentKey())) continue;
                logger.debug("Found a standalone pom {} :: {}", (Object)p.getPom(), (Object)p.getKey());
                p.setInheritanceRoot(true);
            }
        }
        catch (IOException e) {
            throw new ManipulationException("Problem peeking at POMs.", (Throwable)e);
        }
        return peeked;
    }

    private boolean seenThisParent(HashSet<ProjectVersionRef> projectrefs, ProjectVersionRef parentKey) {
        for (ProjectVersionRef p : projectrefs) {
            if (!p.versionlessEquals(parentKey)) continue;
            return true;
        }
        return false;
    }
}

