/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.io;

import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.reflect.FieldUtils;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuilder;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.transform.ModelETLRequest;
import org.apache.maven.shared.release.transform.jdom2.JDomModelETL;
import org.apache.maven.shared.release.transform.jdom2.JDomModelETLFactory;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.jdom.JDOMSettingsConverter;
import org.commonjava.maven.ext.common.util.LineSeparator;
import org.commonjava.maven.ext.io.FileIO;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class SettingsIO {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final JDOMSettingsConverter jdomSettingsConverter = new JDOMSettingsConverter();
    private final JDomModelETLFactory modelETLFactories = new JDomModelETLFactory();
    private final SettingsBuilder settingsBuilder;

    @Inject
    public SettingsIO(SettingsBuilder settingsBuilder) {
        this.settingsBuilder = settingsBuilder;
    }

    public void write(Settings settings, File settingsFile) throws ManipulationException {
        try {
            LineSeparator ls;
            String intro = "";
            String outtro = "";
            if (settingsFile.length() > 0L) {
                ls = FileIO.determineEOL(settingsFile);
                ModelETLRequest request = new ModelETLRequest();
                request.setLineSeparator(ls.value());
                JDomModelETL etl = this.modelETLFactories.newInstance(request);
                etl.extract(settingsFile);
                intro = (String)FieldUtils.getDeclaredField(JDomModelETL.class, (String)"intro", (boolean)true).get(etl);
                outtro = (String)FieldUtils.getDeclaredField(JDomModelETL.class, (String)"outtro", (boolean)true).get(etl);
            } else {
                ls = LineSeparator.NL;
            }
            this.jdomSettingsConverter.setLineSeparator(ls.value());
            this.jdomSettingsConverter.write(settings, settingsFile, intro, outtro);
        }
        catch (IOException | IllegalAccessException | ReleaseExecutionException | JDOMException e) {
            throw new ManipulationException("Failed to create repo removal backup settings.xml file: {}", new Object[]{settingsFile, e});
        }
    }

    public void update(Settings settings, File settingsFile) throws ManipulationException {
        try {
            Settings defaultSettings = new Settings();
            if (settingsFile.exists()) {
                DefaultSettingsBuildingRequest settingsRequest = new DefaultSettingsBuildingRequest();
                settingsRequest.setGlobalSettingsFile(settingsFile);
                defaultSettings = this.settingsBuilder.build((SettingsBuildingRequest)settingsRequest).getEffectiveSettings();
            }
            for (Profile profile : settings.getProfiles()) {
                defaultSettings.getProfiles().removeIf(profile1 -> profile1.getId().equals(profile.getId()));
                defaultSettings.addProfile(profile);
            }
            for (String activeProfile : settings.getActiveProfiles()) {
                defaultSettings.getActiveProfiles().removeIf(s -> s.equals(activeProfile));
                defaultSettings.addActiveProfile(activeProfile);
            }
            for (Mirror mirror : settings.getMirrors()) {
                defaultSettings.addMirror(mirror);
            }
            for (Proxy proxy : settings.getProxies()) {
                defaultSettings.addProxy(proxy);
            }
            for (Server server : settings.getServers()) {
                defaultSettings.addServer(server);
            }
            for (String pluginGroup : settings.getPluginGroups()) {
                defaultSettings.addPluginGroup(pluginGroup);
            }
            if (settings.getLocalRepository() != null) {
                defaultSettings.setLocalRepository(settings.getLocalRepository());
            }
            this.write(defaultSettings, settingsFile);
        }
        catch (SettingsBuildingException e) {
            throw new ManipulationException("Failed to build existing settings.xml for repo removal backup.", new Object[]{settingsFile, e.getMessage(), e});
        }
    }
}

