/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.event;

import java.util.Map;
import org.commonjava.maven.galley.event.EventMetadata;
import org.commonjava.maven.galley.model.Transfer;
import org.slf4j.MDC;

public class FileEvent {
    public static final String CREATION_THREAD_NAME = "creation-thread-name";
    private final Transfer transfer;
    private final EventMetadata eventMetadata;
    private final Map<String, String> contextMap;

    protected FileEvent(Transfer transfer, EventMetadata eventMetadata) {
        this.transfer = transfer;
        this.eventMetadata = eventMetadata;
        MDC.put((String)CREATION_THREAD_NAME, (String)Thread.currentThread().getName());
        this.contextMap = MDC.getCopyOfContextMap();
    }

    public EventMetadata getEventMetadata() {
        return this.eventMetadata;
    }

    public Transfer getTransfer() {
        return this.transfer;
    }

    public String getExtraInfo() {
        return "";
    }

    public Map<String, String> getMDCMap() {
        return this.contextMap;
    }

    public String toString() {
        return String.format("%s [extra-info=%s, transfer=%s]", this.getClass().getSimpleName(), this.getExtraInfo(), this.transfer);
    }
}

