/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.event;

import java.util.Map;
import org.commonjava.maven.galley.event.EventMetadata;
import org.commonjava.maven.galley.model.Resource;
import org.slf4j.MDC;

public class FileNotFoundEvent {
    private final Resource resource;
    private final EventMetadata eventMetadata;
    private final Map<String, String> contextMap;

    public FileNotFoundEvent(Resource resource, EventMetadata eventMetadata) {
        this.resource = resource;
        this.eventMetadata = eventMetadata;
        MDC.put((String)"creation-thread-name", (String)Thread.currentThread().getName());
        this.contextMap = MDC.getCopyOfContextMap();
    }

    public EventMetadata getEventMetadata() {
        return this.eventMetadata;
    }

    public Resource getResource() {
        return this.resource;
    }

    public Map<String, String> getMDCMap() {
        return this.contextMap;
    }
}

