/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.maven.model.view;

import org.commonjava.maven.galley.maven.model.view.MavenPomElementView;
import org.commonjava.maven.galley.maven.model.view.MavenPomView;
import org.commonjava.maven.galley.maven.model.view.OriginInfo;
import org.w3c.dom.Element;

public class RepositoryView
extends MavenPomElementView {
    private String url;
    private String name;
    private String id;

    public RepositoryView(MavenPomView xmlView, Element element, OriginInfo originInfo) {
        super(xmlView, element, originInfo);
    }

    public synchronized String getUrl() {
        if (this.url == null) {
            this.url = this.getValue("url/text()");
        }
        return this.url;
    }

    public synchronized String getName() {
        if (this.name == null) {
            this.name = this.getValue("name/text()");
        }
        if (this.name == null) {
            this.name = this.getId();
        }
        return this.name;
    }

    public String getId() {
        if (this.id == null) {
            this.id = this.getValue("id/text()");
        }
        return this.id;
    }

    public String toString() {
        return String.format("RepositoryView [%s] (url=%s, id=%s)", this.getName(), this.getUrl(), this.getId());
    }

    public boolean isReleasesEnabled() {
        String value = this.getValue("releases/enabled/text()");
        return value == null || Boolean.parseBoolean(value);
    }

    public boolean isSnapshotsEnabled() {
        String value = this.getValue("snapshots/enabled/text()");
        return value != null && Boolean.parseBoolean(value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        String repositoryId = this.getId();
        result = 31 * result + (repositoryId == null ? 0 : repositoryId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        String repositoryId = this.getId();
        RepositoryView other = (RepositoryView)obj;
        String oRepositoryId = other.getId();
        if (repositoryId == null) {
            return oRepositoryId == null;
        }
        return repositoryId.equals(oRepositoryId);
    }
}

